/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.stream.events;

import weblogic.xml.stream.StartDocument;
import weblogic.xml.stream.events.ElementEvent;

public class StartDocumentEvent
extends ElementEvent
implements StartDocument {
    protected String systemId = null;
    protected String encodingScheme = "UTF-8";
    protected boolean standalone = true;
    protected String version = "1.0";
    private boolean encodingSchemeSet = false;
    private boolean standaloneSet = false;

    public StartDocumentEvent() {
        this.init();
    }

    protected void init() {
        this.type = 256;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getCharacterEncodingScheme() {
        return this.encodingScheme;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public String getVersion() {
        return this.version;
    }

    public void setStandalone(String string) {
        this.standaloneSet = true;
        if (string == null) {
            this.standalone = true;
            return;
        }
        this.standalone = string.equals("yes");
    }

    public boolean encodingSet() {
        return this.encodingSchemeSet;
    }

    public boolean standaloneSet() {
        return this.standaloneSet;
    }

    public void setEncoding(String string) {
        this.encodingScheme = string;
        this.encodingSchemeSet = true;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String toString() {
        String string = "<?xml version=\"" + this.version + "\"";
        string = string + " encoding='" + this.encodingScheme + "'";
        string = this.standalone ? string + " standalone='yes'?>" : string + " standalone='no'?>";
        return string;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return object instanceof StartDocumentEvent;
    }
}

