/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.stream.events;

import weblogic.xml.stream.Location;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.events.ElementTypeNames;
import weblogic.xml.stream.events.LocationImpl;

public class ElementEvent
implements XMLEvent,
Cloneable {
    protected int type;
    protected XMLName name = null;
    protected Location location = null;
    protected String content = null;
    protected XMLName schemaType = null;

    public ElementEvent() {
        this.init();
    }

    public ElementEvent(int n, XMLName xMLName) {
        this.init();
        this.type = n;
        this.name = xMLName;
    }

    protected void init() {
        this.type = 1;
    }

    public int getType() {
        return this.type;
    }

    protected void setType(int n) {
        this.type = n;
    }

    public void setName(XMLName xMLName) {
        this.name = xMLName;
    }

    public XMLName getName() {
        return this.name;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Location getLocation() {
        if (this.location == null) {
            return new LocationImpl(0, 0);
        }
        return this.location;
    }

    public String getTypeAsString() {
        return ElementTypeNames.getName((int)this.type);
    }

    public boolean isStartElement() {
        return (this.type & 2) != 0;
    }

    public boolean isEndElement() {
        return (this.type & 4) != 0;
    }

    public boolean isEntityReference() {
        return (this.type & 0x2000) != 0;
    }

    public boolean isStartPrefixMapping() {
        return (this.type & 0x400) != 0;
    }

    public boolean isEndPrefixMapping() {
        return (this.type & 0x800) != 0;
    }

    public boolean isChangePrefixMapping() {
        return (this.type & 0x1000) != 0;
    }

    public boolean isProcessingInstruction() {
        return (this.type & 8) != 0;
    }

    public boolean isCharacterData() {
        return (this.type & 0x10) != 0;
    }

    public boolean isSpace() {
        return (this.type & 0x40) != 0;
    }

    public boolean isNull() {
        return (this.type & 0x80) != 0;
    }

    public boolean isStartDocument() {
        return (this.type & 0x100) != 0;
    }

    public boolean isEndDocument() {
        return (this.type & 0x200) != 0;
    }

    public XMLName getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(XMLName xMLName) {
        this.schemaType = xMLName;
    }

    protected static boolean compare(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (!this.hasName() && object == null) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof XMLEvent)) {
            return false;
        }
        XMLEvent xMLEvent = (XMLEvent)object;
        return this.name.equals(xMLEvent.getName());
    }
}

