/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types.util;

import java.util.Calendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import weblogic.xml.schema.types.util.XSDDateDeserializer;

public class XSDMonthDayDeserializer
extends XSDDateDeserializer {
    private static final String DELIMITERS = "-,+,:,Z";
    private static final String MINUS = "-";

    protected void init(Calendar calendar) {
        super.init(calendar);
        this.initDate(calendar);
    }

    protected void setCalendarFields(Calendar calendar, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITERS, true);
        this.setDate(calendar, stringTokenizer);
        this.fillTimeFields(calendar);
        this.setTimeZone(calendar, stringTokenizer);
    }

    protected void setDate(Calendar calendar, StringTokenizer stringTokenizer) {
        try {
            this.setMonth(calendar, stringTokenizer);
            if (!stringTokenizer.nextToken().equals(MINUS)) {
                throw new IllegalArgumentException("Invalid month / day delimiter.");
            }
            this.setDay(calendar, stringTokenizer);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException("Missing element in date fields.");
        }
    }

    protected void initDate(Calendar calendar) {
        calendar.set(1, 1972);
    }

    protected void setMonth(Calendar calendar, StringTokenizer stringTokenizer) {
        try {
            String string = stringTokenizer.nextToken();
            if (string.equals(MINUS)) {
                string = stringTokenizer.nextToken();
                if (string.equals(MINUS)) {
                    string = stringTokenizer.nextToken();
                } else {
                    throw new IllegalArgumentException("Invalid delimiter.");
                }
            }
            if (string.length() != 2) {
                throw new IllegalArgumentException("Month has invalid length.");
            }
            calendar.set(2, Integer.parseInt(string) - 1);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException("Missing month.");
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Month is not an int.");
        }
    }
}

