/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types.util;

import java.math.BigInteger;
import weblogic.xml.schema.types.Duration;
import weblogic.xml.schema.types.util.XSDDurationDeserializer;

public class XSDDurationDeserializer {
    private static final char YEAR = 'Y';
    private static final char MONTH = 'M';
    private static final char DAY = 'D';
    private static final char HOUR = 'H';
    private static final char MINUTE = 'M';
    private static final char SECOND = 'S';

    public static Duration getDuration(String string) {
        Duration duration = new Duration();
        int n = 0;
        if (string.startsWith("-P")) {
            duration.setSignum(-1);
            n = 2;
        } else if (string.startsWith("P")) {
            n = 1;
        } else {
            throw new IllegalArgumentException("Invalid duration format, 'P' is required.");
        }
        BigIntegerObjectHolder bigIntegerObjectHolder = new BigIntegerObjectHolder();
        n = XSDDurationDeserializer.setDate(duration, string, n, bigIntegerObjectHolder);
        XSDDurationDeserializer.setTime(duration, string, n, bigIntegerObjectHolder);
        return duration;
    }

    private static int setDate(Duration duration, String string, int n, BigIntegerObjectHolder bigIntegerObjectHolder) {
        n = XSDDurationDeserializer.setYears(duration, string, n, bigIntegerObjectHolder);
        n = XSDDurationDeserializer.setMonths(duration, string, n, bigIntegerObjectHolder);
        n = XSDDurationDeserializer.setDays(duration, string, n, bigIntegerObjectHolder);
        return n;
    }

    private static int setYears(Duration duration, String string, int n, BigIntegerObjectHolder bigIntegerObjectHolder) {
        int n2 = XSDDurationDeserializer.setBigIntValue(bigIntegerObjectHolder, string, n, 'Y');
        duration.setYears(bigIntegerObjectHolder.getValue());
        return n2;
    }

    private static int setMonths(Duration duration, String string, int n, BigIntegerObjectHolder bigIntegerObjectHolder) {
        int n2 = XSDDurationDeserializer.setBigIntValue(bigIntegerObjectHolder, string, n, 'M');
        duration.setMonths(bigIntegerObjectHolder.getValue());
        return n2;
    }

    private static int setDays(Duration duration, String string, int n, BigIntegerObjectHolder bigIntegerObjectHolder) {
        int n2 = XSDDurationDeserializer.setBigIntValue(bigIntegerObjectHolder, string, n, 'D');
        duration.setDays(bigIntegerObjectHolder.getValue());
        return n2;
    }

    private static int setTime(Duration duration, String string, int n, BigIntegerObjectHolder bigIntegerObjectHolder) {
        int n2 = string.length();
        if (n2 <= n) {
            return n;
        }
        if (string.charAt(n) != 'T') {
            throw new IllegalArgumentException("Invalid duration format, missing delimiter 'T'.");
        }
        if (n2 <= n + 1) {
            throw new IllegalArgumentException("Invalid duration format, contains 'T' but no time items.");
        }
        ++n;
        n = XSDDurationDeserializer.setHours(duration, string, n, bigIntegerObjectHolder);
        n = XSDDurationDeserializer.setMinutes(duration, string, n, bigIntegerObjectHolder);
        n = XSDDurationDeserializer.setSeconds(duration, string, n, bigIntegerObjectHolder);
        return n;
    }

    private static int setHours(Duration duration, String string, int n, BigIntegerObjectHolder bigIntegerObjectHolder) {
        int n2 = XSDDurationDeserializer.setBigIntValue(bigIntegerObjectHolder, string, n, 'H');
        duration.setHours(bigIntegerObjectHolder.getValue());
        return n2;
    }

    private static int setMinutes(Duration duration, String string, int n, BigIntegerObjectHolder bigIntegerObjectHolder) {
        int n2 = XSDDurationDeserializer.setBigIntValue(bigIntegerObjectHolder, string, n, 'M');
        duration.setMinutes(bigIntegerObjectHolder.getValue());
        return n2;
    }

    private static int setSeconds(Duration duration, String string, int n, BigIntegerObjectHolder bigIntegerObjectHolder) {
        int n2 = XSDDurationDeserializer.setBigIntValue(bigIntegerObjectHolder, string, n, '.');
        BigInteger bigInteger = bigIntegerObjectHolder.getValue();
        n2 = XSDDurationDeserializer.setBigIntValue(bigIntegerObjectHolder, string, n2, 'S');
        BigInteger bigInteger2 = bigIntegerObjectHolder.getValue();
        if (bigInteger != null) {
            if (bigInteger2 == null) {
                throw new IllegalArgumentException("Invalid format in seconds token.");
            }
            duration.setSeconds(bigInteger);
            duration.setSecondFraction(bigInteger2);
        } else {
            duration.setSeconds(bigInteger2);
        }
        return n2;
    }

    private static int setBigIntValue(BigIntegerObjectHolder bigIntegerObjectHolder, String string, int n, char c) {
        int n2 = string.indexOf(c, n);
        if (n2 != -1) {
            String string2 = string.substring(n, n2);
            if (string2.startsWith("-")) {
                throw new IllegalArgumentException("Invalid duration format, contains '-' at an unallowed position.");
            }
            BigInteger bigInteger = new BigInteger(string2);
            bigIntegerObjectHolder.setValue(bigInteger);
            return n2 + 1;
        }
        bigIntegerObjectHolder.setValue(null);
        return n;
    }
}

