/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;

public final class XSDUnsignedShort
extends Number
implements XSDBuiltinType,
Comparable {
    final int javaValue;
    final String xmlValue;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "unsignedShort");
    public static final int MAX_INT_VALUE = 65535;
    public static final XSDUnsignedShort MAX_VALUE = new XSDUnsignedShort(65535);

    public static XSDUnsignedShort createFromXml(String string) {
        return new XSDUnsignedShort(string);
    }

    public static XSDUnsignedShort createFromInt(int n) {
        return new XSDUnsignedShort(n);
    }

    private XSDUnsignedShort(String string) {
        this.xmlValue = string;
        this.javaValue = XSDUnsignedShort.convertXml(string);
    }

    private XSDUnsignedShort(int n) {
        this.javaValue = n;
        this.xmlValue = XSDUnsignedShort.getXml(n);
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDUnsignedShort.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return new Integer(this.javaValue);
    }

    public int intValue() {
        return this.javaValue;
    }

    public long longValue() {
        return this.javaValue;
    }

    public float floatValue() {
        return this.javaValue;
    }

    public double doubleValue() {
        return this.javaValue;
    }

    public int compareTo(XSDUnsignedShort xSDUnsignedShort) {
        int n = this.javaValue;
        int n2 = xSDUnsignedShort.javaValue;
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public int compareTo(Object object) {
        return this.compareTo((XSDUnsignedShort)object);
    }

    public static int convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        try {
            int n = Integer.parseInt(TypeUtils.trimInitialPlus(string));
            if (!XSDUnsignedShort.isLegalJavaValue(n)) {
                String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME);
                throw new IllegalArgumentException(string2);
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME, numberFormatException);
            throw new IllegalArgumentException(string3);
        }
    }

    public static void validateXml(String string) {
        XSDUnsignedShort.convertXml(string);
    }

    public static String getXml(int n) {
        if (!XSDUnsignedShort.isLegalJavaValue(n)) {
            String string = TypeUtils.createInvalidJavaArgMsg(new Integer(n), XML_TYPE_NAME);
            throw new IllegalArgumentException(string);
        }
        return Integer.toString(n);
    }

    public static String getCanonicalXml(int n) {
        return XSDUnsignedShort.getXml(n);
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDUnsignedShort) {
            return ((XSDUnsignedShort)object).javaValue == this.javaValue;
        }
        return false;
    }

    public final int hashCode() {
        return this.javaValue;
    }

    private static boolean isLegalJavaValue(int n) {
        return n >= 0 && n <= 65535;
    }
}

