/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import java.math.BigInteger;
import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;
import weblogic.xml.schema.types.XSDIntegerRestriction;

public final class XSDUnsignedLong
extends XSDIntegerRestriction
implements XSDBuiltinType,
Comparable {
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "unsignedLong");
    private static final BigInteger MAX_INTEGER_VALUE = new BigInteger("18446744073709551615");
    public static final XSDUnsignedLong MAX_VALUE = new XSDUnsignedLong(MAX_INTEGER_VALUE);

    public static XSDUnsignedLong createFromXml(String string) {
        return new XSDUnsignedLong(string);
    }

    public static XSDUnsignedLong createFromBigInteger(BigInteger bigInteger) {
        return new XSDUnsignedLong(bigInteger);
    }

    private XSDUnsignedLong(String string) {
        super(XSDUnsignedLong.convertXml(string), string);
    }

    private XSDUnsignedLong(BigInteger bigInteger) {
        super(bigInteger, XSDUnsignedLong.getXml(bigInteger));
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public static BigInteger convertXml(String string) {
        BigInteger bigInteger = XSDUnsignedLong.convertXml(string, XML_TYPE_NAME);
        if (!XSDUnsignedLong.isLegalJavaValue(bigInteger)) {
            String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME);
            throw new IllegalArgumentException(string2);
        }
        return bigInteger;
    }

    public static void validateXml(String string) {
        XSDUnsignedLong.convertXml(string);
    }

    public static String getXml(BigInteger bigInteger) {
        if (!XSDUnsignedLong.isLegalJavaValue(bigInteger)) {
            String string = TypeUtils.createInvalidJavaArgMsg(bigInteger, XML_TYPE_NAME);
            throw new IllegalArgumentException(string);
        }
        return XSDIntegerRestriction.getXml(bigInteger);
    }

    public static String getCanonicalXml(BigInteger bigInteger) {
        return XSDIntegerRestriction.getCanonicalXml(bigInteger);
    }

    private static boolean isLegalJavaValue(BigInteger bigInteger) {
        if (bigInteger.signum() < 0) {
            return false;
        }
        return bigInteger.compareTo(MAX_INTEGER_VALUE) <= 0;
    }
}

