/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;

public final class XSDUnsignedInt
extends Number
implements XSDBuiltinType,
Comparable {
    final long javaValue;
    final String xmlValue;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "unsignedInt");
    public static final long MAX_LONG_VALUE = 0xFFFFFFFFL;
    public static final XSDUnsignedInt MAX_VALUE = new XSDUnsignedInt(0xFFFFFFFFL);

    public static XSDUnsignedInt createFromXml(String string) {
        return new XSDUnsignedInt(string);
    }

    public static XSDUnsignedInt createFromLong(long l) {
        return new XSDUnsignedInt(l);
    }

    private XSDUnsignedInt(String string) {
        this.xmlValue = string;
        this.javaValue = XSDUnsignedInt.convertXml(string);
    }

    private XSDUnsignedInt(long l) {
        this.javaValue = l;
        this.xmlValue = XSDUnsignedInt.getXml(l);
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDUnsignedInt.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return new Long(this.javaValue);
    }

    public int intValue() {
        return (int)this.javaValue;
    }

    public long longValue() {
        return this.javaValue;
    }

    public float floatValue() {
        return this.javaValue;
    }

    public double doubleValue() {
        return this.javaValue;
    }

    public int compareTo(XSDUnsignedInt xSDUnsignedInt) {
        long l = this.javaValue;
        long l2 = xSDUnsignedInt.javaValue;
        return l < l2 ? -1 : (l == l2 ? 0 : 1);
    }

    public int compareTo(Object object) {
        return this.compareTo((XSDUnsignedInt)object);
    }

    public static long convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        try {
            long l = Long.parseLong(TypeUtils.trimInitialPlus(string));
            if (!XSDUnsignedInt.isLegalJavaValue(l)) {
                String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME);
                throw new IllegalArgumentException(string2);
            }
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME, numberFormatException);
            throw new IllegalArgumentException(string3);
        }
    }

    public static void validateXml(String string) {
        XSDUnsignedInt.convertXml(string);
    }

    public static String getXml(long l) {
        if (!XSDUnsignedInt.isLegalJavaValue(l)) {
            String string = TypeUtils.createInvalidJavaArgMsg(new Long(l), XML_TYPE_NAME);
            throw new IllegalArgumentException(string);
        }
        return Long.toString(l);
    }

    public static String getCanonicalXml(long l) {
        return XSDUnsignedInt.getXml(l);
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDUnsignedInt) {
            return ((XSDUnsignedInt)object).javaValue == this.javaValue;
        }
        return false;
    }

    public final int hashCode() {
        return (int)(this.javaValue ^ this.javaValue >>> 32);
    }

    private static boolean isLegalJavaValue(long l) {
        return l >= 0L && l <= 0xFFFFFFFFL;
    }
}

