/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;
import weblogic.xml.schema.types.XSDStringRestriction;

public final class XSDString
extends XSDStringRestriction
implements XSDBuiltinType,
Comparable {
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "string");

    public static XSDString createFromXml(String string) {
        return new XSDString(string, false);
    }

    public static XSDString createFromJava(String string) {
        return new XSDString(string, true);
    }

    private XSDString(String string, boolean bl) {
        super(string);
        XSDString.validateXml(string, bl);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public static String convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        XSDString.validateXml(string, false);
        return string;
    }

    public static void validateXml(String string, boolean bl) {
        TypeUtils.validateXml(string, bl);
    }

    public static String getXml(String string, boolean bl) {
        return XSDString.getCanonicalXml(string, bl);
    }

    public static String getCanonicalXml(String string, boolean bl) {
        XSDString.validateXml(string, bl);
        return string;
    }
}

