/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import java.util.Map;
import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;

public final class XSDQName
implements XSDBuiltinType {
    private final QName javaValue;
    private final String prefix;
    private final String xmlValue;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "QName");
    private static final char NAMESPACE_SEP = ':';
    private static final String EMPTY_PREFIX = "";

    public static XSDQName createFromXml(String string, String string2) {
        return new XSDQName(string, string2);
    }

    public static XSDQName createFromXml(String string, Map map) {
        return new XSDQName(string, map);
    }

    public static XSDQName createFromQName(QName qName, String string) {
        return new XSDQName(qName, string);
    }

    private XSDQName(String string, Map map) {
        String string2;
        this.xmlValue = string;
        int n = XSDQName.indexOfNamespaceSeperator(string);
        if (n < 0) {
            this.prefix = EMPTY_PREFIX;
            string2 = string;
        } else {
            this.prefix = string.substring(0, n);
            string2 = string.substring(1 + n);
        }
        String string3 = XSDQName.getUriFromMap(this.prefix, map, false);
        this.javaValue = new QName(string3, string2);
    }

    private static String getUriFromMap(String string, Map map, boolean bl) {
        Object v = map.get(string);
        if (v == null) {
            if (bl) {
                return null;
            }
            String string2 = "unable to locate namespace URI for prefix \"" + string + "\"";
            throw new IllegalArgumentException(string2);
        }
        if (!(v instanceof String)) {
            String string3 = "supplied prefixToNamespaceMap found  non string object for prefix \"" + string + "\": " + v;
            throw new IllegalArgumentException(string3);
        }
        return (String)v;
    }

    private XSDQName(String string, String string2) {
        this.xmlValue = string;
        int n = XSDQName.indexOfNamespaceSeperator(string);
        if (n < 0) {
            this.prefix = EMPTY_PREFIX;
            this.javaValue = new QName(string);
        } else {
            this.prefix = string.substring(0, n);
            String string3 = string.substring(1 + n);
            this.javaValue = new QName(string2, string3);
        }
    }

    private static int indexOfNamespaceSeperator(String string) {
        int n = string.indexOf(58);
        if (n == 0) {
            String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME) + " - an empty prefix is not allowed in xml namespaces";
            throw new IllegalArgumentException(string2);
        }
        int n2 = string.indexOf(58, n + 1);
        if (n2 >= 0) {
            String string3 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME) + " - extra namespace separator found at character " + n2;
            throw new IllegalArgumentException(string3);
        }
        return n;
    }

    private XSDQName(QName qName, String string) {
        this.javaValue = qName;
        this.prefix = string;
        this.xmlValue = string + ':' + qName.getLocalPart();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return this.xmlValue;
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return this.javaValue;
    }

    public QName getQName() {
        return this.javaValue;
    }

    public static QName convertXml(String string, String string2) {
        return XSDQName.convertXml(string, string2, false);
    }

    public static QName convertXml(String string, String string2, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("qname cannot be null");
        }
        if (string2 == null && !bl) {
            throw new IllegalArgumentException("namespaceUri cannot be null");
        }
        return new QName(string2, XSDQName.getLocalPartFromQName(string));
    }

    public static QName convertXml(String string, Map map) {
        return XSDQName.convertXml(string, map, false);
    }

    public static QName convertXml(String string, Map map, boolean bl) {
        String string2;
        String string3;
        if (string == null) {
            throw new IllegalArgumentException("qname cannot be null");
        }
        if (map == null) {
            throw new IllegalArgumentException("prefixToNamespaceMap cannot be null");
        }
        int n = XSDQName.indexOfNamespaceSeperator(string);
        if (n < 0) {
            string3 = EMPTY_PREFIX;
            string2 = string;
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(1 + n);
        }
        String string4 = XSDQName.getUriFromMap(string3, map, bl);
        return new QName(string4, string2);
    }

    public static String getPrefixFromQName(String string) {
        int n = XSDQName.indexOfNamespaceSeperator(string);
        if (n < 0) {
            return EMPTY_PREFIX;
        }
        return string.substring(0, n);
    }

    public static String getLocalPartFromQName(String string) {
        int n = XSDQName.indexOfNamespaceSeperator(string);
        if (n < 0) {
            return string;
        }
        return string.substring(++n);
    }

    public static void validateXml(String string, boolean bl) {
        int n = XSDQName.indexOfNamespaceSeperator(string);
        if (bl) {
            TypeUtils.validateXml(string, bl);
        }
    }

    public static String getXml(QName qName, String string) {
        return XSDQName.getXml(qName.getNamespaceURI(), qName.getLocalPart(), string);
    }

    public static String getCanonicalXml(QName qName, String string) {
        return XSDQName.getXml(qName, string);
    }

    public static String getXml(String string, String string2, String string3) {
        if (string != null && string3 != null && string3.length() > 0) {
            return string3 + ':' + string2;
        }
        return string2;
    }

    public String toString() {
        return this.javaValue.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDQName) {
            XSDQName xSDQName = (XSDQName)object;
            return this.javaValue.equals(xSDQName.javaValue);
        }
        return false;
    }

    public final int hashCode() {
        return this.javaValue.hashCode();
    }
}

