/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import java.math.BigInteger;
import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;
import weblogic.xml.schema.types.XSDIntegerRestriction;

public final class XSDPositiveInteger
extends XSDIntegerRestriction
implements XSDBuiltinType,
Comparable {
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "positiveInteger");

    public static XSDPositiveInteger createFromXml(String string) {
        return new XSDPositiveInteger(string);
    }

    public static XSDPositiveInteger createFromBigInteger(BigInteger bigInteger) {
        return new XSDPositiveInteger(bigInteger);
    }

    private XSDPositiveInteger(String string) {
        super(XSDPositiveInteger.convertXml(string), string);
    }

    private XSDPositiveInteger(BigInteger bigInteger) {
        super(bigInteger, XSDPositiveInteger.getXml(bigInteger));
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public static BigInteger convertXml(String string) {
        BigInteger bigInteger = XSDPositiveInteger.convertXml(string, XML_TYPE_NAME);
        if (!XSDPositiveInteger.isLegalJavaValue(bigInteger)) {
            String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME);
            throw new IllegalArgumentException(string2);
        }
        return bigInteger;
    }

    public static void validateXml(String string) {
        XSDPositiveInteger.convertXml(string);
    }

    public static String getXml(BigInteger bigInteger) {
        if (!XSDPositiveInteger.isLegalJavaValue(bigInteger)) {
            String string = TypeUtils.createInvalidJavaArgMsg(bigInteger, XML_TYPE_NAME);
            throw new IllegalArgumentException(string);
        }
        return XSDIntegerRestriction.getXml(bigInteger);
    }

    public static String getCanonicalXml(BigInteger bigInteger) {
        return XSDIntegerRestriction.getCanonicalXml(bigInteger);
    }

    private static boolean isLegalJavaValue(BigInteger bigInteger) {
        return bigInteger.signum() > 0;
    }
}

