/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;
import weblogic.xml.schema.types.XSDStringRestriction;

public final class XSDNormalizedString
extends XSDStringRestriction
implements XSDBuiltinType,
Comparable {
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "normalizedString");

    public static XSDNormalizedString createFromXml(String string) {
        return new XSDNormalizedString(string, false);
    }

    public static XSDNormalizedString createFromJava(String string) {
        return new XSDNormalizedString(string, true);
    }

    private XSDNormalizedString(String string, boolean bl) {
        super(string);
        XSDNormalizedString.validateXml(string, bl);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public static String convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        XSDNormalizedString.validateXml(string, false);
        return string;
    }

    public static void validateXml(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl && !TypeUtils.isXmlChar(c)) {
                String string2 = TypeUtils.createInvalidXmlCharMsg(c, i);
                throw new IllegalArgumentException(string2);
            }
            if (c != '\t' && c != '\n' && c != '\r') continue;
            String string3 = "invalid " + XML_TYPE_NAME + " character (" + string.charAt(i) + ") found at index " + i;
            throw new IllegalArgumentException(string3);
        }
    }

    public static String getXml(String string, boolean bl) {
        return XSDNormalizedString.getCanonicalXml(string, bl);
    }

    public static String getCanonicalXml(String string, boolean bl) {
        XSDNormalizedString.validateXml(string, bl);
        return string;
    }
}

