/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import java.math.BigInteger;
import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;
import weblogic.xml.schema.types.XSDIntegerRestriction;

public final class XSDNonNegativeInteger
extends XSDIntegerRestriction
implements XSDBuiltinType,
Comparable {
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "nonNegativeInteger");

    public static XSDNonNegativeInteger createFromXml(String string) {
        return new XSDNonNegativeInteger(string);
    }

    public static XSDNonNegativeInteger createFromBigInteger(BigInteger bigInteger) {
        return new XSDNonNegativeInteger(bigInteger);
    }

    private XSDNonNegativeInteger(String string) {
        super(XSDNonNegativeInteger.convertXml(string), string);
    }

    private XSDNonNegativeInteger(BigInteger bigInteger) {
        super(bigInteger, XSDNonNegativeInteger.getXml(bigInteger));
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public static BigInteger convertXml(String string) {
        BigInteger bigInteger = XSDNonNegativeInteger.convertXml(string, XML_TYPE_NAME);
        if (!XSDNonNegativeInteger.isLegalJavaValue(bigInteger)) {
            String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME);
            throw new IllegalArgumentException(string2);
        }
        return bigInteger;
    }

    public static void validateXml(String string) {
        XSDNonNegativeInteger.convertXml(string);
    }

    public static String getXml(BigInteger bigInteger) {
        if (!XSDNonNegativeInteger.isLegalJavaValue(bigInteger)) {
            String string = TypeUtils.createInvalidJavaArgMsg(bigInteger, XML_TYPE_NAME);
            throw new IllegalArgumentException(string);
        }
        return XSDIntegerRestriction.getXml(bigInteger);
    }

    public static String getCanonicalXml(BigInteger bigInteger) {
        return XSDIntegerRestriction.getCanonicalXml(bigInteger);
    }

    private static boolean isLegalJavaValue(BigInteger bigInteger) {
        return bigInteger.signum() >= 0;
    }
}

