/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import java.math.BigInteger;
import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;
import weblogic.xml.schema.types.XSDIntegerRestriction;

public final class XSDNegativeInteger
extends XSDIntegerRestriction
implements XSDBuiltinType,
Comparable {
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "negativeInteger");

    public static XSDNegativeInteger createFromXml(String string) {
        return new XSDNegativeInteger(string);
    }

    public static XSDNegativeInteger createFromBigInteger(BigInteger bigInteger) {
        return new XSDNegativeInteger(bigInteger);
    }

    private XSDNegativeInteger(String string) {
        super(XSDNegativeInteger.convertXml(string), string);
    }

    private XSDNegativeInteger(BigInteger bigInteger) {
        super(bigInteger, XSDNegativeInteger.getXml(bigInteger));
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public static BigInteger convertXml(String string) {
        BigInteger bigInteger = XSDNegativeInteger.convertXml(string, XML_TYPE_NAME);
        if (!XSDNegativeInteger.isLegalJavaValue(bigInteger)) {
            String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME);
            throw new IllegalArgumentException(string2);
        }
        return bigInteger;
    }

    public static void validateXml(String string) {
        XSDNegativeInteger.convertXml(string);
    }

    public static String getXml(BigInteger bigInteger) {
        if (!XSDNegativeInteger.isLegalJavaValue(bigInteger)) {
            String string = TypeUtils.createInvalidJavaArgMsg(bigInteger, XML_TYPE_NAME);
            throw new IllegalArgumentException(string);
        }
        return XSDIntegerRestriction.getXml(bigInteger);
    }

    public static String getCanonicalXml(BigInteger bigInteger) {
        return XSDIntegerRestriction.getCanonicalXml(bigInteger);
    }

    private static boolean isLegalJavaValue(BigInteger bigInteger) {
        return bigInteger.signum() < 0;
    }
}

