/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;
import weblogic.xml.schema.types.XSDStringRestriction;
import weblogic.xml.schema.types.util.NameValidator;

public final class XSDName
extends XSDStringRestriction
implements XSDBuiltinType,
Comparable {
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "Name");

    public static XSDName createFromXml(String string) {
        return new XSDName(string);
    }

    public static XSDName createFromJava(String string) {
        return new XSDName(string);
    }

    private XSDName(String string) {
        super(string);
        XSDName.validateXml(string);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public static String convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        XSDName.validateXml(string);
        return string;
    }

    public static void validateXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (!NameValidator.validName(string)) {
            String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME);
            throw new IllegalArgumentException(string2);
        }
    }

    public static String getXml(String string) {
        return XSDName.getCanonicalXml(string);
    }

    public static String getCanonicalXml(String string) {
        XSDName.validateXml(string);
        return string;
    }
}

