/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import weblogic.utils.StringUtils;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;
import weblogic.xml.schema.types.XSDNMToken;
import weblogic.xml.util.WhitespaceUtils;

public final class XSDNMTokens
implements XSDBuiltinType {
    final String[] javaValue;
    final String xmlValue;
    int hash = 0;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "NMTOKENS");

    public static XSDNMTokens createFromXml(String string) {
        return new XSDNMTokens(string);
    }

    public static XSDNMTokens createFromStrings(String[] stringArray) {
        return new XSDNMTokens(stringArray);
    }

    private XSDNMTokens(String string) {
        this.xmlValue = string;
        this.javaValue = XSDNMTokens.convertXml(string);
    }

    private XSDNMTokens(String[] stringArray) {
        this.javaValue = stringArray;
        this.xmlValue = XSDNMTokens.getCanonicalXml(stringArray);
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDNMTokens.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return this.javaValue;
    }

    public String[] getStrings() {
        return this.javaValue;
    }

    public static String[] convertXml(String string) {
        return XSDNMTokens.convertXml(string, null);
    }

    public static String[] convertXml(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        List list = WhitespaceUtils.splitOnXMLWhiteSpace(string);
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        XSDNMTokens.validateTokens(stringArray, string2);
        return stringArray;
    }

    private static final void validateTokens(String[] stringArray, String string) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (string != null && string.equals(stringArray[i])) continue;
            XSDNMToken.validateXml(stringArray[i]);
        }
    }

    public static void validateXml(String string) {
        XSDNMTokens.convertXml(string);
    }

    public static String getXml(String[] stringArray) {
        return XSDNMTokens.getCanonicalXml(stringArray);
    }

    public static String getCanonicalXml(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        XSDNMTokens.validateTokens(stringArray, null);
        return StringUtils.join(stringArray, " ");
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDNMTokens) {
            XSDNMTokens xSDNMTokens = (XSDNMTokens)object;
            if (xSDNMTokens.hash != this.hash && xSDNMTokens.hash != 0 && this.hash != 0) {
                return false;
            }
            return Arrays.equals(xSDNMTokens.javaValue, this.javaValue);
        }
        return false;
    }

    public final int hashCode() {
        if (this.hash == 0) {
            this.hash = TypeUtils.arrayHashCode(this.javaValue);
        }
        return this.hash;
    }
}

