/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;

public final class XSDLong
extends Number
implements XSDBuiltinType,
Comparable {
    final long javaValue;
    final String xmlValue;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "long");

    public static XSDLong createFromXml(String string) {
        return new XSDLong(string);
    }

    public static XSDLong createFromLong(long l) {
        return new XSDLong(l);
    }

    private XSDLong(String string) {
        this.xmlValue = string;
        this.javaValue = XSDLong.convertXml(string);
    }

    private XSDLong(long l) {
        this.javaValue = l;
        this.xmlValue = XSDLong.getXml(l);
    }

    private XSDLong(long l, String string) {
        this.javaValue = l;
        this.xmlValue = string;
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDLong.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return new Long(this.javaValue);
    }

    public int intValue() {
        return (int)this.javaValue;
    }

    public long longValue() {
        return this.javaValue;
    }

    public float floatValue() {
        return this.javaValue;
    }

    public double doubleValue() {
        return this.javaValue;
    }

    public int compareTo(XSDLong xSDLong) {
        long l = this.javaValue;
        long l2 = xSDLong.javaValue;
        return l < l2 ? -1 : (l == l2 ? 0 : 1);
    }

    public int compareTo(Object object) {
        return this.compareTo((XSDLong)object);
    }

    public static long convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        try {
            return Long.parseLong(TypeUtils.trimInitialPlus(string));
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME, numberFormatException);
            throw new IllegalArgumentException(string2);
        }
    }

    public static void validateXml(String string) {
        XSDLong.convertXml(string);
    }

    public static String getXml(long l) {
        return Long.toString(l);
    }

    public static String getCanonicalXml(long l) {
        return Long.toString(l);
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDLong) {
            return ((XSDLong)object).javaValue == this.javaValue;
        }
        return false;
    }

    public final int hashCode() {
        return (int)(this.javaValue ^ this.javaValue >>> 32);
    }
}

