/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import java.math.BigInteger;
import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;

abstract class XSDIntegerRestriction
extends Number
implements XSDBuiltinType,
Comparable {
    private final BigInteger javaValue;
    private final String xmlValue;

    protected XSDIntegerRestriction(BigInteger bigInteger, String string) {
        this.javaValue = bigInteger;
        this.xmlValue = string;
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDIntegerRestriction.getCanonicalXml(this.javaValue);
    }

    public Object getJavaObject() {
        return this.javaValue;
    }

    public BigInteger getBigInteger() {
        return this.javaValue;
    }

    public int intValue() {
        return this.javaValue.intValue();
    }

    public long longValue() {
        return this.javaValue.longValue();
    }

    public float floatValue() {
        return this.javaValue.floatValue();
    }

    public double doubleValue() {
        return this.javaValue.doubleValue();
    }

    public int compareTo(XSDIntegerRestriction xSDIntegerRestriction) {
        return this.javaValue.compareTo(xSDIntegerRestriction.javaValue);
    }

    public int compareTo(Object object) {
        return this.compareTo((XSDIntegerRestriction)object);
    }

    protected static BigInteger convertXml(String string, QName qName) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        try {
            return new BigInteger(TypeUtils.trimInitialPlus(string));
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = TypeUtils.createInvalidArgMsg(string, qName, numberFormatException);
            throw new IllegalArgumentException(string2);
        }
    }

    protected static void validateXml(String string, QName qName) {
        XSDIntegerRestriction.convertXml(string, qName);
    }

    protected static String getXml(BigInteger bigInteger) {
        return bigInteger.toString();
    }

    protected static String getCanonicalXml(BigInteger bigInteger) {
        return bigInteger.toString();
    }

    public String toString() {
        return this.getXml();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDIntegerRestriction) {
            return ((XSDIntegerRestriction)object).javaValue.equals(this.javaValue);
        }
        return false;
    }

    public final int hashCode() {
        return this.javaValue.hashCode();
    }
}

