/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import java.util.Arrays;
import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;
import weblogic.xml.schema.types.util.HexBinary;

public final class XSDHexBinary
implements XSDBuiltinType {
    final byte[] javaValue;
    final String xmlValue;
    int hash = 0;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "hexBinary");

    public static XSDHexBinary createFromXml(String string) {
        return new XSDHexBinary(string);
    }

    public static XSDHexBinary createFromBytes(byte[] byArray) {
        return new XSDHexBinary(byArray);
    }

    private XSDHexBinary(String string) {
        this.xmlValue = string;
        this.javaValue = XSDHexBinary.convertXml(string);
    }

    private XSDHexBinary(byte[] byArray) {
        this.javaValue = byArray;
        this.xmlValue = XSDHexBinary.getCanonicalXml(byArray);
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDHexBinary.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return this.javaValue;
    }

    public byte[] getBytes() {
        return this.javaValue;
    }

    public static byte[] convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        return HexBinary.decode((String)string);
    }

    public static void validateXml(String string) {
        XSDHexBinary.convertXml(string);
    }

    public static String getXml(byte[] byArray) {
        return XSDHexBinary.getCanonicalXml(byArray);
    }

    public static String getCanonicalXml(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        try {
            return HexBinary.encode((byte[])byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = TypeUtils.arrayToString(byArray);
            String string2 = TypeUtils.createInvalidJavaArgMsg(string, XML_TYPE_NAME, exception);
            throw new IllegalArgumentException(string2);
        }
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDHexBinary) {
            XSDHexBinary xSDHexBinary = (XSDHexBinary)object;
            if (xSDHexBinary.hash != this.hash && xSDHexBinary.hash != 0 && this.hash != 0) {
                return false;
            }
            return Arrays.equals(xSDHexBinary.javaValue, this.javaValue);
        }
        return false;
    }

    public final int hashCode() {
        if (this.hash == 0) {
            this.hash = TypeUtils.byteArrayHashCode(this.javaValue);
        }
        return this.hash;
    }
}

