/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;
import weblogic.xml.schema.types.util.XSDYearMonthDeserializer;
import weblogic.xml.schema.types.util.XSDYearMonthSerializer;

public final class XSDGYearMonth
implements XSDBuiltinType,
Comparable {
    private final Calendar javaValue;
    private final String xmlValue;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "gYearMonth");
    private static final XSDYearMonthDeserializer deser = new XSDYearMonthDeserializer();
    private static final TimeZone UTC_ZONE = TimeZone.getTimeZone("UTC");

    public static XSDGYearMonth createFromXml(String string) {
        return new XSDGYearMonth(string);
    }

    public static XSDGYearMonth createFromCalendar(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        return new XSDGYearMonth(calendar2);
    }

    private XSDGYearMonth(String string) {
        this.xmlValue = string;
        this.javaValue = XSDGYearMonth.convertXml(string);
    }

    private XSDGYearMonth(Calendar calendar) {
        this.javaValue = calendar;
        this.javaValue.set(5, 10);
        this.xmlValue = XSDGYearMonth.getXml(calendar);
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDGYearMonth.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return this.javaValue;
    }

    public Calendar getCalendar() {
        return this.javaValue;
    }

    public int compareTo(XSDGYearMonth xSDGYearMonth) {
        int n;
        Calendar calendar = XSDGYearMonth.normalizeCalendar(this.javaValue);
        Calendar calendar2 = XSDGYearMonth.normalizeCalendar(xSDGYearMonth.javaValue);
        int n2 = calendar.get(1);
        if (n2 < (n = calendar2.get(1))) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        n2 = calendar.get(2);
        if (n2 < (n = calendar2.get(2))) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return 0;
    }

    public int compareTo(Object object) {
        return this.compareTo((XSDGYearMonth)object);
    }

    private static Calendar normalizeCalendar(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.setTimeZone(UTC_ZONE);
        calendar2.getTimeInMillis();
        return calendar2;
    }

    public static Calendar convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        try {
            return deser.getCalendar(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME, numberFormatException);
            throw new IllegalArgumentException(string2);
        }
    }

    public static void validateXml(String string) {
        XSDGYearMonth.convertXml(string);
    }

    public static String getXml(Calendar calendar) {
        return XSDYearMonthSerializer.getString(calendar);
    }

    public static String getCanonicalXml(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.setTimeZone(UTC_ZONE);
        calendar2.set(5, 10);
        return XSDYearMonthSerializer.getString(calendar2);
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDGYearMonth) {
            XSDGYearMonth xSDGYearMonth = (XSDGYearMonth)object;
            return 0 == this.compareTo(xSDGYearMonth);
        }
        return false;
    }

    public final int hashCode() {
        return this.javaValue.hashCode();
    }
}

