/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;
import weblogic.xml.schema.types.util.XSDMonthDeserializer;
import weblogic.xml.schema.types.util.XSDMonthSerializer;

public final class XSDGMonth
implements XSDBuiltinType,
Comparable {
    private final Calendar javaValue;
    private final String xmlValue;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "gMonth");
    private static final XSDMonthDeserializer deser = new XSDMonthDeserializer();
    private static final TimeZone utc_zone = TimeZone.getTimeZone("UTC");

    public static XSDGMonth createFromXml(String string) {
        return new XSDGMonth(string);
    }

    public static XSDGMonth createFromCalendar(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        return new XSDGMonth(calendar2);
    }

    private XSDGMonth(String string) {
        this.xmlValue = string;
        this.javaValue = XSDGMonth.convertXml(string);
    }

    private XSDGMonth(Calendar calendar) {
        this.javaValue = calendar;
        this.xmlValue = XSDGMonth.getXml(calendar);
    }

    private XSDGMonth(Calendar calendar, String string) {
        this.javaValue = calendar;
        this.xmlValue = string;
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDGMonth.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return this.javaValue;
    }

    public Calendar getCalendar() {
        return this.javaValue;
    }

    public int compareTo(XSDGMonth xSDGMonth) {
        int n;
        int n2 = this.javaValue.get(2);
        return n2 < (n = xSDGMonth.javaValue.get(2)) ? -1 : (n2 == n ? 0 : 1);
    }

    public int compareTo(Object object) {
        return this.compareTo((XSDGMonth)object);
    }

    public static Calendar convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        try {
            return deser.getCalendar(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME, numberFormatException);
            throw new IllegalArgumentException(string2);
        }
    }

    public static void validateXml(String string) {
        XSDGMonth.convertXml(string);
    }

    public static String getXml(Calendar calendar) {
        return XSDMonthSerializer.getString(calendar);
    }

    public static String getCanonicalXml(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.set(5, 10);
        calendar2.setTimeZone(utc_zone);
        return XSDGMonth.getXml(calendar2);
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDGMonth) {
            XSDGMonth xSDGMonth = (XSDGMonth)object;
            return 0 == this.compareTo(xSDGMonth);
        }
        return false;
    }

    public final int hashCode() {
        return this.javaValue.hashCode();
    }
}

