/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;

public final class XSDFloat
extends Number
implements XSDBuiltinType,
Comparable {
    final float javaValue;
    final String xmlValue;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "float");
    private static final String NaN_LEX = "NaN";
    private static final String POS_INF_LEX = "INF";
    private static final String NEG_INF_LEX = "-INF";
    private static final String POS_ZERO_LEX = "0";
    private static final String NEG_ZERO_LEX = "-0";
    public static final XSDFloat NaN = new XSDFloat(Float.NaN, "NaN");
    public static final XSDFloat POSITIVE_INFINITY = new XSDFloat(Float.POSITIVE_INFINITY, "INF");
    public static final XSDFloat NEGATIVE_INFINITY = new XSDFloat(Float.NEGATIVE_INFINITY, "-INF");
    private static final NumberFormat formatter = new DecimalFormat("0.########E0");

    public static XSDFloat createFromXml(String string) {
        return new XSDFloat(string);
    }

    public static XSDFloat createFromFloat(float f) {
        return new XSDFloat(f);
    }

    private XSDFloat(String string) {
        this.xmlValue = string;
        this.javaValue = XSDFloat.convertXml(string);
    }

    private XSDFloat(float f) {
        this.javaValue = f;
        this.xmlValue = XSDFloat.getXml(f);
    }

    private XSDFloat(float f, String string) {
        this.javaValue = f;
        this.xmlValue = string;
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDFloat.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return new Float(this.javaValue);
    }

    public int intValue() {
        return (int)this.javaValue;
    }

    public long longValue() {
        return (long)this.javaValue;
    }

    public float floatValue() {
        return this.javaValue;
    }

    public double doubleValue() {
        return this.javaValue;
    }

    public int compareTo(XSDFloat xSDFloat) {
        Float f = new Float(xSDFloat.javaValue);
        Float f2 = new Float(this.javaValue);
        return f2.compareTo(f);
    }

    public int compareTo(Object object) {
        return this.compareTo((XSDFloat)object);
    }

    public static float convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (NaN.equals(string)) {
            return Float.NaN;
        }
        if (POS_INF_LEX.equals(string)) {
            return Float.POSITIVE_INFINITY;
        }
        if (NEG_INF_LEX.equals(string)) {
            return Float.NEGATIVE_INFINITY;
        }
        return XSDFloat.naiveConvertXml(string);
    }

    public static void validateXml(String string) {
        XSDFloat.convertXml(string);
    }

    private static float naiveConvertXml(String string) {
        try {
            float f = Float.parseFloat(string);
            if (f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY) {
                String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME);
                throw new IllegalArgumentException(string2);
            }
            return f;
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME, numberFormatException);
            throw new IllegalArgumentException(string3);
        }
    }

    public static String getXml(float f) {
        if (f == Float.POSITIVE_INFINITY) {
            return POS_INF_LEX;
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return NEG_INF_LEX;
        }
        return Float.toString(f);
    }

    public static String getCanonicalXml(float f) {
        if (f == 0.0f) {
            return POS_ZERO_LEX;
        }
        if (f == -0.0f) {
            return NEG_ZERO_LEX;
        }
        if (f == Float.POSITIVE_INFINITY) {
            return POS_INF_LEX;
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return NEG_INF_LEX;
        }
        if (Float.isNaN(f)) {
            return NaN_LEX;
        }
        return formatter.format(f);
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDFloat) {
            return ((XSDFloat)object).javaValue == this.javaValue;
        }
        return false;
    }

    public final int hashCode() {
        return Float.floatToIntBits(this.javaValue);
    }
}

