/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import weblogic.utils.StringUtils;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;
import weblogic.xml.schema.types.XSDEntity;
import weblogic.xml.util.WhitespaceUtils;

public final class XSDEntities
implements XSDBuiltinType {
    final String[] javaValue;
    final String xmlValue;
    int hash = 0;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "ENTITIES");

    public static XSDEntities createFromXml(String string) {
        return new XSDEntities(string);
    }

    public static XSDEntities createFromStrings(String[] stringArray) {
        return new XSDEntities(stringArray);
    }

    private XSDEntities(String string) {
        this.xmlValue = string;
        this.javaValue = XSDEntities.convertXml(string);
    }

    private XSDEntities(String[] stringArray) {
        this.javaValue = stringArray;
        this.xmlValue = XSDEntities.getCanonicalXml(stringArray);
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDEntities.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return this.javaValue;
    }

    public String[] getStrings() {
        return this.javaValue;
    }

    public static String[] convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        List list = WhitespaceUtils.splitOnXMLWhiteSpace(string);
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        XSDEntities.validateEntities(stringArray);
        return stringArray;
    }

    private static final void validateEntities(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            XSDEntity.validateXml(stringArray[i]);
        }
    }

    public static void validateXml(String string) {
        XSDEntities.convertXml(string);
    }

    public static String getXml(String[] stringArray) {
        return XSDEntities.getCanonicalXml(stringArray);
    }

    public static String getCanonicalXml(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        XSDEntities.validateEntities(stringArray);
        return StringUtils.join(stringArray, " ");
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDEntities) {
            XSDEntities xSDEntities = (XSDEntities)object;
            if (xSDEntities.hash != this.hash && xSDEntities.hash != 0 && this.hash != 0) {
                return false;
            }
            return Arrays.equals(xSDEntities.javaValue, this.javaValue);
        }
        return false;
    }

    public final int hashCode() {
        if (this.hash == 0) {
            this.hash = TypeUtils.arrayHashCode(this.javaValue);
        }
        return this.hash;
    }
}

