/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import javax.xml.namespace.QName;
import weblogic.xml.schema.types.Duration;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;
import weblogic.xml.schema.types.util.XSDDurationDeserializer;
import weblogic.xml.schema.types.util.XSDDurationSerializer;

public final class XSDDuration
implements XSDBuiltinType {
    private final Duration javaValue;
    private final String xmlValue;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "duration");
    private static final XSDDurationDeserializer deser = new XSDDurationDeserializer();

    public static XSDDuration createFromXml(String string) {
        return new XSDDuration(string);
    }

    public static XSDDuration createFromDuration(Duration duration) {
        Duration duration2 = new Duration(duration);
        return new XSDDuration(duration2);
    }

    private XSDDuration(String string) {
        this.xmlValue = string;
        this.javaValue = XSDDuration.convertXml(string);
    }

    private XSDDuration(Duration duration) {
        this.javaValue = duration;
        this.xmlValue = XSDDuration.getXml(duration);
    }

    private XSDDuration(Duration duration, String string) {
        this.javaValue = duration;
        this.xmlValue = string;
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDDuration.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return this.javaValue;
    }

    public Duration getDuration() {
        return this.javaValue;
    }

    public static Duration convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        try {
            return XSDDurationDeserializer.getDuration(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME, numberFormatException);
            throw new IllegalArgumentException(string2);
        }
    }

    public static void validurationXml(String string) {
        XSDDuration.convertXml(string);
    }

    public static String getXml(Duration duration) {
        return XSDDurationSerializer.getString(duration);
    }

    public static String getCanonicalXml(Duration duration) {
        return XSDDurationSerializer.getString(duration);
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDDuration) {
            return this.javaValue.equals(((XSDDuration)object).javaValue);
        }
        return false;
    }

    public final int hashCode() {
        return this.javaValue.hashCode();
    }
}

