/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;

public final class XSDDouble
extends Number
implements XSDBuiltinType,
Comparable {
    final double javaValue;
    final String xmlValue;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "double");
    private static final String NaN_LEX = "NaN";
    private static final String POS_INF_LEX = "INF";
    private static final String NEG_INF_LEX = "-INF";
    private static final String POS_ZERO_LEX = "0";
    private static final String NEG_ZERO_LEX = "-0";
    public static final XSDDouble NaN = new XSDDouble(Double.NaN, "NaN");
    public static final XSDDouble POSITIVE_INFINITY = new XSDDouble(Double.POSITIVE_INFINITY, "INF");
    public static final XSDDouble NEGATIVE_INFINITY = new XSDDouble(Double.NEGATIVE_INFINITY, "-INF");
    private static final NumberFormat formatter = new DecimalFormat("0.########E0");

    public static XSDDouble createFromXml(String string) {
        return new XSDDouble(string);
    }

    public static XSDDouble createFromDouble(double d) {
        return new XSDDouble(d);
    }

    private XSDDouble(String string) {
        this.xmlValue = string;
        this.javaValue = XSDDouble.convertXml(string);
    }

    private XSDDouble(double d) {
        this.javaValue = d;
        this.xmlValue = XSDDouble.getXml(d);
    }

    private XSDDouble(double d, String string) {
        this.javaValue = d;
        this.xmlValue = string;
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDDouble.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return new Double(this.javaValue);
    }

    public int intValue() {
        return (int)this.javaValue;
    }

    public long longValue() {
        return (long)this.javaValue;
    }

    public double doubleValue() {
        return this.javaValue;
    }

    public float floatValue() {
        return (float)this.javaValue;
    }

    public int compareTo(XSDDouble xSDDouble) {
        Double d = new Double(xSDDouble.javaValue);
        Double d2 = new Double(this.javaValue);
        return d2.compareTo(d);
    }

    public int compareTo(Object object) {
        return this.compareTo((XSDDouble)object);
    }

    public static double convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (NaN.equals(string)) {
            return Double.NaN;
        }
        if (POS_INF_LEX.equals(string)) {
            return Double.POSITIVE_INFINITY;
        }
        if (NEG_INF_LEX.equals(string)) {
            return Double.NEGATIVE_INFINITY;
        }
        return XSDDouble.naiveConvertXml(string);
    }

    public static void validateXml(String string) {
        XSDDouble.convertXml(string);
    }

    private static double naiveConvertXml(String string) {
        try {
            double d = Double.parseDouble(string);
            if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
                String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME);
                throw new IllegalArgumentException(string2);
            }
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME, numberFormatException);
            throw new IllegalArgumentException(string3);
        }
    }

    public static String getXml(double d) {
        if (d == Double.POSITIVE_INFINITY) {
            return POS_INF_LEX;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return NEG_INF_LEX;
        }
        return Double.toString(d);
    }

    public static String getCanonicalXml(double d) {
        if (d == 0.0) {
            return POS_ZERO_LEX;
        }
        if (d == -0.0) {
            return NEG_ZERO_LEX;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return POS_INF_LEX;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return NEG_INF_LEX;
        }
        if (Double.isNaN(d)) {
            return NaN_LEX;
        }
        return formatter.format(d);
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDDouble) {
            return ((XSDDouble)object).javaValue == this.javaValue;
        }
        return false;
    }

    public final int hashCode() {
        long l = Double.doubleToLongBits(this.javaValue);
        return (int)(l ^ l >>> 32);
    }
}

