/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;
import weblogic.xml.schema.types.util.XSDDateDeserializer;
import weblogic.xml.schema.types.util.XSDDateSerializer;

public final class XSDDate
implements XSDBuiltinType,
Comparable {
    private final Calendar javaValue;
    private final String xmlValue;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "date");
    private static final XSDDateDeserializer deser = new XSDDateDeserializer();
    private static final TimeZone UTC_ZONE = TimeZone.getTimeZone("UTC");

    public static XSDDate createFromXml(String string) {
        return new XSDDate(string);
    }

    public static XSDDate createFromCalendar(Calendar calendar) {
        return new XSDDate(calendar);
    }

    private XSDDate(String string) {
        this.xmlValue = string;
        this.javaValue = XSDDate.convertXml(string);
    }

    private XSDDate(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        XSDDate.fixTime(calendar2);
        this.javaValue = calendar2;
        this.xmlValue = XSDDate.getXml(calendar2);
    }

    private static void fixTime(Calendar calendar) {
        calendar.set(11, 12);
        calendar.set(12, 0);
        calendar.set(13, 0);
    }

    private XSDDate(Calendar calendar, String string) {
        this.javaValue = calendar;
        this.xmlValue = string;
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDDate.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return this.javaValue;
    }

    public Calendar getCalendar() {
        return this.javaValue;
    }

    public int compareTo(XSDDate xSDDate) {
        int n;
        Calendar calendar = XSDDate.normalizeCalendar(this.javaValue);
        Calendar calendar2 = XSDDate.normalizeCalendar(xSDDate.javaValue);
        int n2 = calendar.get(1);
        if (n2 < (n = calendar2.get(1))) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        n2 = calendar.get(6);
        if (n2 < (n = calendar2.get(6))) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return 0;
    }

    private static Calendar normalizeCalendar(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.setTimeZone(UTC_ZONE);
        calendar2.getTimeInMillis();
        return calendar2;
    }

    public int compareTo(Object object) {
        return this.compareTo((XSDDate)object);
    }

    public static Calendar convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        try {
            return deser.getCalendar(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME, numberFormatException);
            throw new IllegalArgumentException(string2);
        }
    }

    public static void validateXml(String string) {
        XSDDate.convertXml(string);
    }

    public static String getXml(Calendar calendar) {
        return XSDDateSerializer.getString(calendar);
    }

    public static String getCanonicalXml(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        XSDDate.fixTime(calendar2);
        calendar2.setTimeZone(UTC_ZONE);
        return XSDDateSerializer.getString(calendar2);
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDDate) {
            XSDDate xSDDate = (XSDDate)object;
            return 0 == this.compareTo(xSDDate);
        }
        return false;
    }

    public final int hashCode() {
        return this.javaValue.hashCode();
    }
}

