/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import javax.xml.namespace.QName;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;

public final class XSDBoolean
implements XSDBuiltinType {
    final boolean javaValue;
    final String xmlValue;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "boolean");
    public static final XSDBoolean TRUE = new XSDBoolean(true);
    public static final XSDBoolean FALSE = new XSDBoolean(false);

    public static XSDBoolean createFromXml(String string) {
        if ("true".equals(string)) {
            return TRUE;
        }
        if ("false".equals(string)) {
            return FALSE;
        }
        return new XSDBoolean(string);
    }

    public static XSDBoolean createFromBoolean(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    private XSDBoolean(String string) {
        this.xmlValue = string;
        this.javaValue = XSDBoolean.convertXml(string);
    }

    private XSDBoolean(boolean bl) {
        this.javaValue = bl;
        this.xmlValue = XSDBoolean.getXml(bl);
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDBoolean.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return this.javaValue ? Boolean.TRUE : Boolean.FALSE;
    }

    public static boolean convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if ("true".equals(string) || "1".equals(string)) {
            return true;
        }
        if ("false".equals(string) || "0".equals(string)) {
            return false;
        }
        String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME);
        throw new IllegalArgumentException(string2);
    }

    public static void validateXml(String string) {
        XSDBoolean.convertXml(string);
    }

    public static String getXml(boolean bl) {
        return XSDBoolean.getCanonicalXml(bl);
    }

    public static String getCanonicalXml(boolean bl) {
        return bl ? "true" : "false";
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDBoolean) {
            return ((XSDBoolean)object).javaValue == this.javaValue;
        }
        return false;
    }

    public final int hashCode() {
        return this.javaValue ? 17 : 0;
    }
}

