/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.types;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.mail.MessagingException;
import javax.mail.internet.MimeUtility;
import javax.xml.namespace.QName;
import weblogic.utils.encoders.BASE64Encoder;
import weblogic.xml.schema.binding.util.runtime.ByteList;
import weblogic.xml.schema.types.TypeUtils;
import weblogic.xml.schema.types.XSDBuiltinType;

public final class XSDBase64Binary
implements XSDBuiltinType {
    final byte[] javaValue;
    final String xmlValue;
    int hash = 0;
    public static final QName XML_TYPE_NAME = new QName("http://www.w3.org/2001/XMLSchema", "base64Binary");

    public static XSDBase64Binary createFromXml(String string) {
        return new XSDBase64Binary(string);
    }

    public static XSDBase64Binary createFromBytes(byte[] byArray) {
        return new XSDBase64Binary(byArray);
    }

    private XSDBase64Binary(String string) {
        this.xmlValue = string;
        this.javaValue = XSDBase64Binary.convertXml(string);
    }

    private XSDBase64Binary(byte[] byArray) {
        this.javaValue = byArray;
        this.xmlValue = XSDBase64Binary.getCanonicalXml(byArray);
    }

    public String getXml() {
        return this.xmlValue;
    }

    public String getCanonicalXml() {
        return XSDBase64Binary.getCanonicalXml(this.javaValue);
    }

    public QName getTypeName() {
        return XML_TYPE_NAME;
    }

    public Object getJavaObject() {
        return this.javaValue;
    }

    public static byte[] convertXml(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        try {
            int n;
            InputStream inputStream = new ByteArrayInputStream(string.getBytes());
            inputStream = MimeUtility.decode(inputStream, "base64");
            ByteList byteList = new ByteList(string.length());
            while ((n = inputStream.read()) != -1) {
                byteList.add((byte)n);
            }
            return byteList.getMinSizedArray();
        }
        catch (IOException iOException) {
            String string2 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME, iOException);
            throw new IllegalArgumentException(string2);
        }
        catch (MessagingException messagingException) {
            String string3 = TypeUtils.createInvalidArgMsg(string, XML_TYPE_NAME, messagingException);
            throw new IllegalArgumentException(string3);
        }
    }

    public static void validateXml(String string) {
        XSDBase64Binary.convertXml(string);
    }

    public static String getXml(byte[] byArray) {
        return XSDBase64Binary.getCanonicalXml(byArray);
    }

    public static String getCanonicalXml(byte[] byArray) {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        return bASE64Encoder.encodeBuffer(byArray);
    }

    public String toString() {
        return this.getXml();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XSDBase64Binary) {
            XSDBase64Binary xSDBase64Binary = (XSDBase64Binary)object;
            if (xSDBase64Binary.hash != this.hash && xSDBase64Binary.hash != 0 && this.hash != 0) {
                return false;
            }
            return Arrays.equals(xSDBase64Binary.javaValue, this.javaValue);
        }
        return false;
    }

    public final int hashCode() {
        if (this.hash == 0) {
            this.hash = TypeUtils.byteArrayHashCode(this.javaValue);
        }
        return this.hash;
    }
}

