/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.model.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import weblogic.xml.schema.model.XSDException;
import weblogic.xml.schema.model.XSDSchema;

public class SchemaMap {
    private final Map schemaMap = new HashMap();

    public void addSchema(XSDSchema xSDSchema) {
        this.schemaMap.put(xSDSchema.getTargetNamespace(), xSDSchema);
    }

    public XSDSchema mergeSchema(XSDSchema xSDSchema) throws XSDException {
        String string = xSDSchema.getTargetNamespace();
        XSDSchema xSDSchema2 = this.getSchema(string);
        if (xSDSchema2 != null) {
            xSDSchema2.addAll(xSDSchema);
            return xSDSchema2;
        }
        this.schemaMap.put(string, xSDSchema);
        return xSDSchema;
    }

    public XSDSchema getSchema(String string) {
        return (XSDSchema)this.schemaMap.get(string);
    }

    public void removeSchema(XSDSchema xSDSchema) {
        this.schemaMap.remove(xSDSchema.getTargetNamespace());
    }

    public void removeSchema(String string) {
        this.schemaMap.remove(string);
    }

    public Map getMap() {
        return Collections.unmodifiableMap(this.schemaMap);
    }

    public Iterator iterator() {
        return this.getMap().values().iterator();
    }
}

