/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.xml.schema.model.DerivationSet;
import weblogic.xml.schema.model.ExpName;
import weblogic.xml.schema.model.SchemaTypes;
import weblogic.xml.schema.model.SimpleTypeVariety;
import weblogic.xml.schema.model.XSDAnyType;
import weblogic.xml.schema.model.XSDBaseSimpleType;
import weblogic.xml.schema.model.XSDException;
import weblogic.xml.schema.model.XSDFacet;
import weblogic.xml.schema.model.XSDList;
import weblogic.xml.schema.model.XSDObject;
import weblogic.xml.schema.model.XSDObjectAttribute;
import weblogic.xml.schema.model.XSDObjectIterator;
import weblogic.xml.schema.model.XSDPrimitiveSimpleType;
import weblogic.xml.schema.model.XSDSchema;
import weblogic.xml.schema.model.XSDSimpleType;
import weblogic.xml.schema.model.XSDSimpleTypeRestriction;
import weblogic.xml.schema.model.XSDUnion;
import weblogic.xml.schema.model.XSDValidityException;
import weblogic.xml.stream.XMLName;

public class XSDSimpleType
extends XSDBaseSimpleType
implements Cloneable {
    private static final boolean DEBUG = true;
    private List memberTypes;
    private XSDUnion union;
    private XSDList list;
    private XSDSimpleTypeRestriction restriction;
    private boolean isBuiltin = false;
    private DerivationSet final_att;

    public XSDSimpleType() {
    }

    public XSDSimpleType(XMLName xMLName) {
        super(xMLName);
    }

    XSDSimpleType(XMLName xMLName, boolean bl) {
        super(xMLName);
        this.isBuiltin = bl;
    }

    public XSDSimpleType(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public boolean isBuiltin() {
        return this.isBuiltin;
    }

    public boolean isPrimitive() {
        return false;
    }

    public XMLName getBaseType() throws XSDException {
        Debug.assertion(this.getParent() != null);
        if (this.list != null) {
            return SchemaTypes.XSD_ANY_SIMPLE_TYPE_ENAME;
        }
        if (this.union != null) {
            return SchemaTypes.XSD_ANY_SIMPLE_TYPE_ENAME;
        }
        if (this.restriction != null) {
            return this.restriction.getBaseType();
        }
        throw this.createEmptyTypeException();
    }

    private XSDValidityException createEmptyTypeException() {
        return new XSDValidityException(this.getXSDTypeName().getLocalName() + " cannot be empty");
    }

    public XSDAnyType getBaseTypeObject() throws XSDException {
        Debug.assertion(this.getParent() != null);
        if (this.restriction != null) {
            return this.restriction.getBaseTypeObject();
        }
        return super.getBaseTypeObject();
    }

    public SimpleTypeVariety getVariety() throws XSDException {
        Debug.assertion(this.getParent() != null);
        if (this.list != null) {
            return SimpleTypeVariety.LIST;
        }
        if (this.union != null) {
            return SimpleTypeVariety.UNION;
        }
        if (this.restriction != null) {
            return this.restriction.getVariety();
        }
        throw this.createEmptyTypeException();
    }

    public XSDBaseSimpleType getBasePrimitiveTypeObject() throws XSDException {
        XSDAnyType xSDAnyType;
        for (xSDAnyType = this; xSDAnyType != null; xSDAnyType = ((XSDAnyType)xSDAnyType).getBaseTypeObject()) {
            if (!(xSDAnyType instanceof XSDPrimitiveSimpleType)) continue;
            return (XSDPrimitiveSimpleType)xSDAnyType;
        }
        XMLName xMLName = xSDAnyType == null ? null : xSDAnyType.getXMLName();
        String string = xMLName == null ? "<null>" : xMLName.toString();
        throw new AssertionError("failed to find true base type for " + xMLName);
    }

    public ArrayList getResolvedFacets() throws XSDException {
        ArrayList arrayList;
        Cloneable cloneable;
        LinkedList<ArrayList> linkedList = new LinkedList<ArrayList>();
        ArrayList arrayList2 = this.getFacets();
        XSDAnyType xSDAnyType = this;
        Debug.assertion(xSDAnyType != null);
        Debug.assertion(xSDAnyType instanceof XSDSimpleType);
        Debug.assertion(!((XSDAnyType)xSDAnyType).isBuiltin(), "" + this.getXMLName());
        while (xSDAnyType != null && xSDAnyType instanceof XSDSimpleType && !((XSDAnyType)xSDAnyType).isBuiltin()) {
            cloneable = xSDAnyType;
            arrayList = ((XSDSimpleType)cloneable).getFacets();
            linkedList.add(arrayList);
            Debug.assertion(!linkedList.isEmpty());
            xSDAnyType = ((XSDAnyType)xSDAnyType).getBaseTypeObject();
        }
        Debug.assertion(!linkedList.isEmpty());
        cloneable = (ArrayList)linkedList.removeFirst();
        while (!linkedList.isEmpty()) {
            arrayList = (ArrayList)linkedList.removeFirst();
            cloneable = this.mergeFacets((ArrayList)cloneable, arrayList);
        }
        return cloneable;
    }

    public ArrayList getFacets() throws XSDValidityException {
        List list;
        int n = XSDFacet.getMaxFacetType();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i <= n; ++i) {
            arrayList.add(null);
        }
        XSDSimpleTypeRestriction xSDSimpleTypeRestriction = this.getRestriction();
        if (xSDSimpleTypeRestriction != null && (list = xSDSimpleTypeRestriction.getFacets()) != null && !list.isEmpty()) {
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> hashSet2 = new HashSet<String>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                XSDFacet xSDFacet = (XSDFacet)iterator.next();
                if (xSDFacet.isEnumeration()) {
                    hashSet.add(xSDFacet.getValue());
                    continue;
                }
                if (xSDFacet.isPattern()) {
                    hashSet2.add(xSDFacet.getValue());
                    continue;
                }
                int n2 = xSDFacet.getFacetType();
                if (arrayList.get(n2) != null) {
                    String string = "Duplicate facets of type " + xSDFacet.getFacetTypeString() + " not allowed";
                    throw new XSDValidityException(string);
                }
                arrayList.set(n2, xSDFacet);
            }
            if (!hashSet.isEmpty()) {
                arrayList.set(5, hashSet);
            }
            if (!hashSet2.isEmpty()) {
                arrayList.set(4, hashSet2);
            }
        }
        return arrayList;
    }

    public void addMemberType(XMLName xMLName) {
        if (this.memberTypes == null) {
            this.memberTypes = new ArrayList();
        }
        this.memberTypes.add(xMLName);
    }

    public void removeMemberType(XMLName xMLName) {
        if (this.memberTypes == null) {
            return;
        }
        this.memberTypes.remove(xMLName);
    }

    public XSDList getList() {
        return this.list;
    }

    public void setList(XSDList xSDList) {
        this.list = xSDList;
    }

    public XSDUnion getUnion() {
        return this.union;
    }

    public void setUnion(XSDUnion xSDUnion) {
        this.union = xSDUnion;
    }

    public DerivationSet getFinal() {
        return this.final_att;
    }

    public void setFinal(DerivationSet derivationSet) {
        this.final_att = derivationSet;
    }

    public XSDList getListResolved() throws XSDException {
        if (this.list != null) {
            return this.list;
        }
        if (this.union != null) {
            return null;
        }
        if (this.restriction != null) {
            return this.restriction.getBaseTypeObject().getListResolved();
        }
        throw this.createEmptyTypeException();
    }

    public XSDSimpleTypeRestriction getRestriction() {
        return this.restriction;
    }

    public void setRestriction(XSDSimpleTypeRestriction xSDSimpleTypeRestriction) {
        this.restriction = xSDSimpleTypeRestriction;
        xSDSimpleTypeRestriction.setParent((XSDObject)this);
    }

    protected boolean isLegalFacetAtomic(int n) throws XSDException {
        Debug.assertion(n <= XSDFacet.getMaxFacetType());
        Debug.assertion(this.getVariety() == SimpleTypeVariety.ATOMIC);
        XSDSchema xSDSchema = XSDSchema.getSchema(this);
        Debug.assertion(xSDSchema != null, "null schema for this: " + this + " : " + this.getXMLName());
        XSDPrimitiveSimpleType xSDPrimitiveSimpleType = this.findBasePrimitiveType(xSDSchema);
        return xSDPrimitiveSimpleType.isLegalFacetAtomic(n);
    }

    private XSDPrimitiveSimpleType findBasePrimitiveType(XSDSchema xSDSchema) throws XSDException {
        XMLName xMLName = this.getBaseType();
        XSDAnyType xSDAnyType = xSDSchema.getType(xMLName);
        if (xSDAnyType instanceof XSDPrimitiveSimpleType) {
            return (XSDPrimitiveSimpleType)xSDAnyType;
        }
        if (xSDAnyType instanceof XSDSimpleType) {
            return ((XSDSimpleType)xSDAnyType).findBasePrimitiveType(xSDSchema);
        }
        throw new AssertionError("base type of simple type must be simple type");
    }

    protected void getSubAttributes(List list, boolean bl) {
        super.getSubAttributes(list, bl);
        if (this.final_att != null) {
            list.add(new XSDObjectAttribute("final", this.final_att.toXMLString()));
        }
    }

    public XSDObjectIterator getChildren() {
        Debug.assertion(this.getParent() != null);
        SimpleTypeVariety simpleTypeVariety = null;
        try {
            simpleTypeVariety = this.getVariety();
        }
        catch (XSDException xSDException) {
            // empty catch block
        }
        if (simpleTypeVariety == SimpleTypeVariety.ATOMIC) {
            return new AtomicChildItr(this, null);
        }
        if (simpleTypeVariety == SimpleTypeVariety.LIST) {
            return new ListChildItr(this, null);
        }
        if (simpleTypeVariety == SimpleTypeVariety.UNION) {
            return new UnionChildItr(this, null);
        }
        return null;
    }

    public Object clone() {
        XSDSimpleType xSDSimpleType = (XSDSimpleType)super.clone();
        xSDSimpleType.memberTypes = ExpName.cloneListofXMLNames(this.memberTypes);
        xSDSimpleType.union = this.union == null ? null : (XSDUnion)this.union.clone();
        xSDSimpleType.list = this.list == null ? null : (XSDList)this.list.clone();
        xSDSimpleType.restriction = this.restriction == null ? null : (XSDSimpleTypeRestriction)this.restriction.clone();
        return xSDSimpleType;
    }

    static /* synthetic */ XSDList access$300(XSDSimpleType xSDSimpleType) {
        return xSDSimpleType.list;
    }

    static /* synthetic */ XSDUnion access$400(XSDSimpleType xSDSimpleType) {
        return xSDSimpleType.union;
    }

    static /* synthetic */ XSDSimpleTypeRestriction access$500(XSDSimpleType xSDSimpleType) {
        return xSDSimpleType.restriction;
    }
}

