/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.xml.schema.model.EmptyAttributeIterator;
import weblogic.xml.schema.model.ExpName;
import weblogic.xml.schema.model.XSDAnnotation;
import weblogic.xml.schema.model.XSDAnyType;
import weblogic.xml.schema.model.XSDAttribute;
import weblogic.xml.schema.model.XSDAttributeGroup;
import weblogic.xml.schema.model.XSDElement;
import weblogic.xml.schema.model.XSDException;
import weblogic.xml.schema.model.XSDModelGroupDefn;
import weblogic.xml.schema.model.XSDObject;
import weblogic.xml.schema.model.XSDObjectAttribute;
import weblogic.xml.schema.model.XSDObjectIterator;
import weblogic.xml.schema.model.XSDParticle;
import weblogic.xml.schema.model.XSDSchema;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.XMLName;

public abstract class XSDObject
implements Cloneable {
    public static final int SCHEMA = 1;
    public static final int ELEMENT = 2;
    public static final int ATTRIBUTE = 3;
    public static final int COMPLEX_TYPE = 4;
    public static final int SEQUENCE = 5;
    public static final int MODEL_GROUP_DEFN = 6;
    public static final int SIMPLE_TYPE = 7;
    public static final int UNION = 8;
    public static final int LIST = 9;
    public static final int SIMPLE_TYPE_RESTRICTION = 10;
    public static final int FACET = 11;
    public static final int ANNOTATION = 12;
    public static final int APPINFO = 13;
    public static final int DOCUMENTATION = 14;
    public static final int ALL = 15;
    public static final int CHOICE = 16;
    public static final int ATTRIBUTE_GROUP = 17;
    public static final int ANY = 18;
    public static final int ANY_ATTRIBUTE = 19;
    public static final int COMPLEX_CONTENT = 20;
    public static final int COMPLEX_CONTENT_EXTENSION = 21;
    public static final int COMPLEX_CONTENT_RESTRICTION = 22;
    public static final int SIMPLE_CONTENT = 23;
    public static final int SIMPLE_CONTENT_EXTENSION = 24;
    public static final int SIMPLE_CONTENT_RESTRICTION = 25;
    public static final int KEY = 26;
    public static final int KEYREF = 27;
    public static final int UNIQUE = 28;
    public static final int SELECTOR = 29;
    public static final int FIELD = 30;
    public static final int NOTATION = 31;
    public static final int INCLUDE = 32;
    public static final int IMPORT = 33;
    public static final int REDEFINE = 34;
    private Map nsMap;
    private XSDObject parent;
    private String ID;
    private List annotationAttributes;
    private XSDAnnotation annotation;
    private static final boolean DEBUG = true;
    private static final String UNBOUNDED = "unbounded";

    protected XSDObject() {
        this(null);
    }

    protected XSDObject(XSDObject xSDObject) {
        this.parent = xSDObject;
    }

    public void addAnnotationAttribute(Attribute attribute) {
        if (this.annotationAttributes == null) {
            this.annotationAttributes = new ArrayList();
        }
        this.annotationAttributes.add(attribute);
    }

    public void removeAnnotationAttribute(Attribute attribute) {
        if (this.annotationAttributes == null) {
            return;
        }
        this.annotationAttributes.remove(attribute);
    }

    public AttributeIterator getAnnotationAttributes() {
        if (this.annotationAttributes == null) {
            return EmptyAttributeIterator.INSTANCE;
        }
        return new AttrItr(this.annotationAttributes);
    }

    public XSDAnnotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(XSDAnnotation xSDAnnotation) {
        this.annotation = xSDAnnotation;
    }

    protected abstract XMLName getXSDTypeName();

    public XSDObjectIterator getChildren(boolean bl) {
        if (bl) {
            return new ChildItr(this, null);
        }
        return this.getChildren();
    }

    protected abstract XSDObjectIterator getChildren();

    public abstract int getTypeCode();

    public XMLName getXMLElementName() {
        return this.getXMLElementName(true);
    }

    public XMLName getXMLElementName(boolean bl) {
        ExpName expName = new ExpName(this.getXSDTypeName());
        if (bl) {
            this.fillPrefix(expName);
        }
        return expName;
    }

    public void validate() {
        Debug.say("validate UNIMPLEMENTED for " + this.getClass().getName());
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String string) {
        this.ID = string;
    }

    public XSDObject getParent() {
        return this.parent;
    }

    public void setParent(XSDObject xSDObject) {
        this.parent = xSDObject;
    }

    public void addNamespace(String string, String string2) {
        if (this.nsMap == null) {
            this.nsMap = new HashMap();
        }
        Debug.assertion(string2 != null, "addNamespace: <<" + string + ">> => " + string2 + " this=" + this);
        this.nsMap.put(string, string2);
    }

    public String removeNamespace(String string) {
        if (this.nsMap == null) {
            return null;
        }
        return (String)this.nsMap.remove(string);
    }

    public Map getNamespaceMap() {
        if (this.nsMap == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.nsMap);
    }

    public String getURI(String string) {
        if (this.nsMap == null) {
            return null;
        }
        return (String)this.nsMap.get(string);
    }

    public String getURIUsingParents(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        for (XSDObject xSDObject = this; xSDObject != null && (string2 = xSDObject.getURI(string)) == null; xSDObject = xSDObject.getParent()) {
        }
        return string2;
    }

    public XMLName fillURIUsingParents(XMLName xMLName) {
        String string = this.getURIUsingParents(xMLName.getPrefix());
        ExpName expName = new ExpName(xMLName);
        expName.setUri(string);
        return expName;
    }

    public String getPrefixUsingParents(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        for (XSDObject xSDObject = this; xSDObject != null && (string2 = xSDObject.getPrefix(string)) == null; xSDObject = xSDObject.getParent()) {
        }
        return string2;
    }

    protected String getPrefix(String string) {
        if (this.nsMap == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        Set set = this.nsMap.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry == null || !string.equals(entry.getValue())) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public XSDSchema getContainingSchema() {
        for (XSDObject xSDObject = this; xSDObject != null; xSDObject = xSDObject.getParent()) {
            if (!(xSDObject instanceof XSDSchema)) continue;
            return (XSDSchema)xSDObject;
        }
        return null;
    }

    protected XSDAnyType lookupType(XMLName xMLName) throws XSDException {
        Debug.assertion(xMLName != null);
        XMLName xMLName2 = this.fixUri(xMLName);
        XSDSchema xSDSchema = this.getContainingSchema();
        if (xSDSchema == null) {
            return null;
        }
        return xSDSchema.lookupType(xMLName2);
    }

    private final XMLName fixUri(XMLName xMLName) {
        Debug.assertion(xMLName != null);
        XMLName xMLName2 = xMLName;
        if ((xMLName.getNamespaceUri() == null || xMLName.getNamespaceUri().length() < 1) && xMLName.getPrefix() != null && xMLName.getPrefix().length() > 0) {
            xMLName2 = this.fillURIUsingParents(xMLName);
        }
        return xMLName2;
    }

    protected XSDElement lookupElement(XMLName xMLName) throws XSDException {
        Debug.assertion(xMLName != null);
        XMLName xMLName2 = this.fixUri(xMLName);
        XSDSchema xSDSchema = this.getContainingSchema();
        if (xSDSchema == null) {
            return null;
        }
        return xSDSchema.lookupElement(xMLName2);
    }

    protected XSDAttribute lookupAttribute(XMLName xMLName) throws XSDException {
        Debug.assertion(xMLName != null);
        XMLName xMLName2 = this.fixUri(xMLName);
        XSDSchema xSDSchema = this.getContainingSchema();
        if (xSDSchema == null) {
            return null;
        }
        return xSDSchema.lookupAttribute(xMLName2);
    }

    protected XSDAttributeGroup lookupAttributeGroup(XMLName xMLName) throws XSDException {
        Debug.assertion(xMLName != null);
        XMLName xMLName2 = this.fixUri(xMLName);
        XSDSchema xSDSchema = this.getContainingSchema();
        if (xSDSchema == null) {
            return null;
        }
        return xSDSchema.lookupAttributeGroup(xMLName2);
    }

    protected XSDModelGroupDefn lookupModelGroupDefn(XMLName xMLName) throws XSDException {
        Debug.assertion(xMLName != null);
        XMLName xMLName2 = this.fixUri(xMLName);
        XSDSchema xSDSchema = this.getContainingSchema();
        if (xSDSchema == null) {
            return null;
        }
        return xSDSchema.lookupModelGroupDefn(xMLName2);
    }

    public final AttributeIterator getAttributeIterator(boolean bl, boolean bl2, boolean bl3) {
        ArrayList arrayList = new ArrayList();
        if (bl2) {
            this.addNameSpaceAttributues(arrayList);
        }
        this.getSubAttributes(arrayList, bl);
        if (bl3) {
            this.addAnnotationAttributues(arrayList);
        }
        return new AttrItr(arrayList);
    }

    public final AttributeIterator getNamespaceAttributeIterator() {
        int n = this.nsMap == null ? 0 : this.nsMap.size();
        ArrayList arrayList = new ArrayList(n);
        this.addNameSpaceAttributues(arrayList);
        return new AttrItr(arrayList);
    }

    protected String getXMLNameAsXML(XMLName xMLName, boolean bl) {
        String string = null;
        string = bl ? xMLName.getPrefix() : this.getPrefixUsingParents(xMLName.getNamespaceUri());
        String string2 = null;
        string2 = string != null && string.length() > 0 ? string + ':' + xMLName.getLocalName() : xMLName.getLocalName();
        return string2;
    }

    protected void fillPrefix(ExpName expName) {
        String string = this.getPrefixUsingParents(expName.getNamespaceUri());
        expName.setPrefix(string);
    }

    protected void getSubAttributes(List list, boolean bl) {
        if (this.ID != null) {
            list.add(new XSDObjectAttribute("id", this.ID));
        }
    }

    private void addNameSpaceAttributues(List list) {
        if (this.nsMap == null) {
            return;
        }
        Set set = this.nsMap.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getValue();
            String string2 = (String)entry.getKey();
            if (string2 != null && string2.length() < 1) {
                string2 = null;
            }
            Attribute attribute = ElementFactory.createNamespaceAttribute(string2, string);
            list.add(attribute);
        }
    }

    private void addAnnotationAttributues(List list) {
        if (this.annotationAttributes == null) {
            return;
        }
        AttributeIterator attributeIterator = this.getAnnotationAttributes();
        while (attributeIterator.hasNext()) {
            list.add(attributeIterator.next());
        }
    }

    protected static final String booleanAttribute(Boolean bl) {
        if (bl == null || !bl.booleanValue()) {
            return "false";
        }
        return "true";
    }

    protected static final Boolean makeBoolean(boolean bl) {
        if (bl) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected static void addParticleAttributues(List list, XSDParticle xSDParticle) {
        String string;
        if (xSDParticle.isMinSet()) {
            string = xSDParticle.getMinOccurs().toString();
            list.add(new XSDObjectAttribute("minOccurs", string));
        }
        if (xSDParticle.isMaxSet()) {
            string = xSDParticle.isMaxUnbounded() ? UNBOUNDED : xSDParticle.getMaxOccurs().toString();
            list.add(new XSDObjectAttribute("maxOccurs", string));
        }
    }

    public Object clone() {
        try {
            XSDObject xSDObject = (XSDObject)super.clone();
            xSDObject.nsMap = this.nsMap != null ? (Map)((HashMap)this.nsMap).clone() : null;
            xSDObject.parent = this.parent;
            xSDObject.ID = this.ID;
            xSDObject.annotationAttributes = this.annotationAttributes != null ? (List)((ArrayList)this.annotationAttributes).clone() : null;
            xSDObject.annotation = this.annotation != null ? (XSDAnnotation)this.annotation.clone() : null;
            return xSDObject;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError("internal error");
        }
    }

    static /* synthetic */ XSDAnnotation access$100(XSDObject xSDObject) {
        return xSDObject.annotation;
    }
}

