/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.util.runtime;

import weblogic.utils.Debug;
import weblogic.xml.schema.binding.util.runtime.Accumulator;

public final class ShortList
implements Accumulator {
    private static final boolean DEBUG = false;
    private static final boolean ASSERT = false;
    private short[] store;
    private int size = 0;

    public ShortList() {
        this(16);
    }

    public ShortList(int n) {
        this.store = new short[n];
    }

    public short[] getStore() {
        return this.store;
    }

    public Object getFinalArray() {
        return this.getMinSizedArray();
    }

    public short[] getMinSizedArray() {
        short[] sArray = new short[this.size];
        System.arraycopy(this.store, 0, sArray, 0, this.size);
        return sArray;
    }

    public int getCapacity() {
        return this.store.length;
    }

    public int getSize() {
        return this.size;
    }

    public void append(Object object) {
        this.add(((Number)object).shortValue());
    }

    public void add(short s) {
        this.ensureCapacity(this.size + 1);
        this.store[this.size++] = s;
    }

    public short get(int n) {
        return this.store[n];
    }

    public void ensureCapacity(int n) {
        int n2 = this.store.length;
        if (n > n2) {
            short[] sArray = this.store;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.store = new short[n3];
            System.arraycopy(sArray, 0, this.store, 0, this.size);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        int n2;
        ShortList shortList = new ShortList();
        for (n2 = 0; n2 < 10000; n2 = (short)(n2 + 1)) {
            shortList.add((short)n2);
        }
        for (n2 = 0; n2 < 10000; ++n2) {
            n = shortList.get(n2);
            Debug.assertion(n == n2);
        }
        short[] sArray = shortList.getStore();
        for (n = 0; n < 10000; ++n) {
            short s;
            short s2 = shortList.get(n);
            Debug.assertion(s2 == (s = sArray[n]));
            Debug.assertion(s2 == n);
        }
        Debug.say("good");
    }
}

