/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.util.runtime;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import weblogic.xml.schema.binding.util.runtime.Accumulator;

public class ObjectAccumulator
implements Accumulator {
    protected final Collection store;
    private final Class componentType;

    public ObjectAccumulator(Class clazz, int n) {
        if (clazz.isPrimitive()) {
            String string = "component_type cannot be a primitive type";
            throw new IllegalArgumentException(string);
        }
        this.componentType = clazz;
        this.store = this.createNewStore(n);
    }

    protected Collection createNewStore(int n) {
        return new ArrayList(n);
    }

    public ObjectAccumulator(Class clazz) {
        this(clazz, 16);
    }

    public void append(Object object) {
        if (object != null && !this.componentType.isAssignableFrom(object.getClass())) {
            String string = "Invalid type: " + object.getClass().getName() + " expecting: " + this.componentType.getName();
            throw new IllegalArgumentException(string);
        }
        this.store.add(object);
    }

    public Object getFinalArray() {
        Object[] objectArray = (Object[])Array.newInstance(this.componentType, this.store.size());
        return this.store.toArray(objectArray);
    }

    public Collection getStore() {
        return this.store;
    }
}

