/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.util.runtime;

import weblogic.utils.Debug;
import weblogic.xml.schema.binding.util.runtime.Accumulator;

public final class LongList
implements Accumulator {
    private static final boolean DEBUG = false;
    private static final boolean ASSERT = false;
    private long[] store;
    private int size = 0;

    public LongList() {
        this(16);
    }

    public LongList(int n) {
        this.store = new long[n];
    }

    public long[] getStore() {
        return this.store;
    }

    public long[] getMinSizedArray() {
        long[] lArray = new long[this.size];
        System.arraycopy(this.store, 0, lArray, 0, this.size);
        return lArray;
    }

    public Object getFinalArray() {
        return this.getMinSizedArray();
    }

    public int getCapacity() {
        return this.store.length;
    }

    public int getSize() {
        return this.size;
    }

    public void append(Object object) {
        this.add(((Number)object).longValue());
    }

    public void add(long l) {
        this.ensureCapacity(this.size + 1);
        this.store[this.size++] = l;
    }

    public long get(int n) {
        return this.store[n];
    }

    public void ensureCapacity(int n) {
        int n2 = this.store.length;
        if (n > n2) {
            long[] lArray = this.store;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.store = new long[n3];
            System.arraycopy(lArray, 0, this.store, 0, this.size);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        for (int i = 0; i < 500; ++i) {
            LongList longList = new LongList();
            for (long j = 0L; j < 3000L; ++j) {
                longList.add(j);
            }
            for (int j = 0; j < 3000; ++j) {
                long l2 = longList.get(j);
                Debug.assertion(l2 == (long)j);
            }
            long[] lArray = longList.getStore();
            for (int j = 0; j < 3000; ++j) {
                long l3;
                long l4 = longList.get(j);
                Debug.assertion(l4 == (l3 = lArray[j]));
                Debug.assertion(l4 == (long)j);
            }
        }
        long l5 = System.currentTimeMillis();
        long l6 = l5 - l;
        System.out.println("milliseconds: " + l6 + " trials: " + 500);
        System.out.println("milliseconds PER iteration: " + (double)l6 / 500.0);
    }
}

