/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.util.runtime;

import weblogic.utils.Debug;
import weblogic.xml.schema.binding.util.runtime.Accumulator;

public final class IntList
implements Accumulator {
    private static final boolean DEBUG = false;
    private static final boolean ASSERT = false;
    private int[] store;
    private int size = 0;

    public IntList() {
        this(16);
    }

    public IntList(int n) {
        this.store = new int[n];
    }

    public int[] getStore() {
        return this.store;
    }

    public Object getFinalArray() {
        return this.getMinSizedArray();
    }

    public int[] getMinSizedArray() {
        int[] nArray = new int[this.size];
        System.arraycopy(this.store, 0, nArray, 0, this.size);
        return nArray;
    }

    public int getCapacity() {
        return this.store.length;
    }

    public int getSize() {
        return this.size;
    }

    public void append(Object object) {
        this.add(((Number)object).intValue());
    }

    public void add(int n) {
        this.ensureCapacity(this.size + 1);
        this.store[this.size++] = n;
    }

    public int get(int n) {
        return this.store[n];
    }

    public void ensureCapacity(int n) {
        int n2 = this.store.length;
        if (n > n2) {
            int[] nArray = this.store;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.store = new int[n3];
            System.arraycopy(nArray, 0, this.store, 0, this.size);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        int n2;
        IntList intList = new IntList();
        for (n2 = 0; n2 < 100000; ++n2) {
            intList.add(n2);
        }
        for (n2 = 0; n2 < 100000; ++n2) {
            n = intList.get(n2);
            Debug.assertion(n == n2);
        }
        int[] nArray = intList.getStore();
        for (n = 0; n < 100000; ++n) {
            int n3;
            int n4 = intList.get(n);
            Debug.assertion(n4 == (n3 = nArray[n]));
            Debug.assertion(n4 == n);
        }
        Debug.say("good");
    }
}

