/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.util.runtime;

import weblogic.utils.Debug;
import weblogic.xml.schema.binding.util.runtime.Accumulator;

public final class ByteList
implements Accumulator {
    private static final boolean DEBUG = false;
    private static final boolean ASSERT = false;
    private byte[] store;
    private int size = 0;

    public ByteList() {
        this(16);
    }

    public ByteList(int n) {
        this.store = new byte[n];
    }

    public byte[] getStore() {
        return this.store;
    }

    public byte[] getMinSizedArray() {
        byte[] byArray = new byte[this.size];
        System.arraycopy(this.store, 0, byArray, 0, this.size);
        return byArray;
    }

    public Object getFinalArray() {
        return this.getMinSizedArray();
    }

    public int getCapacity() {
        return this.store.length;
    }

    public int getSize() {
        return this.size;
    }

    public void append(Object object) {
        this.add(((Number)object).byteValue());
    }

    public void add(byte by) {
        this.ensureCapacity(this.size + 1);
        this.store[this.size++] = by;
    }

    public byte get(int n) {
        return this.store[n];
    }

    public void ensureCapacity(int n) {
        int n2 = this.store.length;
        if (n > n2) {
            byte[] byArray = this.store;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.store = new byte[n3];
            System.arraycopy(byArray, 0, this.store, 0, this.size);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        byte by;
        byte by2;
        ByteList byteList = new ByteList();
        for (by2 = 0; by2 < 126; by2 = (byte)(by2 + 1)) {
            byteList.add(by2);
        }
        for (by2 = 0; by2 < 126; by2 = (byte)(by2 + 1)) {
            by = byteList.get(by2);
            Debug.assertion(by == by2);
        }
        byte[] byArray = byteList.getStore();
        for (by = 0; by < 126; by = (byte)(by + 1)) {
            byte by3;
            byte by4 = byteList.get(by);
            Debug.assertion(by4 == (by3 = byArray[by]));
            Debug.assertion(by4 == by);
        }
        Debug.say("good");
    }
}

