/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.util.runtime;

import java.util.Random;
import weblogic.utils.Debug;
import weblogic.xml.schema.binding.util.runtime.Accumulator;

public final class BooleanList
implements Accumulator {
    private static final boolean DEBUG = false;
    private static final boolean ASSERT = false;
    private boolean[] store;
    private int size = 0;

    public BooleanList() {
        this(16);
    }

    public BooleanList(int n) {
        this.store = new boolean[n];
    }

    public boolean[] getStore() {
        return this.store;
    }

    public boolean[] getMinSizedArray() {
        boolean[] blArray = new boolean[this.size];
        System.arraycopy(this.store, 0, blArray, 0, this.size);
        return blArray;
    }

    public Object getFinalArray() {
        return this.getMinSizedArray();
    }

    public int getCapacity() {
        return this.store.length;
    }

    public int getSize() {
        return this.size;
    }

    public void append(Object object) {
        this.add((Boolean)object);
    }

    public void add(boolean bl) {
        this.ensureCapacity(this.size + 1);
        this.store[this.size++] = bl;
    }

    public boolean get(int n) {
        return this.store[n];
    }

    public void ensureCapacity(int n) {
        int n2 = this.store.length;
        if (n > n2) {
            boolean[] blArray = this.store;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.store = new boolean[n3];
            System.arraycopy(blArray, 0, this.store, 0, this.size);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        int n2;
        Random random = new Random();
        BooleanList booleanList = new BooleanList();
        for (n2 = 0; n2 < 1206; ++n2) {
            booleanList.add(random.nextBoolean());
        }
        for (n2 = 0; n2 < 1206; ++n2) {
            n = booleanList.get(n2);
        }
        boolean[] blArray = booleanList.getStore();
        for (n = 0; n < 1206; ++n) {
            boolean bl;
            boolean bl2 = booleanList.get(n);
            Debug.assertion(bl2 == (bl = blArray[n]));
        }
        Debug.say("good");
    }
}

