/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.util.runtime;

import weblogic.utils.AssertionError;
import weblogic.xml.schema.binding.util.runtime.Accumulator;
import weblogic.xml.schema.binding.util.runtime.BooleanList;
import weblogic.xml.schema.binding.util.runtime.ByteList;
import weblogic.xml.schema.binding.util.runtime.CharList;
import weblogic.xml.schema.binding.util.runtime.DoubleList;
import weblogic.xml.schema.binding.util.runtime.FloatList;
import weblogic.xml.schema.binding.util.runtime.IntList;
import weblogic.xml.schema.binding.util.runtime.LongList;
import weblogic.xml.schema.binding.util.runtime.ObjectAccumulator;
import weblogic.xml.schema.binding.util.runtime.ShortList;
import weblogic.xml.schema.binding.util.runtime.StringList;

public final class AccumulatorFactory {
    static /* synthetic */ Class class$java$lang$String;

    public static Accumulator createAccumulator(Class clazz) {
        return AccumulatorFactory.createAccumulator(clazz, 16);
    }

    public static Accumulator createAccumulator(Class clazz, int n) {
        if (clazz.isPrimitive()) {
            if (Integer.TYPE.equals(clazz)) {
                return new IntList(n);
            }
            if (Short.TYPE.equals(clazz)) {
                return new ShortList(n);
            }
            if (Long.TYPE.equals(clazz)) {
                return new LongList(n);
            }
            if (Float.TYPE.equals(clazz)) {
                return new FloatList(n);
            }
            if (Double.TYPE.equals(clazz)) {
                return new DoubleList(n);
            }
            if (Byte.TYPE.equals(clazz)) {
                return new ByteList(n);
            }
            if (Boolean.TYPE.equals(clazz)) {
                return new BooleanList(n);
            }
            if (Character.TYPE.equals(clazz)) {
                return new CharList(n);
            }
            throw new AssertionError("unknown primitive type: " + clazz);
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = AccumulatorFactory.class$("java.lang.String")) : class$java$lang$String).equals(clazz)) {
            return new StringList(n);
        }
        return new ObjectAccumulator(clazz, n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

