/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.util;

public abstract class StdNamespace {
    private static StdNamespace stdNamespace;
    public static final SoapVersion SOAP11;
    public static final SoapVersion SOAP12;

    StdNamespace() {
    }

    public static StdNamespace instance() {
        return stdNamespace;
    }

    public abstract String soapEnvelope();

    public abstract String soapEncoding();

    public abstract String schema();

    public abstract String schemaInstance();

    public abstract String wsdl();

    public abstract String wsdlSoap();

    public abstract SoapVersion soapVersion();

    private static StdNamespace newInstance() {
        try {
            String string = System.getProperty("weblogic.webservice.soap.version");
            if (string == null || "1.1".equals(string)) {
                return new Soap11Namespace();
            }
            if ("1.2".equals(string)) {
                System.out.println("NOTICE: setting SOAP version to: 1.2");
                return new Soap12Namespace();
            }
            System.out.println("WARNING: unknown soap version:" + string);
            System.out.println("WARNING: using SOAP 1.1 instead");
            return new Soap11Namespace();
        }
        catch (Throwable throwable) {
            System.out.println("WARNING: unable to find soap version:" + throwable);
            System.out.println("WARNING: using SOAP 1.1 instead");
            return new Soap11Namespace();
        }
    }

    static {
        SOAP11 = new SoapVersion();
        SOAP12 = new SoapVersion();
        stdNamespace = StdNamespace.newInstance();
    }

    public static class Soap12Namespace
    extends Soap11Namespace {
        public String soapEnvelope() {
            return "http://www.w3.org/2003/05/soap-envelope";
        }

        public String soapEncoding() {
            return "http://www.w3.org/2003/05/soap-encoding";
        }

        public SoapVersion soapVersion() {
            return SOAP12;
        }
    }

    public static class Soap11Namespace
    extends StdNamespace {
        public String soapEnvelope() {
            return "http://schemas.xmlsoap.org/soap/envelope/";
        }

        public String soapEncoding() {
            return "http://schemas.xmlsoap.org/soap/encoding/";
        }

        public String schema() {
            return "http://www.w3.org/2001/XMLSchema";
        }

        public String schemaInstance() {
            return "http://www.w3.org/2001/XMLSchema-instance";
        }

        public String wsdl() {
            return "http://schemas.xmlsoap.org/wsdl/";
        }

        public String wsdlSoap() {
            return "http://schemas.xmlsoap.org/wsdl/soap/";
        }

        public SoapVersion soapVersion() {
            return SOAP11;
        }
    }

    public static class SoapVersion {
    }
}

