/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.internal.codegen;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.collections.Stack;
import weblogic.xml.schema.binding.BindingConfiguration;
import weblogic.xml.schema.binding.BindingException;
import weblogic.xml.schema.binding.SchemaContext;
import weblogic.xml.schema.binding.SchemaContextFactory;
import weblogic.xml.schema.binding.TypeDescriptor;
import weblogic.xml.schema.binding.TypeMapping;
import weblogic.xml.schema.binding.TypeMappingEntry;
import weblogic.xml.schema.binding.internal.NameUtil;
import weblogic.xml.schema.binding.internal.SoapArrayDescriptor;
import weblogic.xml.schema.binding.internal.SoapTypes;
import weblogic.xml.schema.binding.internal.codegen.ArrayUtils;
import weblogic.xml.schema.binding.internal.codegen.BeanDescriptor;
import weblogic.xml.schema.binding.internal.codegen.BeanProperty;
import weblogic.xml.schema.binding.internal.codegen.SchemaInspector;
import weblogic.xml.schema.binding.internal.codegen.Utils;
import weblogic.xml.schema.binding.internal.codegen.XMLNameAdjacencyList;
import weblogic.xml.schema.model.ContentType;
import weblogic.xml.schema.model.ExpName;
import weblogic.xml.schema.model.SchemaForSchema;
import weblogic.xml.schema.model.SchemaTypes;
import weblogic.xml.schema.model.SimpleSchemaResolver;
import weblogic.xml.schema.model.SimpleTypeVariety;
import weblogic.xml.schema.model.XSDAnyType;
import weblogic.xml.schema.model.XSDAttribute;
import weblogic.xml.schema.model.XSDComplexContent;
import weblogic.xml.schema.model.XSDComplexContentRestriction;
import weblogic.xml.schema.model.XSDComplexType;
import weblogic.xml.schema.model.XSDElement;
import weblogic.xml.schema.model.XSDException;
import weblogic.xml.schema.model.XSDList;
import weblogic.xml.schema.model.XSDModelGroup;
import weblogic.xml.schema.model.XSDModelGroupDefn;
import weblogic.xml.schema.model.XSDObject;
import weblogic.xml.schema.model.XSDParticle;
import weblogic.xml.schema.model.XSDSchema;
import weblogic.xml.schema.model.XSDSimpleType;
import weblogic.xml.schema.model.util.SchemaMap;
import weblogic.xml.schema.types.XSDQName;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.XMLName;

/*
 * Exception performing whole class analysis ignored.
 */
public class SchemaInspector {
    private static final boolean DEBUG = false;
    static final String ANON_SUFFIX = "AnonType";
    private static final Map builtinDefaultsMap = SchemaInspector.createBuiltinDefaultsMap();
    private static final Map primitiveWrapperMap = SchemaInspector.createPrimitiveWrapperMap();
    private static final Set primitiveSet = SchemaInspector.createPrimitiveSet();
    private final DescriptorMap beans = new DescriptorMap(null);
    private final AnonTypeNameSet anonTypeNames = new AnonTypeNameSet(null);
    private final Map anonTypeMap = new IdentityHashMap();
    private final TypeMapping mapping;
    private final BindingConfiguration conf;
    private String currentTargetNamespace = null;
    private final boolean trace;
    private int currentDepth = 0;
    private static final String soapenc_11_schema_uri = "http://schemas.xmlsoap.org/soap/encoding/";
    private XSDSchema soapenc_11_schema;
    private static final Class FALLBACK_JAVA_TYPE = class$javax$xml$soap$SOAPElement == null ? (class$javax$xml$soap$SOAPElement = SchemaInspector.class$("javax.xml.soap.SOAPElement")) : class$javax$xml$soap$SOAPElement;
    private static final XMLName UNUSED = ElementFactory.createXMLName("unused");
    private static final String ARRAY_EXTENSION = "Array";
    private static final String SIMPLE_CONTENT_PROP = "simpleContent";
    static /* synthetic */ Class class$javax$xml$soap$SOAPElement;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$weblogic$xml$schema$types$Duration;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;

    public SchemaInspector(TypeMapping typeMapping, BindingConfiguration bindingConfiguration) {
        this.mapping = typeMapping;
        this.conf = bindingConfiguration;
        this.trace = bindingConfiguration.isVerbose();
    }

    public Map getDescriptorMap() {
        return this.beans.getMap();
    }

    public static Class lookupBuiltinClass(XMLName xMLName) {
        return (Class)builtinDefaultsMap.get(xMLName);
    }

    Map createDescriptors(SchemaMap schemaMap, TypeDescriptor[] typeDescriptorArray) throws BindingException {
        try {
            for (int i = 0; i < typeDescriptorArray.length; ++i) {
                TypeDescriptor typeDescriptor = typeDescriptorArray[i];
                boolean bl = typeDescriptor.isException();
                if (typeDescriptor.isElement()) {
                    this.createDescriptorForElement(typeDescriptor.getSchemaName(), schemaMap, bl);
                } else {
                    this.createDescriptorForType(typeDescriptor.getSchemaName(), schemaMap, bl);
                }
                if (!bl) continue;
                this.fixExceptionType(typeDescriptor);
            }
            this.doInheritedTypes(schemaMap);
            this.updateInheritanceProperties();
            this.cleanFallbackDeps();
        }
        catch (XSDException xSDException) {
            throw new BindingException("schema error", xSDException);
        }
        return this.getDescriptorMap();
    }

    private void fixExceptionType(TypeDescriptor typeDescriptor) throws BindingException {
        BeanDescriptor beanDescriptor = this.beans.get(typeDescriptor.getSchemaName());
        Debug.assertion(beanDescriptor != null, "NOTHING FOR " + typeDescriptor);
        beanDescriptor.setException(true);
    }

    private void createDescriptorForElement(XMLName xMLName, SchemaMap schemaMap, boolean bl) throws BindingException, XSDException {
        XSDSchema xSDSchema = this.getSchemaForType(xMLName, schemaMap, true);
        XSDElement xSDElement = xSDSchema.lookupElement(xMLName);
        if (xSDElement == null) {
            throw new BindingException("unable to locate definition of element: " + xMLName);
        }
        BeanDescriptor beanDescriptor = this.createDescriptorsFromElement(xSDElement, xSDSchema, bl);
        if (bl && beanDescriptor != null) {
            beanDescriptor.setException(true);
        }
    }

    private void createDescriptorForType(XMLName xMLName, SchemaMap schemaMap, boolean bl) throws BindingException, XSDException {
        XSDSchema xSDSchema = this.getSchemaForType(xMLName, schemaMap, false);
        BeanDescriptor beanDescriptor = this.getDescriptors(xMLName, xSDSchema);
        if (bl) {
            beanDescriptor.setException(true);
        }
    }

    Map createDescriptors(SchemaMap schemaMap) throws BindingException {
        Iterator iterator = SchemaInspector.getAllIncludedSchemas(schemaMap).iterator();
        try {
            while (iterator.hasNext()) {
                XSDSchema xSDSchema = (XSDSchema)iterator.next();
                this.createDescriptors(xSDSchema);
            }
        }
        catch (XSDException xSDException) {
            throw new BindingException("schema error", xSDException);
        }
        this.cleanFallbackDeps();
        this.updateInheritanceProperties();
        return this.getDescriptorMap();
    }

    private XSDSchema getSchemaForType(XMLName xMLName, SchemaMap schemaMap, boolean bl) throws BindingException, XSDException {
        String string = xMLName.getNamespaceUri();
        XSDSchema xSDSchema = SchemaForSchema.getSchemaForSchemas();
        if (xSDSchema.getTargetNamespace().equals(string)) {
            return xSDSchema;
        }
        if ("http://schemas.xmlsoap.org/soap/encoding/".equals(string)) {
            return this.getSoapencSchema();
        }
        XSDSchema xSDSchema2 = schemaMap.getSchema(string);
        if (xSDSchema2 != null) {
            return xSDSchema2;
        }
        Iterator iterator = schemaMap.getMap().values().iterator();
        while (iterator.hasNext()) {
            XSDSchema xSDSchema3 = (XSDSchema)iterator.next();
            if (!(bl ? xSDSchema3.lookupElement(xMLName) != null : xSDSchema3.lookupType(xMLName) != null)) continue;
            return xSDSchema3;
        }
        throw new BindingException("unable to find a definition for " + (bl ? "element " : "type ") + xMLName);
    }

    private XSDSchema getSoapencSchema() throws XSDException {
        if (this.soapenc_11_schema == null) {
            XSDSchema xSDSchema = new XSDSchema();
            SimpleSchemaResolver simpleSchemaResolver = new SimpleSchemaResolver();
            this.soapenc_11_schema = simpleSchemaResolver.resolveSchemaLocation(xSDSchema, "http://schemas.xmlsoap.org/soap/encoding/");
        }
        return this.soapenc_11_schema;
    }

    private void createDescriptors(XSDSchema xSDSchema) throws BindingException, XSDException {
        this.createDescriptorsFromTypes(xSDSchema);
        this.createDescriptorsFromElements(xSDSchema);
    }

    private void createDescriptorsFromTypes(XSDSchema xSDSchema) throws BindingException, XSDException {
        Iterator iterator = xSDSchema.getTypes().values().iterator();
        while (iterator.hasNext()) {
            XSDAnyType xSDAnyType = (XSDAnyType)iterator.next();
            XMLName xMLName = xSDAnyType.getXMLName();
            this.getDescriptors(xMLName, xSDSchema);
        }
    }

    private void createDescriptorsFromElements(XSDSchema xSDSchema) throws BindingException, XSDException {
        Iterator iterator = xSDSchema.getElements().values().iterator();
        while (iterator.hasNext()) {
            XSDElement xSDElement = (XSDElement)iterator.next();
            this.createDescriptorsFromElement(xSDElement, xSDSchema, false);
        }
    }

    private BeanDescriptor createDescriptorsFromElement(XSDElement xSDElement, XSDSchema xSDSchema, boolean bl) throws BindingException, XSDException {
        BeanDescriptor beanDescriptor;
        Debug.assertion(xSDElement != null, "null element not allowed");
        XMLName xMLName = xSDElement.getXMLName();
        Debug.assertion(xMLName != null);
        if (xSDElement.getAnonymousType() != null) {
            if (xSDSchema.getType(xMLName) == null) {
                BeanDescriptor beanDescriptor2 = this.getDescriptors(xSDElement.getXMLName(), xSDSchema);
                beanDescriptor2.setAnonymousType(true);
                beanDescriptor = beanDescriptor2;
            } else {
                beanDescriptor = this.setFallbackDescriptor(xMLName, xSDSchema);
            }
        } else {
            XSDAnyType xSDAnyType = xSDElement.getTypeObject();
            XMLName xMLName2 = xSDAnyType.getXMLName();
            XSDSchema xSDSchema2 = xSDSchema.getSchemaForName(xMLName2);
            BeanDescriptor beanDescriptor3 = this.getDescriptors(xMLName2, xSDSchema2);
            if (!xMLName.equals(xMLName2)) {
                Debug.assertion(beanDescriptor3 != null, "type not found: " + xSDAnyType.getXMLName());
                if (bl) {
                    beanDescriptor3.setException(true);
                }
                BeanDescriptor beanDescriptor4 = (BeanDescriptor)beanDescriptor3.clone();
                beanDescriptor4.setXmlName(xSDElement.getXMLName());
                beanDescriptor4.setElementType(beanDescriptor3);
                beanDescriptor4.setInMap(false);
                this.beans.put(beanDescriptor4);
                beanDescriptor = beanDescriptor4;
            } else {
                beanDescriptor = null;
            }
        }
        return beanDescriptor;
    }

    BeanDescriptor getDescriptors(XMLName xMLName, XSDSchema xSDSchema) throws BindingException, XSDException {
        return this.getDescriptors(xMLName, xSDSchema, false);
    }

    BeanDescriptor getDescriptors(XMLName xMLName, XSDSchema xSDSchema, boolean bl) throws BindingException, XSDException {
        if (xMLName == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (xSDSchema == null) {
            throw new NullPointerException("schema cannot be null");
        }
        XSDAnyType xSDAnyType = SchemaInspector.getType(xMLName, xSDSchema);
        Debug.assertion(xSDAnyType != null);
        String string = xSDAnyType.getTargetNamespace();
        if (string != null) {
            this.currentTargetNamespace = string;
        }
        XMLName xMLName2 = this.fillUri(xMLName);
        String string2 = this.getExpectedClassNameFromXMLName(xMLName2, bl);
        SchemaContext schemaContext = SchemaContextFactory.newInstance().createSchemaContext(string2);
        BeanDescriptor beanDescriptor = null;
        if (!primitiveSet.contains(string2)) {
            beanDescriptor = this.beans.get(xMLName2);
        }
        if (beanDescriptor == null) {
            TypeMappingEntry typeMappingEntry;
            if (this.trace) {
                this.trace_pre(xMLName.toString());
            }
            if ((typeMappingEntry = this.mapping.get(xMLName2, schemaContext)) != null) {
                beanDescriptor = this.buildDescriptorFromEntry(typeMappingEntry, xSDAnyType);
                this.beans.put(beanDescriptor);
            } else {
                beanDescriptor = this.createAddAndFillBeanDescriptor(xMLName2, xSDAnyType, xSDSchema);
            }
            if (this.trace) {
                this.trace_post(beanDescriptor);
            }
        }
        return beanDescriptor;
    }

    private void trace_pre(String string) {
        ++this.currentDepth;
        int n = this.currentDepth;
        for (int i = 0; i < n; ++i) {
            System.out.print("-");
        }
        System.out.println("inspecting: " + string);
    }

    private void trace_post(BeanDescriptor beanDescriptor) {
        int n = this.currentDepth;
        for (int i = 0; i < n; ++i) {
            System.out.print("-");
        }
        System.out.println("mapped:     " + beanDescriptor.getXmlName() + " => " + SchemaInspector.pretty_class(beanDescriptor.getJavaName()));
        --this.currentDepth;
    }

    private static String pretty_class(String string) {
        if (string.charAt(0) == '[') {
            return ArrayUtils.getArrayDeclString(string);
        }
        return string;
    }

    private BeanDescriptor buildDescriptorFromEntry(TypeMappingEntry typeMappingEntry, XSDAnyType xSDAnyType) throws BindingException, XSDException {
        BeanDescriptor beanDescriptor = Utils.buildDescriptor((TypeMappingEntry)typeMappingEntry);
        if (xSDAnyType.getTypeCode() == 7) {
            beanDescriptor.setSimpleContent(true);
        } else if (xSDAnyType.getTypeCode() == 4) {
            XSDComplexType xSDComplexType = (XSDComplexType)xSDAnyType;
            beanDescriptor.setSimpleContent(xSDComplexType.getContentType() == ContentType.SIMPLE);
        } else {
            throw new AssertionError("unknown type: " + xSDAnyType);
        }
        return beanDescriptor;
    }

    private BeanDescriptor createAddAndFillBeanDescriptor(XMLName xMLName, XSDAnyType xSDAnyType, XSDSchema xSDSchema) throws BindingException, XSDException {
        BeanDescriptor beanDescriptor = this.initBeanDescriptor(xMLName);
        this.beans.put(beanDescriptor);
        if (xSDAnyType instanceof XSDComplexType) {
            XSDComplexType xSDComplexType = (XSDComplexType)xSDAnyType;
            this.fillBeanDescriptor(beanDescriptor, xMLName, xSDComplexType, xSDSchema);
        } else if (xSDAnyType instanceof XSDSimpleType) {
            XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDAnyType;
            this.fillBeanDescriptor(beanDescriptor, xMLName, xSDSimpleType, xSDSchema);
        } else {
            this.fillFallbackBeanDescriptor(beanDescriptor, xMLName);
        }
        return beanDescriptor;
    }

    private BeanDescriptor setFallbackDescriptor(XMLName xMLName, XSDSchema xSDSchema) throws BindingException {
        XMLName xMLName2 = this.fillUri(xMLName);
        BeanDescriptor beanDescriptor = this.beans.get(xMLName2);
        if (beanDescriptor == null) {
            beanDescriptor = new BeanDescriptor();
            beanDescriptor.setXmlName(xMLName2);
            this.beans.put(beanDescriptor);
        }
        this.fillFallbackBeanDescriptor(beanDescriptor, xMLName2);
        return beanDescriptor;
    }

    private void fillFallbackBeanDescriptor(BeanDescriptor beanDescriptor, XMLName xMLName) throws BindingException {
        beanDescriptor.setXmlName(xMLName);
        beanDescriptor.setJavaName(FALLBACK_JAVA_TYPE.getName());
        beanDescriptor.setFallback(true);
        if (this.trace) {
            System.out.println("WARNING: Unable to fully map " + beanDescriptor.getXmlName() + " using " + beanDescriptor.getJavaName());
        }
    }

    private void updateInheritanceProperties() throws BindingException {
        Iterator iterator = DescriptorMap.access$200((DescriptorMap)this.beans);
        while (iterator.hasNext()) {
            BeanDescriptor beanDescriptor = (BeanDescriptor)iterator.next();
            BeanDescriptor beanDescriptor2 = beanDescriptor.getSuperType();
            if (beanDescriptor2 == null) continue;
            beanDescriptor2.setParentType(true);
        }
    }

    private void doInheritedTypes(SchemaMap schemaMap) throws XSDException, BindingException {
        XMLNameAdjacencyList xMLNameAdjacencyList = this.buildInheritanceAdjacencyList(schemaMap);
        Set set = this.beans.getMap().keySet();
        Stack stack = new Stack(set.size());
        stack.addAll(set);
        while (!stack.isEmpty()) {
            XMLName xMLName = (XMLName)stack.pop();
            Collection collection = xMLNameAdjacencyList.getVertices(xMLName);
            if (collection.isEmpty()) continue;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                XMLName xMLName2 = (XMLName)iterator.next();
                XSDSchema xSDSchema = this.getSchemaForType(xMLName2, schemaMap, false);
                BeanDescriptor beanDescriptor = this.beans.get(xMLName2);
                if (beanDescriptor == null) {
                    beanDescriptor = this.getDescriptors(xMLName2, xSDSchema);
                }
                if (beanDescriptor.isException()) {
                    this.beans.get(xMLName).setException(true);
                }
                stack.push(xMLName2);
            }
        }
    }

    private XMLNameAdjacencyList buildInheritanceAdjacencyList(SchemaMap schemaMap) throws XSDException {
        XMLNameAdjacencyList xMLNameAdjacencyList = new XMLNameAdjacencyList();
        Iterator iterator = schemaMap.getMap().values().iterator();
        while (iterator.hasNext()) {
            XSDSchema xSDSchema = (XSDSchema)iterator.next();
            Iterator iterator2 = xSDSchema.getAllTypes().values().iterator();
            while (iterator2.hasNext()) {
                XSDAnyType xSDAnyType = (XSDAnyType)iterator2.next();
                XMLName xMLName = xSDAnyType.getXMLName();
                Debug.assertion(xMLName != null);
                XMLName xMLName2 = xSDAnyType.getBaseType();
                if (xMLName2 == null) continue;
                xMLNameAdjacencyList.put(xMLName2, xMLName);
            }
        }
        return xMLNameAdjacencyList;
    }

    private void cleanFallbackDeps() throws BindingException {
        XMLNameAdjacencyList xMLNameAdjacencyList = this.buildDependencyAdjList();
        HashSet<XMLName> hashSet = new HashSet<XMLName>();
        Set set = this.beans.getMap().keySet();
        Stack stack = new Stack(set.size());
        stack.addAll(set);
        while (!stack.isEmpty()) {
            Collection collection;
            BeanDescriptor beanDescriptor;
            XMLName xMLName = (XMLName)stack.pop();
            if (hashSet.contains(xMLName) || !(beanDescriptor = this.beans.get(xMLName)).isFallback() || (collection = xMLNameAdjacencyList.getVertices(xMLName)).isEmpty()) continue;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                XMLName xMLName2 = (XMLName)iterator.next();
                BeanDescriptor beanDescriptor2 = this.beans.get(xMLName2);
                this.fillFallbackBeanDescriptor(beanDescriptor2, xMLName2);
                stack.push(xMLName2);
            }
            hashSet.add(xMLName);
        }
    }

    private XMLNameAdjacencyList buildDependencyAdjList() {
        XMLNameAdjacencyList xMLNameAdjacencyList = new XMLNameAdjacencyList();
        Iterator iterator = DescriptorMap.access$200((DescriptorMap)this.beans);
        while (iterator.hasNext()) {
            BeanDescriptor beanDescriptor;
            BeanDescriptor beanDescriptor2 = (BeanDescriptor)iterator.next();
            List list = beanDescriptor2.getDependentDescriptors();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                beanDescriptor = (BeanDescriptor)iterator2.next();
                xMLNameAdjacencyList.put(beanDescriptor.getXmlName(), beanDescriptor2.getXmlName());
            }
            beanDescriptor = beanDescriptor2.getSuperType();
            if (beanDescriptor == null) continue;
            xMLNameAdjacencyList.put(beanDescriptor.getXmlName(), beanDescriptor2.getXmlName());
        }
        return xMLNameAdjacencyList;
    }

    private void fillBeanDescriptor(BeanDescriptor beanDescriptor, XMLName xMLName, XSDSimpleType xSDSimpleType, XSDSchema xSDSchema) throws BindingException, XSDException {
        beanDescriptor.setComplexType(false);
        beanDescriptor.setSimpleContent(true);
        if (xSDSimpleType.getVariety() == SimpleTypeVariety.ATOMIC) {
            if (this.fillEnumerationDescriptor(beanDescriptor, xMLName, xSDSimpleType, xSDSchema)) {
                return;
            }
            boolean bl = this.handleFacets(beanDescriptor, xSDSimpleType, xSDSchema);
            if (bl) {
                return;
            }
        } else {
            if (xSDSimpleType.getVariety() == SimpleTypeVariety.LIST) {
                BeanDescriptor beanDescriptor2;
                Object object;
                XSDList xSDList = xSDSimpleType.getListResolved();
                Debug.assertion(xSDList != null, "null list for " + beanDescriptor);
                XMLName xMLName2 = xSDList.getItemType();
                if (xMLName2 == null) {
                    object = xSDList.getSimpleType();
                    Debug.assertion(object != null);
                    beanDescriptor2 = this.createAnonymousType((XSDAnyType)object, xMLName, xSDSchema);
                } else {
                    beanDescriptor2 = this.getDescriptors(xMLName2, xSDSchema);
                }
                object = beanDescriptor2.getJavaName();
                String string = ArrayUtils.getArrayClassName((String)object, 1);
                beanDescriptor.setJavaName(string);
                beanDescriptor.setImplName(string);
                beanDescriptor.setArray(true);
                beanDescriptor.setSoapArrayDimension(1);
                Debug.assertion(beanDescriptor.isSimpleContent());
                BeanProperty beanProperty = new BeanProperty();
                beanProperty.setMaxOccurs(Long.MAX_VALUE);
                beanProperty.setType(beanDescriptor2);
                beanProperty.setName("list_type_unused");
                beanProperty.setXmlName(ElementFactory.createXMLName("list_type_unused"));
                SchemaInspector.addPropertyToType(beanDescriptor, beanProperty);
                return;
            }
            if (xSDSimpleType.getVariety() != SimpleTypeVariety.UNION) {
                throw new AssertionError("unknown simpleType at " + xMLName);
            }
        }
        this.fillFallbackBeanDescriptor(beanDescriptor, xMLName);
    }

    private boolean handleFacets(BeanDescriptor beanDescriptor, XSDAnyType xSDAnyType, XSDSchema xSDSchema) throws XSDException, BindingException {
        this.setFacetsOnDesc(beanDescriptor, xSDAnyType);
        BeanDescriptor beanDescriptor2 = this.getBuiltinBaseDescriptor(xSDAnyType, xSDSchema);
        BeanProperty beanProperty = new BeanProperty();
        beanProperty.setType(beanDescriptor2);
        beanProperty.setXmlName(UNUSED);
        SchemaInspector.addPropertyToType(beanDescriptor, beanProperty);
        beanDescriptor.setJavaName(beanDescriptor2.getJavaName());
        beanDescriptor.setPrimitive(beanDescriptor2.isPrimitive());
        beanDescriptor.setUserJavaType(beanDescriptor2.isUserJavaType());
        beanDescriptor.setImplName(beanDescriptor2.getImplName());
        beanDescriptor.setInMap(false);
        return true;
    }

    private void setFacetsOnDesc(BeanDescriptor beanDescriptor, XSDAnyType xSDAnyType) throws XSDException {
        ArrayList arrayList = xSDAnyType.getResolvedFacets();
        boolean bl = XSDAnyType.containsFacets(arrayList);
        if (bl) {
            beanDescriptor.setFacets(arrayList);
        } else {
            beanDescriptor.setFacets(null);
        }
    }

    private boolean fillEnumerationDescriptor(BeanDescriptor beanDescriptor, XMLName xMLName, XSDSimpleType xSDSimpleType, XSDSchema xSDSchema) throws XSDException, BindingException {
        ArrayList arrayList = xSDSimpleType.getResolvedFacets();
        Set set = (Set)arrayList.get(5);
        if (set == null || set.isEmpty()) {
            return false;
        }
        String[] stringArray = new String[set.size()];
        BeanDescriptor beanDescriptor2 = this.getBuiltinBaseDescriptor(xSDSimpleType, xSDSchema);
        if (SchemaTypes.XSD_QNAME_ENAME.equals(beanDescriptor2.getXmlName())) {
            int n = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = XSDQName.getPrefixFromQName(string);
                String string3 = xSDSimpleType.getURIUsingParents(string2);
                QName qName = XSDQName.convertXml(string, string3);
                stringArray[n++] = qName.toString();
            }
        } else {
            set.toArray(stringArray);
        }
        beanDescriptor.setEnumValues(stringArray);
        BeanProperty beanProperty = new BeanProperty();
        beanProperty.setType(beanDescriptor2);
        beanProperty.setXmlName(UNUSED);
        SchemaInspector.addPropertyToType(beanDescriptor, beanProperty);
        return true;
    }

    private BeanDescriptor getBuiltinBaseDescriptor(XSDAnyType xSDAnyType, XSDSchema xSDSchema) throws XSDException, BindingException {
        XSDAnyType xSDAnyType2 = xSDAnyType;
        while (!xSDAnyType2.isBuiltin()) {
            xSDAnyType2 = xSDAnyType2.getBaseTypeObject();
        }
        return this.getDescriptors(xSDAnyType2.getXMLName(), xSDSchema);
    }

    private void fillBeanDescriptor(BeanDescriptor beanDescriptor, XMLName xMLName, XSDComplexType xSDComplexType, XSDSchema xSDSchema) throws BindingException, XSDException {
        BeanDescriptor beanDescriptor2;
        Object object;
        XSDElement xSDElement = xSDSchema.getElement(xMLName);
        if (xSDElement != null && xSDElement.getAnonymousType() != null && xSDElement.getRef() == null && xSDElement.getType() == null) {
            beanDescriptor.setAnonymousType(true);
        }
        beanDescriptor.setComplexType(true);
        ContentType contentType = xSDComplexType.getContentType();
        beanDescriptor.setSimpleContent(contentType == ContentType.SIMPLE);
        beanDescriptor.setAbstract(xSDComplexType.isAbstractDefaulted());
        if (contentType == ContentType.MIXED) {
            this.fillFallbackBeanDescriptor(beanDescriptor, xMLName);
            return;
        }
        if (SoapTypes.Array.equals(xSDComplexType.getBaseType())) {
            this.fixSoapArrayType(beanDescriptor, xSDComplexType, xSDSchema);
            return;
        }
        XSDAttribute[] xSDAttributeArray = xSDComplexType.getAttributesExpanded();
        if (contentType == ContentType.SIMPLE) {
            object = xSDComplexType.getBaseTypeObject();
            if (((XSDObject)object).getTypeCode() == 7) {
                this.addSimpleContentProp(beanDescriptor, xSDComplexType, xSDSchema);
            }
            this.setFacetsOnDesc(beanDescriptor, xSDComplexType);
        }
        if (xSDComplexType.isRestriction()) {
            object = this.realBaseType(xSDComplexType);
            if (contentType == ContentType.SIMPLE) {
                if (object != null) {
                    beanDescriptor2 = this.getDescriptors((XMLName)object, xSDSchema);
                    beanDescriptor.setSuperType(beanDescriptor2);
                }
            } else if (object != null) {
                this.fillFallbackBeanDescriptor(beanDescriptor, xMLName);
                return;
            }
        }
        if (xSDComplexType.isExtension() && (object = this.realBaseType(xSDComplexType)) != null) {
            beanDescriptor2 = this.getDescriptors((XMLName)object, xSDSchema);
            beanDescriptor.setSuperType(beanDescriptor2);
        }
        if (!this.contentModelToProperties(beanDescriptor, (XSDParticle)(object = xSDComplexType.getResolvedContentModel()), xSDSchema)) {
            this.fillFallbackBeanDescriptor(beanDescriptor, xMLName);
            return;
        }
        for (int i = 0; i < xSDAttributeArray.length; ++i) {
            XSDAttribute xSDAttribute = xSDAttributeArray[i];
            BeanProperty beanProperty = this.attributeToProperty(xSDAttribute, xMLName, xSDSchema);
            SchemaInspector.addPropertyToType(beanDescriptor, beanProperty);
        }
        this.fixArrayTypes(beanDescriptor);
    }

    private void addSimpleContentProp(BeanDescriptor beanDescriptor, XSDComplexType xSDComplexType, XSDSchema xSDSchema) throws XSDException, BindingException {
        Debug.assertion(xSDComplexType.getContentType() == ContentType.SIMPLE);
        BeanDescriptor beanDescriptor2 = this.getBuiltinBaseDescriptor(xSDComplexType, xSDSchema);
        BeanProperty beanProperty = this.getSimpleContentPropertyTemplate();
        beanProperty.setType(beanDescriptor2);
        SchemaInspector.addPropertyToType(beanDescriptor, beanProperty);
    }

    private XMLName realBaseType(XSDAnyType xSDAnyType) throws XSDException {
        XMLName xMLName = xSDAnyType.getBaseType();
        if (xMLName == null) {
            return null;
        }
        if (SchemaTypes.XSD_ANY_TYPE_ENAME.equals(xMLName)) {
            return null;
        }
        XSDAnyType xSDAnyType2 = xSDAnyType.getBaseTypeObject();
        if (xSDAnyType2.getTypeCode() != 4) {
            return null;
        }
        return xMLName;
    }

    private boolean contentModelToProperties(BeanDescriptor beanDescriptor, XSDParticle xSDParticle, XSDSchema xSDSchema) throws BindingException, XSDException {
        XSDModelGroupDefn xSDModelGroupDefn;
        if (xSDParticle == null) {
            return true;
        }
        if (xSDParticle instanceof XSDModelGroupDefn) {
            xSDModelGroupDefn = (XSDModelGroupDefn)xSDParticle;
            xSDParticle = xSDModelGroupDefn.getContentModelResolved();
        }
        if (xSDParticle instanceof XSDModelGroup) {
            xSDModelGroupDefn = (XSDModelGroup)xSDParticle;
            List list = SchemaInspector.getFlattenedContentModel(beanDescriptor, (XSDModelGroup)xSDModelGroupDefn);
            if (list == null) {
                return false;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                XSDElement xSDElement = (XSDElement)iterator.next();
                BeanProperty beanProperty = this.elementToProperty(xSDElement, beanDescriptor.getXmlName(), xSDSchema);
                SchemaInspector.addPropertyToType(beanDescriptor, beanProperty);
            }
        } else {
            return false;
        }
        return true;
    }

    private static List getFlattenedContentModel(BeanDescriptor beanDescriptor, XSDModelGroup xSDModelGroup) throws XSDException {
        ModelGroupStatus.setCantHandle((boolean)false);
        List list = SchemaInspector.flattenContentModel(xSDModelGroup);
        beanDescriptor.setCompositor(Utils.getCompositor((XSDModelGroup)xSDModelGroup));
        if (ModelGroupStatus.getCantHandle()) {
            return null;
        }
        return list;
    }

    private static List flattenContentModel(XSDModelGroup xSDModelGroup) throws XSDException {
        Cloneable cloneable;
        List list = xSDModelGroup.getContentModel();
        if (list.size() == 1 && (cloneable = (XSDParticle)list.get(0)) instanceof XSDModelGroup && !SchemaInspector.isParticleMultiOccur(cloneable)) {
            return SchemaInspector.flattenContentModel((XSDModelGroup)cloneable);
        }
        cloneable = new ArrayList();
        Iterator iterator = list.iterator();
        block5: while (iterator.hasNext()) {
            XSDObject xSDObject = (XSDObject)iterator.next();
            switch (xSDObject.getTypeCode()) {
                case 2: {
                    XSDElement xSDElement = (XSDElement)xSDObject;
                    cloneable.add(xSDElement);
                    continue block5;
                }
                case 5: 
                case 15: {
                    XSDElement xSDElement = (XSDModelGroup)xSDObject;
                    if (SchemaInspector.isParticleMultiOccur(xSDElement)) {
                        return null;
                    }
                    Object object = SchemaInspector.flattenContentModel((XSDModelGroup)xSDElement);
                    cloneable.addAll(object);
                    continue block5;
                }
                case 6: {
                    Object object;
                    XSDElement xSDElement = (XSDModelGroupDefn)xSDObject;
                    if (SchemaInspector.isParticleMultiOccur(xSDElement)) {
                        return null;
                    }
                    if (xSDElement.getRef() != null) {
                        xSDElement = xSDElement.getRefObject();
                    }
                    if (SchemaInspector.isParticleMultiOccur((XSDParticle)(object = xSDElement.getContentModel()))) {
                        return null;
                    }
                    if (!(object instanceof XSDModelGroup)) {
                        return null;
                    }
                    XSDModelGroup xSDModelGroup2 = (XSDModelGroup)object;
                    List list2 = SchemaInspector.flattenContentModel(xSDModelGroup2);
                    if (list2 == null) {
                        return null;
                    }
                    cloneable.addAll(list2);
                    continue block5;
                }
            }
            ModelGroupStatus.setCantHandle((boolean)true);
            return cloneable;
        }
        return cloneable;
    }

    private void fixSoapArrayType(BeanDescriptor beanDescriptor, XSDComplexType xSDComplexType, XSDSchema xSDSchema) throws BindingException, XSDException {
        boolean bl = this.fixSequenceBasedSoapArray(beanDescriptor, xSDComplexType, xSDSchema);
        if (bl) {
            return;
        }
        SoapArrayDescriptor soapArrayDescriptor = SchemaInspector.getSoapArrayType(xSDComplexType);
        if (soapArrayDescriptor == null) {
            this.fillFallbackBeanDescriptor(beanDescriptor, beanDescriptor.getXmlName());
            return;
        }
        BeanDescriptor beanDescriptor2 = this.getDescriptors(soapArrayDescriptor.getArrayTypeName(), xSDSchema);
        String string = beanDescriptor2.getJavaName();
        int n = 1 + soapArrayDescriptor.getArraySizes().length;
        String string2 = ArrayUtils.getArrayClassName(string, n);
        beanDescriptor.setArray(true);
        beanDescriptor.setSoapArrayDimension(n);
        int[] nArray = soapArrayDescriptor.getArrayTypeRanks();
        BeanDescriptor[] beanDescriptorArray = new BeanDescriptor[2 + nArray.length];
        beanDescriptorArray[0] = beanDescriptor2;
        beanDescriptorArray[beanDescriptorArray.length - 1] = beanDescriptor;
        int n2 = n;
        for (int i = 0; i < nArray.length; ++i) {
            BeanDescriptor beanDescriptor3;
            int n3 = i + 1;
            beanDescriptorArray[n3] = beanDescriptor3 = new BeanDescriptor();
            String string3 = ArrayUtils.getArrayClassName(string, n2);
            ExpName expName = new ExpName(beanDescriptor.getXmlName());
            expName.setLocalName(Utils.getArrayName((String)beanDescriptor2.getXmlName().getLocalName(), (int)n2));
            beanDescriptor3.setXmlName((XMLName)expName);
            beanDescriptor3.setJavaName(string3);
            beanDescriptor3.setImplName(string3);
            beanDescriptor3.setArray(true);
            beanDescriptor3.setSoapArrayDimension(nArray[i]);
            BeanProperty beanProperty = new BeanProperty();
            beanProperty.setName("array_base_not_used");
            beanProperty.setXmlName((XMLName)new ExpName("not used", "not used"));
            beanProperty.setMaxOccurs(Long.MAX_VALUE);
            beanProperty.setType(beanDescriptorArray[n3 - 1]);
            beanDescriptor3.addProperty(beanProperty);
            BeanDescriptor beanDescriptor4 = this.beans.get(beanDescriptor3.getXmlName());
            if (beanDescriptor4 != null && !beanDescriptor4.getJavaName().equals(beanDescriptor3.getJavaName())) {
                throw new BindingException("Array type name collision resolving multi-dimensional arrays for type " + beanDescriptor.getXmlName());
            }
            n2 += nArray[i];
        }
        String string4 = ArrayUtils.getArrayClassName(string, n2);
        beanDescriptor.setJavaName(string4);
        beanDescriptor.setImplName(string4);
        beanDescriptor.setSimpleContent(false);
        BeanProperty beanProperty = new BeanProperty();
        beanProperty.setMaxOccurs(Long.MAX_VALUE);
        beanProperty.setType(beanDescriptorArray[beanDescriptorArray.length - 2]);
        beanProperty.setXmlName(beanProperty.getType().getXmlName());
        beanProperty.setName("array_base");
        SchemaInspector.addPropertyToType(beanDescriptor, beanProperty);
    }

    private String getArrayExtension(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + n * "Array".length());
        stringBuffer.append(string);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("Array");
        }
        return stringBuffer.toString();
    }

    private boolean fixSequenceBasedSoapArray(BeanDescriptor beanDescriptor, XSDComplexType xSDComplexType, XSDSchema xSDSchema) throws BindingException, XSDException {
        XSDComplexContentRestriction xSDComplexContentRestriction;
        XSDParticle xSDParticle;
        XSDComplexContent xSDComplexContent = xSDComplexType.getComplexContent();
        if (xSDComplexContent != null && xSDComplexContent.isRestriction() && (xSDParticle = (xSDComplexContentRestriction = (XSDComplexContentRestriction)xSDComplexContent.getDerivation()).getContentModel()) instanceof XSDModelGroup) {
            XSDElement xSDElement;
            XSDParticle xSDParticle2;
            XSDModelGroup xSDModelGroup = (XSDModelGroup)xSDParticle;
            beanDescriptor.setCompositor(Utils.getCompositor((XSDModelGroup)xSDModelGroup));
            List list = xSDModelGroup.getContentModel();
            if (list.size() == 1 && (xSDParticle2 = (XSDParticle)list.get(0)) instanceof XSDElement && SchemaInspector.isParticleMultiOccur(xSDElement = (XSDElement)xSDParticle2)) {
                BeanDescriptor beanDescriptor2 = this.getDescriptors(xSDElement.getType(), xSDSchema);
                String string = beanDescriptor2.getJavaName();
                String string2 = ArrayUtils.getArrayClassName(string, 1);
                beanDescriptor.setJavaName(string2);
                beanDescriptor.setImplName(string2);
                beanDescriptor.setArray(true);
                beanDescriptor.setSoapArrayDimension(1);
                BeanProperty beanProperty = new BeanProperty();
                SchemaInspector.setMinMaxOccurs(beanProperty, xSDElement);
                beanProperty.setFormQualified(xSDElement.isFormQualifiedResolved());
                beanProperty.setType(beanDescriptor2);
                beanProperty.setName("component_type_unused");
                XMLName xMLName = ElementFactory.createXMLName(xSDElement.getTargetNamespace(), xSDElement.getName());
                beanProperty.setXmlName(xMLName);
                SchemaInspector.addPropertyToType(beanDescriptor, beanProperty);
                return true;
            }
        }
        return false;
    }

    private static SoapArrayDescriptor getSoapArrayType(XSDComplexType xSDComplexType) throws BindingException, XSDException {
        XSDComplexContentRestriction xSDComplexContentRestriction;
        XSDComplexContent xSDComplexContent = xSDComplexType.getComplexContent();
        if (xSDComplexContent != null && xSDComplexContent.isRestriction() && (xSDComplexContentRestriction = (XSDComplexContentRestriction)xSDComplexContent.getDerivation()) != null) {
            XSDAttribute[] xSDAttributeArray = xSDComplexContentRestriction.getAttributesExpanded();
            int n = xSDAttributeArray.length;
            for (int i = 0; i < n; ++i) {
                XSDAttribute xSDAttribute = xSDAttributeArray[i];
                AttributeIterator attributeIterator = xSDAttribute.getAnnotationAttributes();
                Debug.assertion(attributeIterator != null);
                while (attributeIterator.hasNext()) {
                    Attribute attribute = attributeIterator.next();
                    if (!SoapTypes.WsdlArrayType.equals(attribute.getName())) continue;
                    SoapArrayDescriptor soapArrayDescriptor = SoapArrayDescriptor.createFromXML(attribute.getValue());
                    XMLName xMLName = xSDAttribute.fillURIUsingParents(soapArrayDescriptor.getArrayTypeName());
                    soapArrayDescriptor.setArrayTypeName(xMLName);
                    return soapArrayDescriptor;
                }
            }
        }
        return null;
    }

    private void fixArrayTypes(BeanDescriptor beanDescriptor) throws BindingException {
        boolean bl = this.fixSequenceArrayTypes(beanDescriptor);
        if (!bl) {
            this.fixMultiOccurArrayTypes(beanDescriptor);
        }
    }

    private void fixMultiOccurArrayTypes(BeanDescriptor beanDescriptor) throws BindingException {
        Iterator iterator = beanDescriptor.getElementProperties();
        while (iterator.hasNext()) {
            BeanProperty beanProperty = (BeanProperty)iterator.next();
            if (!beanProperty.isMultiOccur()) continue;
            StringBuffer stringBuffer = new StringBuffer();
            int n = ArrayUtils.getArrayComponentName(stringBuffer, beanProperty.getType().getJavaName());
            String string = ArrayUtils.getArrayClassName(stringBuffer.toString(), n + 1);
            String string2 = beanDescriptor.getXmlName().getLocalName() + "__" + beanProperty.getName() + "__Array";
            String string3 = beanDescriptor.getXmlName().getNamespaceUri();
            XMLName xMLName = ElementFactory.createXMLName(string3, string2);
            xMLName = this.anonTypeNames.getAnonTypeName(xMLName);
            BeanDescriptor beanDescriptor2 = this.initBeanDescriptor(xMLName);
            beanDescriptor2.setMinOccurs(beanProperty.getType().getMinOccurs());
            beanDescriptor2.setMaxOccurs(beanProperty.getType().getMaxOccurs());
            beanDescriptor2.setCompleteType(false);
            beanDescriptor2.setSoapArrayDimension(0);
            beanDescriptor2.setArray(true);
            beanDescriptor2.setJavaName(string);
            beanDescriptor2.setImplName(string);
            beanDescriptor2.setPrimitive(false);
            BeanProperty beanProperty2 = (BeanProperty)beanProperty.clone();
            beanProperty2.setMinOccurs(1L);
            beanProperty2.setMaxOccurs(1L);
            SchemaInspector.addPropertyToType(beanDescriptor2, beanProperty2);
            beanProperty.setType(beanDescriptor2);
            this.beans.put(beanDescriptor2);
            Debug.assertion(beanDescriptor2.getElementCount() == 1, "desc=" + beanDescriptor2 + " count=" + beanDescriptor2.getElementCount());
        }
    }

    private boolean fixSequenceArrayTypes(BeanDescriptor beanDescriptor) {
        ArrayList<BeanDescriptor> arrayList = new ArrayList<BeanDescriptor>();
        BeanDescriptor beanDescriptor2 = beanDescriptor;
        BeanDescriptor beanDescriptor3 = this.getArrayType(beanDescriptor2);
        while (beanDescriptor3 != null) {
            arrayList.add(beanDescriptor2);
            beanDescriptor2 = beanDescriptor3;
            beanDescriptor3 = this.getArrayType(beanDescriptor2);
        }
        beanDescriptor3 = beanDescriptor2;
        if (beanDescriptor3 == beanDescriptor) {
            return false;
        }
        if (beanDescriptor3 == null) {
            return false;
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        String string = beanDescriptor3.getJavaName();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            int n2 = n - i;
            BeanDescriptor beanDescriptor4 = (BeanDescriptor)arrayList.get(i);
            String string2 = ArrayUtils.getArrayClassName(string, n2);
            beanDescriptor4.setJavaName(string2);
            beanDescriptor4.setImplName(string2);
            beanDescriptor4.setArray(true);
        }
        beanDescriptor.setSimpleContent(false);
        return true;
    }

    private BeanDescriptor getArrayType(BeanDescriptor beanDescriptor) {
        BeanProperty beanProperty;
        if (beanDescriptor.isSimpleContent()) {
            return null;
        }
        BeanDescriptor beanDescriptor2 = null;
        if (beanDescriptor.getAttributeCount() == 0 && beanDescriptor.getElementCount() == 1 && (beanProperty = (BeanProperty)beanDescriptor.getElementProperties().next()).isMultiOccur()) {
            BeanDescriptor beanDescriptor3;
            beanDescriptor2 = beanDescriptor3 = beanProperty.getType();
        }
        return beanDescriptor2;
    }

    private static void setMinMaxOccurs(BeanDescriptor beanDescriptor, XSDElement xSDElement) {
        BigInteger bigInteger = xSDElement.getMinOccurs();
        if (bigInteger != null) {
            beanDescriptor.setMinOccurs(bigInteger.longValue());
        }
        if (xSDElement.isMaxUnbounded()) {
            beanDescriptor.setMaxOccurs(-1L);
        } else {
            BigInteger bigInteger2 = xSDElement.getMaxOccurs();
            if (bigInteger2 != null) {
                beanDescriptor.setMaxOccurs(bigInteger2.longValue());
            }
        }
    }

    private static void setMinMaxOccurs(BeanProperty beanProperty, XSDElement xSDElement) {
        BigInteger bigInteger = xSDElement.getMinOccurs();
        if (bigInteger != null) {
            beanProperty.setMinOccurs(bigInteger.longValue());
        }
        if (xSDElement.isMaxUnbounded()) {
            beanProperty.setMaxOccurs(Long.MAX_VALUE);
        } else {
            BigInteger bigInteger2 = xSDElement.getMaxOccurs();
            if (bigInteger2 != null) {
                beanProperty.setMaxOccurs(bigInteger2.longValue());
            }
        }
    }

    private static boolean isParticleMultiOccur(XSDParticle xSDParticle) {
        if (xSDParticle.isMaxUnbounded()) {
            return true;
        }
        BigInteger bigInteger = xSDParticle.getMinOccurs();
        if (bigInteger != null && bigInteger.compareTo(BigInteger.ONE) > 0) {
            return true;
        }
        BigInteger bigInteger2 = xSDParticle.getMaxOccurs();
        return bigInteger2 != null && bigInteger2.compareTo(BigInteger.ONE) > 0;
    }

    private BeanDescriptor initBeanDescriptor(XMLName xMLName) {
        BeanDescriptor beanDescriptor = new BeanDescriptor();
        beanDescriptor.setXmlName(xMLName);
        String string = NameUtil.getClassNameFromXMLName(xMLName);
        String string2 = NameUtil.getPackageNameFromClass(string);
        String string3 = NameUtil.getRootClassNameFromClass(string);
        string2 = Utils.configurePackageName((String)string2, (BindingConfiguration)this.conf);
        string = Utils.concatPackage((String)string2, (String)string3);
        Object object = this.beans.getFromJavaType(string);
        while (object != null) {
            string3 = '_' + string3;
            Debug.assertion(NameUtil.isValidJavaIdentifer(string3), "BAD CLASS: " + string3);
            string = Utils.concatPackage((String)string2, (String)string3);
            object = this.beans.getFromJavaType(string);
        }
        beanDescriptor.setJavaName(string);
        beanDescriptor.setGeneratedFilenameBase(string3);
        object = beanDescriptor.getJavaName();
        if (this.conf.isSeparateBeanInterfaces()) {
            object = (String)object + this.conf.getBeanImplExtension();
        }
        beanDescriptor.setImplName((String)object);
        return beanDescriptor;
    }

    private String getExpectedClassNameFromXMLName(XMLName xMLName, boolean bl) {
        Class clazz = (Class)builtinDefaultsMap.get(xMLName);
        if (clazz == null) {
            clazz = this.mapping.getClassFromXMLName(xMLName);
        }
        if (clazz != null) {
            if (bl && clazz.isPrimitive()) {
                Class clazz2 = (Class)primitiveWrapperMap.get(clazz.getName());
                Debug.assertion(clazz2 != null, "unknown primitive: " + clazz);
                clazz = clazz2;
            }
            return clazz.getName();
        }
        String string = xMLName.getNamespaceUri();
        String string2 = string == null ? null : NameUtil.getPackageName(string);
        String string3 = NameUtil.getClassName(xMLName.getLocalName());
        String string4 = Utils.concatPackage((String)string2, (String)string3);
        return string4;
    }

    private BeanProperty attributeToProperty(XSDAttribute xSDAttribute, XMLName xMLName, XSDSchema xSDSchema) throws BindingException, XSDException {
        XSDAttribute xSDAttribute2 = xSDAttribute.getRef() != null ? xSDAttribute.getRefObject() : xSDAttribute;
        XMLName xMLName2 = xSDAttribute2.getXMLName();
        XSDAnyType xSDAnyType = xSDAttribute2.getTypeObject();
        XMLName xMLName3 = xSDAnyType.getXMLName();
        XSDSchema xSDSchema2 = xSDAnyType.getContainingSchema();
        BeanDescriptor beanDescriptor = null;
        beanDescriptor = xMLName3.getLocalName() == null ? this.createAnonymousType(xSDAnyType, xMLName2, xSDSchema2) : this.getDescriptors(xMLName3, xSDSchema2);
        BeanProperty beanProperty = this.getProp(xMLName2, beanDescriptor);
        beanProperty.setFormQualified(xSDAttribute2.isFormQualifiedResolved());
        beanProperty.setXmlAttribute(true);
        if (xSDAttribute2.hasDefault()) {
            beanProperty.setDefault(true);
            beanProperty.setValueConstraintValue(xSDAttribute2.getValueConstraintValue());
        } else if (xSDAttribute2.isFixed()) {
            beanProperty.setFixed(true);
            beanProperty.setValueConstraintValue(xSDAttribute2.getValueConstraintValue());
        }
        return beanProperty;
    }

    private BeanDescriptor createAnonymousType(XSDAnyType xSDAnyType, XMLName xMLName, XSDSchema xSDSchema) throws BindingException, XSDException {
        BeanDescriptor beanDescriptor;
        Debug.assertion(xSDAnyType != null);
        XMLName xMLName2 = (XMLName)this.anonTypeMap.get(xSDAnyType);
        if (xMLName2 == null) {
            xMLName2 = this.anonTypeNames.getAnonTypeName(xMLName);
            this.anonTypeMap.put(xSDAnyType, xMLName2);
        }
        if ((beanDescriptor = this.beans.get(xMLName2)) != null) {
            return beanDescriptor;
        }
        beanDescriptor = this.createAddAndFillBeanDescriptor(xMLName2, xSDAnyType, xSDSchema);
        beanDescriptor.setAnonymousType(true);
        return beanDescriptor;
    }

    private BeanProperty elementToProperty(XSDElement xSDElement, XMLName xMLName, XSDSchema xSDSchema) throws BindingException, XSDException {
        XSDAnyType xSDAnyType;
        BeanDescriptor beanDescriptor;
        XSDElement xSDElement2 = xSDElement.getRef() != null ? xSDElement.getRefObject() : xSDElement;
        XMLName xMLName2 = xSDElement2.getXMLName();
        Debug.assertion(xMLName2 != null);
        Debug.assertion(xMLName2.getLocalName() != null);
        XSDAnyType xSDAnyType2 = xSDElement2.getTypeObject();
        Debug.assertion(xSDAnyType2 != null, "null type obj for " + xSDElement + " named " + xMLName);
        XSDSchema xSDSchema2 = xSDAnyType2.getContainingSchema();
        XMLName xMLName3 = xSDAnyType2.getXMLName();
        if (xMLName3 == null || xMLName3.getLocalName() == null) {
            if (xSDSchema.lookupElement(xMLName2) != null) {
                beanDescriptor = this.getDescriptors(xMLName2, xSDSchema2, xSDElement.isNillableDefaulted());
            } else {
                xSDAnyType = xSDElement2.getAnonymousType();
                beanDescriptor = this.createAnonymousType(xSDAnyType, xMLName2, xSDSchema2);
            }
        } else {
            beanDescriptor = this.getDescriptors(xMLName3, xSDSchema2, xSDElement.isNillableDefaulted());
        }
        xSDAnyType = this.getProp(xMLName2, beanDescriptor);
        boolean bl = SchemaInspector.isParticleMultiOccur(xSDElement);
        if (bl) {
            SchemaInspector.setMinMaxOccurs(beanDescriptor, xSDElement);
        }
        SchemaInspector.setMinMaxOccurs((BeanProperty)xSDAnyType, xSDElement);
        xSDAnyType.setFormQualified(xSDElement2.isFormQualifiedResolved());
        xSDAnyType.setXmlAttribute(false);
        return xSDAnyType;
    }

    private static XSDAnyType getType(XMLName xMLName, XSDSchema xSDSchema) throws BindingException, XSDException {
        Debug.assertion(xMLName != null);
        XSDAnyType xSDAnyType = xSDSchema.lookupType(xMLName);
        if (xSDAnyType == null) {
            XSDElement xSDElement = xSDSchema.lookupElement(xMLName);
            if (xSDElement == null) {
                throw new BindingException("unable to find definition for " + xMLName);
            }
            xSDAnyType = xSDElement.getTypeObject();
        }
        if (xSDAnyType == null) {
            throw new BindingException("unable to find definition for " + xMLName);
        }
        return xSDAnyType;
    }

    private BeanProperty getProp(XMLName xMLName, BeanDescriptor beanDescriptor) {
        Debug.assertion(beanDescriptor != null);
        BeanProperty beanProperty = new BeanProperty();
        beanProperty.setType(beanDescriptor);
        beanProperty.setName(NameUtil.getPropertyName(xMLName.getLocalName()));
        beanProperty.setXmlName(xMLName);
        SchemaInspector.fillSetterAndGetter(beanProperty);
        if (this.conf.isGeneratePublicFields()) {
            beanProperty.setField(true);
        }
        return beanProperty;
    }

    private static void fillSetterAndGetter(BeanProperty beanProperty) {
        String string = NameUtil.upcaseFirstLetter(beanProperty.getName());
        beanProperty.setSetter("set" + string);
        beanProperty.setGetter("get" + string);
    }

    private XMLName fillUri(XMLName xMLName) {
        if (xMLName.getNamespaceUri() != null) {
            return xMLName;
        }
        ExpName expName = new ExpName(this.currentTargetNamespace, xMLName.getLocalName());
        return expName;
    }

    private boolean hasDerivedTypes(BeanDescriptor beanDescriptor) {
        Iterator iterator = DescriptorMap.access$200((DescriptorMap)this.beans);
        while (iterator.hasNext()) {
            BeanDescriptor beanDescriptor2 = (BeanDescriptor)iterator.next();
            if (beanDescriptor != beanDescriptor2.getSuperType()) continue;
            return true;
        }
        return false;
    }

    private static void addPropertyToType(BeanDescriptor beanDescriptor, BeanProperty beanProperty) throws BindingException {
        String string;
        boolean bl = false;
        BeanProperty beanProperty2 = beanDescriptor.checkJavaNameConflicts(beanProperty);
        while (beanProperty2 != null) {
            string = '_' + beanProperty.getName();
            beanProperty.setName(string);
            bl = true;
            beanProperty2 = beanDescriptor.checkJavaNameConflicts(beanProperty);
        }
        if (bl) {
            SchemaInspector.fillSetterAndGetter(beanProperty);
        }
        if ((beanProperty2 = beanDescriptor.getSuperType()) != null && (string = beanProperty2.checkJavaNameConflicts(beanProperty)) != null) {
            Debug.assertion(string.getName().equals(beanProperty.getName()));
            return;
        }
        beanDescriptor.addProperty(beanProperty);
    }

    private BeanProperty getSimpleContentPropertyTemplate() {
        BeanProperty beanProperty = new BeanProperty();
        beanProperty.setSimpleContent(true);
        beanProperty.setName("simpleContent");
        beanProperty.setXmlAttribute(false);
        beanProperty.setXmlName(ElementFactory.createXMLName("simpleContent"));
        SchemaInspector.fillSetterAndGetter(beanProperty);
        return beanProperty;
    }

    private static Map createBuiltinDefaultsMap() {
        HashMap<XMLName, Class> hashMap = new HashMap<XMLName, Class>();
        hashMap.put(SchemaTypes.XSD_ANY_TYPE_ENAME, class$java$lang$Object == null ? (class$java$lang$Object = SchemaInspector.class$("java.lang.Object")) : class$java$lang$Object);
        hashMap.put(SchemaTypes.XSD_ANY_SIMPLE_TYPE_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SchemaTypes.XSD_BOOLEAN_ENAME, Boolean.TYPE);
        hashMap.put(SchemaTypes.XSD_BYTE_ENAME, Byte.TYPE);
        hashMap.put(SchemaTypes.XSD_SHORT_ENAME, Short.TYPE);
        hashMap.put(SchemaTypes.XSD_INT_ENAME, Integer.TYPE);
        hashMap.put(SchemaTypes.XSD_LONG_ENAME, Long.TYPE);
        hashMap.put(SchemaTypes.XSD_FLOAT_ENAME, Float.TYPE);
        hashMap.put(SchemaTypes.XSD_DOUBLE_ENAME, Double.TYPE);
        hashMap.put(SchemaTypes.XSD_INTEGER_ENAME, class$java$math$BigInteger == null ? (class$java$math$BigInteger = SchemaInspector.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        try {
            hashMap.put(SchemaTypes.XSD_DECIMAL_ENAME, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SchemaInspector.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        }
        catch (Throwable throwable) {
            hashMap.put(SchemaTypes.XSD_DECIMAL_ENAME, Double.TYPE);
        }
        hashMap.put(SchemaTypes.XSD_STRING_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SchemaTypes.XSD_DATETIME_ENAME, class$java$util$Calendar == null ? (class$java$util$Calendar = SchemaInspector.class$("java.util.Calendar")) : class$java$util$Calendar);
        hashMap.put(SchemaTypes.XSD_DATE_ENAME, class$java$util$Calendar == null ? (class$java$util$Calendar = SchemaInspector.class$("java.util.Calendar")) : class$java$util$Calendar);
        hashMap.put(SchemaTypes.XSD_GDAY_ENAME, class$java$util$Calendar == null ? (class$java$util$Calendar = SchemaInspector.class$("java.util.Calendar")) : class$java$util$Calendar);
        hashMap.put(SchemaTypes.XSD_GMONTHDAY_ENAME, class$java$util$Calendar == null ? (class$java$util$Calendar = SchemaInspector.class$("java.util.Calendar")) : class$java$util$Calendar);
        hashMap.put(SchemaTypes.XSD_GMONTH_ENAME, class$java$util$Calendar == null ? (class$java$util$Calendar = SchemaInspector.class$("java.util.Calendar")) : class$java$util$Calendar);
        hashMap.put(SchemaTypes.XSD_GYEARMONTH_ENAME, class$java$util$Calendar == null ? (class$java$util$Calendar = SchemaInspector.class$("java.util.Calendar")) : class$java$util$Calendar);
        hashMap.put(SchemaTypes.XSD_GYEAR_ENAME, class$java$util$Calendar == null ? (class$java$util$Calendar = SchemaInspector.class$("java.util.Calendar")) : class$java$util$Calendar);
        hashMap.put(SchemaTypes.XSD_TIME_ENAME, class$java$util$Calendar == null ? (class$java$util$Calendar = SchemaInspector.class$("java.util.Calendar")) : class$java$util$Calendar);
        hashMap.put(SchemaTypes.XSD_BASE64BINARY_ENAME, array$B == null ? (array$B = SchemaInspector.class$("[B")) : array$B);
        hashMap.put(SchemaTypes.XSD_HEXBINARY_ENAME, array$B == null ? (array$B = SchemaInspector.class$("[B")) : array$B);
        hashMap.put(SchemaTypes.XSD_QNAME_ENAME, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = SchemaInspector.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
        hashMap.put(SchemaTypes.XSD_DURATION_ENAME, class$weblogic$xml$schema$types$Duration == null ? (class$weblogic$xml$schema$types$Duration = SchemaInspector.class$("weblogic.xml.schema.types.Duration")) : class$weblogic$xml$schema$types$Duration);
        hashMap.put(SchemaTypes.XSD_NOTATION_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SchemaTypes.XSD_ANYURI_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SchemaTypes.XSD_NORMALIZED_STRING_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SchemaTypes.XSD_TOKEN_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SchemaTypes.XSD_LANGUAGE_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SchemaTypes.XSD_NAME_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SchemaTypes.XSD_NCNAME_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SchemaTypes.XSD_NMTOKEN_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SchemaTypes.XSD_ID_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SchemaTypes.XSD_IDREF_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SchemaTypes.XSD_ENTITY_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SchemaTypes.XSD_NMTOKENS_ENAME, array$Ljava$lang$String == null ? (array$Ljava$lang$String = SchemaInspector.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        hashMap.put(SchemaTypes.XSD_IDREFS_ENAME, array$Ljava$lang$String == null ? (array$Ljava$lang$String = SchemaInspector.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        hashMap.put(SchemaTypes.XSD_ENTITIES_ENAME, array$Ljava$lang$String == null ? (array$Ljava$lang$String = SchemaInspector.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        hashMap.put(SchemaTypes.XSD_UNSIGNEDBYTE_ENAME, Short.TYPE);
        hashMap.put(SchemaTypes.XSD_UNSIGNEDSHORT_ENAME, Integer.TYPE);
        hashMap.put(SchemaTypes.XSD_UNSIGNEDINT_ENAME, Long.TYPE);
        hashMap.put(SchemaTypes.XSD_UNSIGNEDLONG_ENAME, class$java$math$BigInteger == null ? (class$java$math$BigInteger = SchemaInspector.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        hashMap.put(SchemaTypes.XSD_NONNEGATIVEINTEGER_ENAME, class$java$math$BigInteger == null ? (class$java$math$BigInteger = SchemaInspector.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        hashMap.put(SchemaTypes.XSD_NONPOSITIVEINTEGER_ENAME, class$java$math$BigInteger == null ? (class$java$math$BigInteger = SchemaInspector.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        hashMap.put(SchemaTypes.XSD_NEGATIVEINTEGER_ENAME, class$java$math$BigInteger == null ? (class$java$math$BigInteger = SchemaInspector.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        hashMap.put(SchemaTypes.XSD_POSITIVEINTEGER_ENAME, class$java$math$BigInteger == null ? (class$java$math$BigInteger = SchemaInspector.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        hashMap.put(SoapTypes.Array, class$java$lang$Object == null ? (class$java$lang$Object = SchemaInspector.class$("java.lang.Object")) : class$java$lang$Object);
        hashMap.put(SoapTypes.SOAP_BOOLEAN_ENAME, class$java$lang$Boolean == null ? (class$java$lang$Boolean = SchemaInspector.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        hashMap.put(SoapTypes.SOAP_BASE64_ENAME, array$B == null ? (array$B = SchemaInspector.class$("[B")) : array$B);
        hashMap.put(SoapTypes.SOAP_BYTE_ENAME, class$java$lang$Byte == null ? (class$java$lang$Byte = SchemaInspector.class$("java.lang.Byte")) : class$java$lang$Byte);
        hashMap.put(SoapTypes.SOAP_SHORT_ENAME, class$java$lang$Short == null ? (class$java$lang$Short = SchemaInspector.class$("java.lang.Short")) : class$java$lang$Short);
        hashMap.put(SoapTypes.SOAP_INT_ENAME, class$java$lang$Integer == null ? (class$java$lang$Integer = SchemaInspector.class$("java.lang.Integer")) : class$java$lang$Integer);
        hashMap.put(SoapTypes.SOAP_LONG_ENAME, class$java$lang$Long == null ? (class$java$lang$Long = SchemaInspector.class$("java.lang.Long")) : class$java$lang$Long);
        hashMap.put(SoapTypes.SOAP_FLOAT_ENAME, class$java$lang$Float == null ? (class$java$lang$Float = SchemaInspector.class$("java.lang.Float")) : class$java$lang$Float);
        hashMap.put(SoapTypes.SOAP_DOUBLE_ENAME, class$java$lang$Double == null ? (class$java$lang$Double = SchemaInspector.class$("java.lang.Double")) : class$java$lang$Double);
        hashMap.put(SoapTypes.SOAP_INTEGER_ENAME, class$java$math$BigInteger == null ? (class$java$math$BigInteger = SchemaInspector.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        hashMap.put(SoapTypes.SOAP_DATETIME_ENAME, class$java$util$Calendar == null ? (class$java$util$Calendar = SchemaInspector.class$("java.util.Calendar")) : class$java$util$Calendar);
        hashMap.put(SoapTypes.SOAP_TIME_ENAME, class$java$util$Calendar == null ? (class$java$util$Calendar = SchemaInspector.class$("java.util.Calendar")) : class$java$util$Calendar);
        hashMap.put(SoapTypes.SOAP_DATE_ENAME, class$java$util$Calendar == null ? (class$java$util$Calendar = SchemaInspector.class$("java.util.Calendar")) : class$java$util$Calendar);
        hashMap.put(SoapTypes.SOAP_GYEARMONTH_ENAME, class$java$util$Calendar == null ? (class$java$util$Calendar = SchemaInspector.class$("java.util.Calendar")) : class$java$util$Calendar);
        hashMap.put(SoapTypes.SOAP_GMONTHDAY_ENAME, class$java$util$Calendar == null ? (class$java$util$Calendar = SchemaInspector.class$("java.util.Calendar")) : class$java$util$Calendar);
        hashMap.put(SoapTypes.SOAP_GMONTH_ENAME, class$java$util$Calendar == null ? (class$java$util$Calendar = SchemaInspector.class$("java.util.Calendar")) : class$java$util$Calendar);
        hashMap.put(SoapTypes.SOAP_GDAY_ENAME, class$java$util$Calendar == null ? (class$java$util$Calendar = SchemaInspector.class$("java.util.Calendar")) : class$java$util$Calendar);
        hashMap.put(SoapTypes.SOAP_DURATION_ENAME, class$weblogic$xml$schema$types$Duration == null ? (class$weblogic$xml$schema$types$Duration = SchemaInspector.class$("weblogic.xml.schema.types.Duration")) : class$weblogic$xml$schema$types$Duration);
        hashMap.put(SoapTypes.SOAP_NOTATION_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SoapTypes.SOAP_ANYURI_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SoapTypes.SOAP_UNSIGNEDBYTE_ENAME, class$java$lang$Short == null ? (class$java$lang$Short = SchemaInspector.class$("java.lang.Short")) : class$java$lang$Short);
        hashMap.put(SoapTypes.SOAP_UNSIGNEDSHORT_ENAME, class$java$lang$Integer == null ? (class$java$lang$Integer = SchemaInspector.class$("java.lang.Integer")) : class$java$lang$Integer);
        hashMap.put(SoapTypes.SOAP_UNSIGNEDINT_ENAME, class$java$lang$Long == null ? (class$java$lang$Long = SchemaInspector.class$("java.lang.Long")) : class$java$lang$Long);
        hashMap.put(SoapTypes.SOAP_UNSIGNEDLONG_ENAME, class$java$math$BigInteger == null ? (class$java$math$BigInteger = SchemaInspector.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        hashMap.put(SoapTypes.SOAP_NONNEGATIVEINTEGER_ENAME, class$java$math$BigInteger == null ? (class$java$math$BigInteger = SchemaInspector.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        hashMap.put(SoapTypes.SOAP_NONPOSITIVEINTEGER_ENAME, class$java$math$BigInteger == null ? (class$java$math$BigInteger = SchemaInspector.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        hashMap.put(SoapTypes.SOAP_NEGATIVEINTEGER_ENAME, class$java$math$BigInteger == null ? (class$java$math$BigInteger = SchemaInspector.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        hashMap.put(SoapTypes.SOAP_POSITIVEINTEGER_ENAME, class$java$math$BigInteger == null ? (class$java$math$BigInteger = SchemaInspector.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        hashMap.put(SoapTypes.SOAP_NORMALIZED_STRING_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SoapTypes.SOAP_TOKEN_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SoapTypes.SOAP_LANGUAGE_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SoapTypes.SOAP_NAME_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SoapTypes.SOAP_NCNAME_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SoapTypes.SOAP_NMTOKEN_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SoapTypes.SOAP_ID_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SoapTypes.SOAP_IDREF_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SoapTypes.SOAP_ENTITY_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SoapTypes.SOAP_NMTOKENS_ENAME, array$Ljava$lang$String == null ? (array$Ljava$lang$String = SchemaInspector.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        hashMap.put(SoapTypes.SOAP_IDREFS_ENAME, array$Ljava$lang$String == null ? (array$Ljava$lang$String = SchemaInspector.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        hashMap.put(SoapTypes.SOAP_ENTITIES_ENAME, array$Ljava$lang$String == null ? (array$Ljava$lang$String = SchemaInspector.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        try {
            hashMap.put(SoapTypes.SOAP_DECIMAL_ENAME, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SchemaInspector.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        }
        catch (Throwable throwable) {
            hashMap.put(SoapTypes.SOAP_DECIMAL_ENAME, class$java$lang$Double == null ? (class$java$lang$Double = SchemaInspector.class$("java.lang.Double")) : class$java$lang$Double);
        }
        hashMap.put(SoapTypes.SOAP_STRING_ENAME, class$java$lang$String == null ? (class$java$lang$String = SchemaInspector.class$("java.lang.String")) : class$java$lang$String);
        hashMap.put(SoapTypes.SOAP_QNAME_ENAME, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = SchemaInspector.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
        return Collections.unmodifiableMap(hashMap);
    }

    private static Map createPrimitiveWrapperMap() {
        HashMap<String, Class> hashMap = new HashMap<String, Class>();
        hashMap.put(Boolean.TYPE.getName(), class$java$lang$Boolean == null ? (class$java$lang$Boolean = SchemaInspector.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        hashMap.put(Byte.TYPE.getName(), class$java$lang$Byte == null ? (class$java$lang$Byte = SchemaInspector.class$("java.lang.Byte")) : class$java$lang$Byte);
        hashMap.put(Short.TYPE.getName(), class$java$lang$Short == null ? (class$java$lang$Short = SchemaInspector.class$("java.lang.Short")) : class$java$lang$Short);
        hashMap.put(Integer.TYPE.getName(), class$java$lang$Integer == null ? (class$java$lang$Integer = SchemaInspector.class$("java.lang.Integer")) : class$java$lang$Integer);
        hashMap.put(Long.TYPE.getName(), class$java$lang$Long == null ? (class$java$lang$Long = SchemaInspector.class$("java.lang.Long")) : class$java$lang$Long);
        hashMap.put(Float.TYPE.getName(), class$java$lang$Float == null ? (class$java$lang$Float = SchemaInspector.class$("java.lang.Float")) : class$java$lang$Float);
        hashMap.put(Double.TYPE.getName(), class$java$lang$Double == null ? (class$java$lang$Double = SchemaInspector.class$("java.lang.Double")) : class$java$lang$Double);
        hashMap.put(Character.TYPE.getName(), class$java$lang$Character == null ? (class$java$lang$Character = SchemaInspector.class$("java.lang.Character")) : class$java$lang$Character);
        return Collections.unmodifiableMap(hashMap);
    }

    private static Set createPrimitiveSet() {
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.addAll(primitiveWrapperMap.keySet());
        Iterator iterator = primitiveWrapperMap.values().iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            hashSet.add(clazz.getName());
        }
        int n = hashSet.size();
        Debug.assertion(n > 0, "createPrimitiveSet has empty set");
        Debug.assertion(n == 2 * primitiveWrapperMap.size(), "createPrimitiveSet has wrong size: " + n);
        return hashSet;
    }

    private static Collection getAllIncludedSchemas(SchemaMap schemaMap) {
        IdentityHashMap<XSDSchema, XSDSchema> identityHashMap = new IdentityHashMap<XSDSchema, XSDSchema>();
        Object object = schemaMap.iterator();
        while (object.hasNext()) {
            XSDSchema xSDSchema = (XSDSchema)object.next();
            identityHashMap.put(xSDSchema, xSDSchema);
            SchemaInspector.addAllIncludedSchemas(xSDSchema, identityHashMap);
        }
        object = identityHashMap.values();
        return object;
    }

    private static void addAllIncludedSchemas(XSDSchema xSDSchema, IdentityHashMap identityHashMap) {
        Iterator iterator = SchemaInspector.getIncludedSchemas(xSDSchema).iterator();
        while (iterator.hasNext()) {
            XSDSchema xSDSchema2 = (XSDSchema)iterator.next();
            if (identityHashMap.containsKey(xSDSchema2)) continue;
            identityHashMap.put(xSDSchema2, xSDSchema2);
            SchemaInspector.addAllIncludedSchemas(xSDSchema2, identityHashMap);
        }
    }

    private static Collection getIncludedSchemas(XSDSchema xSDSchema) {
        Map map = xSDSchema.getIncludedSchemasMap();
        return map.values();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

