/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.internal.builtin;

import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import weblogic.xml.schema.binding.DeserializationContext;
import weblogic.xml.schema.binding.DeserializationException;
import weblogic.xml.schema.binding.internal.builtin.DocumentCodec;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLOutputStreamFactory;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.util.XMLSubStreamBase;

public class DocumentFragmentCodec
extends DocumentCodec {
    public Object deserialize(XMLName xMLName, XMLInputStream xMLInputStream, DeserializationContext deserializationContext) throws DeserializationException {
        DocumentFragment documentFragment;
        try {
            Document document = this.getDocument();
            documentFragment = document.createDocumentFragment();
            XMLOutputStream xMLOutputStream = XMLOutputStreamFactory.newInstance().newOutputStream(document, documentFragment);
            xMLInputStream.skip(2);
            this.process(xMLName, (XMLInputStream)new XMLSubStreamBase(xMLInputStream), xMLOutputStream);
            xMLInputStream.skip(4);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DeserializationException("Failed to deserialize DocumentFragment.");
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DeserializationException("Failed to deserialize DocumentFragment.");
        }
        return documentFragment;
    }

    protected void process(XMLName xMLName, XMLInputStream xMLInputStream, XMLOutputStream xMLOutputStream) throws XMLStreamException, ParserConfigurationException {
        XMLName xMLName2 = xMLName;
        int n = 0;
        while (xMLInputStream.hasNext()) {
            XMLEvent xMLEvent = xMLInputStream.next();
            XMLName xMLName3 = xMLEvent.getName();
            if ((xMLEvent.isStartElement() || xMLEvent.isEndElement()) && xMLName3.getLocalName().equals(xMLName2.getLocalName())) {
                String string = xMLName2.getNamespaceUri();
                String string2 = xMLName3.getNamespaceUri();
                if ((string != null || string2 != null) && (string == null || !string.equals(string2))) continue;
                if (xMLEvent.isStartElement()) {
                    ++n;
                    continue;
                }
                if (n == 1) break;
                --n;
                continue;
            }
            xMLOutputStream.add(xMLEvent);
        }
        xMLOutputStream.flush();
    }
}

