/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import weblogic.utils.Debug;
import weblogic.xml.schema.binding.ClassContext;
import weblogic.xml.schema.binding.ClassLoadingUtils;
import weblogic.xml.schema.binding.CodecBase;
import weblogic.xml.schema.binding.Deserializer;
import weblogic.xml.schema.binding.RuntimeUtils;
import weblogic.xml.schema.binding.SchemaContext;
import weblogic.xml.schema.binding.Serializer;
import weblogic.xml.schema.binding.TypeMapping;
import weblogic.xml.schema.binding.TypeMappingEntry;
import weblogic.xml.schema.binding.internal.NameUtil;
import weblogic.xml.schema.binding.internal.SoapTypes;
import weblogic.xml.schema.binding.internal.StreamDeserializerFactory;
import weblogic.xml.schema.binding.internal.StreamSerializerFactory;
import weblogic.xml.schema.binding.internal.TypeMappingEntryImpl;
import weblogic.xml.schema.binding.internal.TypedClassContext;
import weblogic.xml.schema.binding.internal.TypedSchemaContext;
import weblogic.xml.schema.binding.internal.codegen.ArrayUtils;
import weblogic.xml.schema.model.ExpName;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.ElementFilter;
import weblogic.xml.stream.Location;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLOutputStreamFactory;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.util.TypeFilter;

public class TypeMappingBase
implements TypeMapping,
javax.xml.rpc.encoding.TypeMapping {
    private TypeMapping parent = null;
    private Set entries = new HashSet();
    private Map classIndex = new HashMap();
    private Map schemaIndex = new HashMap();
    private static final String[] default_supported_ns = new String[]{"stream"};
    private String[] supported_namespaces = default_supported_ns;
    private static final Map presetHolders = TypeMappingBase.buildPresetHolders();
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE = false;
    private Map xmlToClassMap = new HashMap();
    private Map classToXmlMap = new HashMap();
    private static final Map primMap = new HashMap();
    private static final String DD_PREFIX = "wsdd";
    private static final String XSD_PREFIX = "xsd";
    private static final String SOAPENC_PREFIX = "soapenc";
    private static final String DD_NS = "http://www.bea.com/servers/wls70";
    private static final XMLName REGISTRY_ELEM_NAME;
    private static final XMLName ENTRY_ELEM_NAME;
    private static final XMLName REGISTRY_ELEM_LOCALNAME;
    private static final XMLName ENTRY_ELEM_LOCALNAME;
    private static final XMLName CLASS_ATT_NAME;
    private static final XMLName TYPE_ATT_NAME;
    private static final XMLName ELEMENT_ATT_NAME;
    private static final XMLName SERIALIZER_ATT_NAME;
    private static final XMLName DESERIALIZER_ATT_NAME;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;
    static /* synthetic */ Class class$javax$xml$rpc$holders$BooleanHolder;
    static /* synthetic */ Class class$javax$xml$rpc$holders$ByteHolder;
    static /* synthetic */ Class class$javax$xml$rpc$holders$ShortHolder;
    static /* synthetic */ Class class$javax$xml$rpc$holders$IntHolder;
    static /* synthetic */ Class class$javax$xml$rpc$holders$LongHolder;
    static /* synthetic */ Class class$javax$xml$rpc$holders$FloatHolder;
    static /* synthetic */ Class class$javax$xml$rpc$holders$DoubleHolder;
    static /* synthetic */ Class class$weblogic$xml$schema$binding$util$runtime$CharHolder;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$xml$rpc$holders$StringHolder;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$javax$xml$rpc$holders$BigDecimalHolder;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$javax$xml$rpc$holders$BigIntegerHolder;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$javax$xml$rpc$holders$ByteArrayHolder;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$javax$xml$rpc$holders$CalendarHolder;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$javax$xml$rpc$holders$QNameHolder;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$javax$xml$rpc$holders$FloatWrapperHolder;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$javax$xml$rpc$holders$DoubleWrapperHolder;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$javax$xml$rpc$holders$LongWrapperHolder;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$javax$xml$rpc$holders$IntegerWrapperHolder;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$javax$xml$rpc$holders$ShortWrapperHolder;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$javax$xml$rpc$holders$ByteWrapperHolder;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$javax$xml$rpc$holders$BooleanWrapperHolder;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$weblogic$xml$schema$binding$util$runtime$CharWrapperHolder;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$weblogic$xml$schema$binding$util$runtime$DateObjectHolder;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$weblogic$xml$schema$binding$util$runtime$ObjectHolder;
    static /* synthetic */ Class class$javax$xml$soap$SOAPElement;
    static /* synthetic */ Class class$weblogic$xml$schema$binding$util$runtime$SOAPElementHolder;

    public Class getClassFromXMLName(XMLName xMLName) {
        Class clazz = (Class)this.xmlToClassMap.get(xMLName);
        if (clazz != null) {
            return clazz;
        }
        if (this.parent != null) {
            return this.parent.getClassFromXMLName(xMLName);
        }
        return null;
    }

    public Class getClassFromXMLType(QName qName) {
        XMLName xMLName = TypeMappingBase.createXMLNameFromXMLType(qName);
        return this.getClassFromXMLName(xMLName);
    }

    public XMLName getXMLNameFromClass(Class clazz) {
        XMLName xMLName = (XMLName)this.classToXmlMap.get(clazz.getName());
        if (xMLName != null) {
            return xMLName;
        }
        if (this.parent != null) {
            return this.parent.getXMLNameFromClass(clazz);
        }
        return null;
    }

    public Class getHolderClass(Class clazz, QName qName) throws IOException {
        String string;
        Class clazz2 = (Class)presetHolders.get(clazz.getName());
        if (clazz2 != null) {
            return clazz2;
        }
        String string2 = null;
        if (clazz.isArray()) {
            string = NameUtil.getClassName(qName.getLocalPart());
            string2 = NameUtil.getPackageFromNamespace(qName.getNamespaceURI());
        } else {
            string = NameUtil.getRootClassNameFromClass(clazz.getName());
            string2 = NameUtil.getPackageNameFromClass(clazz);
        }
        string = NameUtil.getHolderClass(string);
        string2 = NameUtil.getHolderPackage(string2);
        String string3 = NameUtil.concatPackage(string2, string);
        clazz2 = this.loadClass(string3);
        Debug.assertion(clazz2 != null, "clazz=" + clazz);
        Debug.assertion(TypeMappingBase.verifyHolderType(clazz2, clazz), "invalid holder " + clazz2 + " found for java type " + clazz + " and xml type " + qName);
        return clazz2;
    }

    private static boolean verifyHolderType(Class clazz, Class clazz2) {
        try {
            Field field = clazz.getField("value");
            int n = field.getModifiers();
            if (Modifier.isPublic(n) && !Modifier.isStatic(n) && !Modifier.isFinal(n)) {
                if (!field.getType().getName().equals(clazz2.getName())) {
                    return false;
                }
                return (class$javax$xml$rpc$holders$Holder == null ? (class$javax$xml$rpc$holders$Holder = TypeMappingBase.class$("javax.xml.rpc.holders.Holder")) : class$javax$xml$rpc$holders$Holder).isAssignableFrom(clazz);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return false;
    }

    public String[] getSupportedEncodings() {
        return this.supported_namespaces;
    }

    public void setSupportedEncodings(String[] stringArray) {
        this.supported_namespaces = stringArray;
    }

    public String[] getSupportedNamespaces() {
        throw new Error("removed from jax-rpc");
    }

    public void setSupportedNamespaces(String[] stringArray) {
        throw new Error("removed from jax-rpc");
    }

    private TypeMappingEntry get(Class clazz, QName qName) {
        if (clazz == null) {
            throw new IllegalArgumentException("javaType cannot be null");
        }
        if (qName == null) {
            throw new IllegalArgumentException("xmlType cannot be null");
        }
        XMLName xMLName = TypeMappingBase.createXMLNameFromXMLType(qName);
        TypedClassContext typedClassContext = new TypedClassContext(xMLName);
        return this.get(clazz, typedClassContext);
    }

    public boolean isRegistered(Class clazz, QName qName) {
        TypeMappingEntry typeMappingEntry = this.get(clazz, qName);
        return typeMappingEntry != null;
    }

    public void register(Class clazz, QName qName, SerializerFactory serializerFactory, DeserializerFactory deserializerFactory) throws JAXRPCException {
        if (clazz == null) {
            throw new IllegalArgumentException("javaType cannot be null");
        }
        if (qName == null) {
            throw new IllegalArgumentException("xmlType cannot be null");
        }
        if (serializerFactory == null) {
            throw new IllegalArgumentException("serializerfactory cannot be null");
        }
        if (deserializerFactory == null) {
            throw new IllegalArgumentException("deserializerfactory cannot be null");
        }
        XMLName xMLName = TypeMappingBase.createXMLNameFromXMLType(qName);
        boolean bl = this.add(clazz, xMLName, serializerFactory, deserializerFactory);
        if (!bl) {
            throw new JAXRPCException("this class is already registered");
        }
    }

    public SerializerFactory getSerializer(Class clazz, QName qName) throws JAXRPCException {
        if (clazz == null || qName == null) {
            return null;
        }
        TypeMappingEntry typeMappingEntry = this.get(clazz, qName);
        if (typeMappingEntry == null) {
            return null;
        }
        return typeMappingEntry.getSerializer();
    }

    public DeserializerFactory getDeserializer(Class clazz, QName qName) throws JAXRPCException {
        if (clazz == null || qName == null) {
            return null;
        }
        TypeMappingEntry typeMappingEntry = this.get(clazz, qName);
        if (typeMappingEntry == null) {
            return null;
        }
        return typeMappingEntry.getDeserializer();
    }

    protected TypeMappingEntry lookupEntry(Class clazz, QName qName) throws JAXRPCException {
        TypeMappingEntry typeMappingEntry = this.get(clazz, qName);
        if (typeMappingEntry == null) {
            String string = "Could not find type mapping entry for java type: " + clazz.getName() + " and xml type: " + qName;
            throw new JAXRPCException(string);
        }
        return typeMappingEntry;
    }

    public static XMLName createXMLNameFromXMLType(QName qName) {
        ExpName expName = new ExpName(qName.getNamespaceURI(), qName.getLocalPart());
        return expName;
    }

    public void removeSerializer(Class clazz, QName qName) throws JAXRPCException {
        TypeMappingEntry typeMappingEntry = this.get(clazz, qName);
        if (typeMappingEntry == null) {
            return;
        }
        this.remove(typeMappingEntry);
    }

    public void removeDeserializer(Class clazz, QName qName) throws JAXRPCException {
        TypeMappingEntry typeMappingEntry = this.get(clazz, qName);
        if (typeMappingEntry == null) {
            return;
        }
        this.remove(typeMappingEntry);
    }

    public boolean add(TypeMappingEntry typeMappingEntry) {
        if (!this.checkConstaints(typeMappingEntry)) {
            return false;
        }
        this.addToConstaints(typeMappingEntry);
        boolean bl = this.entries.add(typeMappingEntry);
        if (bl) {
            this.xmlToClassMap.put(typeMappingEntry.getSchemaType(), typeMappingEntry.getJavaType());
            this.classToXmlMap.put(typeMappingEntry.getJavaType().getName(), typeMappingEntry.getSchemaType());
        }
        return bl;
    }

    private void checkEntryConsistency(TypeMappingEntry typeMappingEntry) {
        DeserializerFactory deserializerFactory;
        XMLName xMLName = typeMappingEntry.getSchemaType();
        SerializerFactory serializerFactory = typeMappingEntry.getSerializer();
        if (serializerFactory instanceof CodecBase) {
            this.checkCodecConsistency(xMLName, (CodecBase)serializerFactory);
        }
        if ((deserializerFactory = typeMappingEntry.getDeserializer()) instanceof CodecBase) {
            this.checkCodecConsistency(xMLName, (CodecBase)serializerFactory);
        }
    }

    private void checkCodecConsistency(XMLName xMLName, CodecBase codecBase) {
        Debug.assertion(xMLName != null);
        if ("weblogic.xml.schema.binding.internal.builtin".equals(NameUtil.getPackageNameFromClass(codecBase.getClass().getName()))) {
            return;
        }
        XMLName xMLName2 = RuntimeUtils.getXmlType(codecBase);
        if (!xMLName.equals(xMLName2)) {
            String string = "mismatched typemapping entry found.  Registered for xml type " + xMLName + " yet codec reports type " + xMLName2 + ".  codec is " + codecBase;
            throw new IllegalArgumentException(string);
        }
    }

    public boolean add(Class clazz, XMLName xMLName, Serializer serializer, Deserializer deserializer) {
        Serializer serializer2 = serializer instanceof SerializerFactory ? serializer : new StreamSerializerFactory(serializer);
        Deserializer deserializer2 = deserializer instanceof DeserializerFactory ? deserializer : new StreamDeserializerFactory(deserializer);
        return this.add(clazz, xMLName, (SerializerFactory)serializer2, (DeserializerFactory)deserializer2);
    }

    public boolean add(Class clazz, XMLName xMLName, SerializerFactory serializerFactory, DeserializerFactory deserializerFactory) {
        TypeMappingEntryImpl typeMappingEntryImpl = new TypeMappingEntryImpl(clazz, new TypedClassContext(xMLName), xMLName, new TypedSchemaContext(clazz.getName()), serializerFactory, deserializerFactory);
        return this.add(typeMappingEntryImpl);
    }

    public void replace(TypeMappingEntry typeMappingEntry) {
        this.remove(typeMappingEntry);
        this.add(typeMappingEntry);
    }

    public void remove(TypeMappingEntry typeMappingEntry) {
        this.removeFromConstaints(typeMappingEntry);
        this.entries.remove(typeMappingEntry);
    }

    public TypeMappingEntry get(Class clazz, ClassContext classContext) {
        if (clazz == null) {
            throw new IllegalArgumentException("class cannot be null");
        }
        TypeMappingEntry typeMappingEntry = (TypeMappingEntry)this.classIndex.get(new classCtxEntry(clazz, classContext));
        if (typeMappingEntry != null) {
            return typeMappingEntry;
        }
        if (this.parent != null) {
            return this.parent.get(clazz, classContext);
        }
        return null;
    }

    public TypeMappingEntry get(XMLName xMLName, SchemaContext schemaContext) {
        if (xMLName == null) {
            throw new IllegalArgumentException("schema_type cannot be null");
        }
        schemaCtxEntry schemaCtxEntry2 = new schemaCtxEntry(xMLName, schemaContext);
        TypeMappingEntry typeMappingEntry = (TypeMappingEntry)this.schemaIndex.get(schemaCtxEntry2);
        if (typeMappingEntry != null) {
            return typeMappingEntry;
        }
        if (this.parent != null) {
            return this.parent.get(xMLName, schemaContext);
        }
        return null;
    }

    public TypeMappingEntry[] getEntries() {
        return this.entries.toArray(new TypeMappingEntry[0]);
    }

    public TypeMapping getParent() {
        return this.parent;
    }

    public void setParent(TypeMapping typeMapping) {
        this.parent = typeMapping;
    }

    public void dump(PrintStream printStream) {
        printStream.println(this.getClass().getName() + " size=" + this.entries.size());
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            TypeMappingEntry typeMappingEntry = (TypeMappingEntry)iterator.next();
            printStream.println("entry: " + typeMappingEntry);
        }
        if (this.parent != null) {
            ((TypeMappingBase)this.parent).dump(printStream);
        }
    }

    private boolean checkConstaints(TypeMappingEntry typeMappingEntry) {
        Debug.assertion(typeMappingEntry != null);
        classCtxEntry classCtxEntry2 = new classCtxEntry(typeMappingEntry);
        TypeMappingEntry typeMappingEntry2 = (TypeMappingEntry)this.classIndex.get(classCtxEntry2);
        if (typeMappingEntry2 != null && !typeMappingEntry.getSchemaType().equals(typeMappingEntry2.getSchemaType())) {
            return false;
        }
        schemaCtxEntry schemaCtxEntry2 = new schemaCtxEntry(typeMappingEntry);
        TypeMappingEntry typeMappingEntry3 = (TypeMappingEntry)this.schemaIndex.get(schemaCtxEntry2);
        return typeMappingEntry3 == null || typeMappingEntry.getJavaType().getName().equals(typeMappingEntry3.getJavaType().getName());
    }

    private void addToConstaints(TypeMappingEntry typeMappingEntry) {
        classCtxEntry classCtxEntry2 = new classCtxEntry(typeMappingEntry);
        this.classIndex.put(classCtxEntry2, typeMappingEntry);
        schemaCtxEntry schemaCtxEntry2 = new schemaCtxEntry(typeMappingEntry);
        this.schemaIndex.put(schemaCtxEntry2, typeMappingEntry);
    }

    private void removeFromConstaints(TypeMappingEntry typeMappingEntry) {
        classCtxEntry classCtxEntry2 = new classCtxEntry(typeMappingEntry);
        this.classIndex.remove(classCtxEntry2);
        schemaCtxEntry schemaCtxEntry2 = new schemaCtxEntry(typeMappingEntry);
        this.schemaIndex.remove(schemaCtxEntry2);
    }

    public void readXML(InputStream inputStream) throws IOException {
        try {
            XMLInputStreamFactory xMLInputStreamFactory = XMLInputStreamFactory.newInstance();
            TypeFilter typeFilter = new TypeFilter(22);
            XMLInputStream xMLInputStream = xMLInputStreamFactory.newInputStream(inputStream, (ElementFilter)typeFilter);
            this.readXML(xMLInputStream);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new IOException("failed to create xml input stream:" + xMLStreamException);
        }
    }

    private void addTypeMapping(StartElement startElement) throws IOException {
        Class clazz = this.loadClass(this.getAttribute(CLASS_ATT_NAME, startElement));
        String string = this.getAttribute(TYPE_ATT_NAME, startElement, false);
        String string2 = this.getAttribute(ELEMENT_ATT_NAME, startElement, false);
        XMLName xMLName = null;
        if (string != null && string2 != null) {
            throw new IOException("Only one of type or element should be specified in " + startElement + " at " + startElement.getLocation());
        }
        if (string == null && string2 == null) {
            throw new IOException("One of type or element must be specified in " + startElement + " at " + startElement.getLocation());
        }
        xMLName = string != null ? TypeMappingBase.fillXMLName(string, startElement) : TypeMappingBase.fillXMLName(string2, startElement);
        Serializer serializer = (Serializer)this.newInstance(this.getAttribute(SERIALIZER_ATT_NAME, startElement));
        Deserializer deserializer = (Deserializer)this.newInstance(this.getAttribute(DESERIALIZER_ATT_NAME, startElement));
        this.add(clazz, xMLName, serializer, deserializer);
    }

    private static XMLName fillXMLName(String string, StartElement startElement) {
        ExpName expName = ExpName.createFromQName(string);
        String string2 = expName.getPrefix();
        if (string2 == null) {
            return expName;
        }
        Map map = startElement.getNamespaceMap();
        String string3 = (String)map.get(string2);
        return ElementFactory.createXMLName(string3, expName.getLocalName(), string2);
    }

    private Object newInstance(String string) throws IOException {
        try {
            Class clazz = this.loadClass(string);
            return clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("failed to create new instance:" + illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("failed to create new instance:" + instantiationException);
        }
    }

    private Class loadClass(String string) throws IOException {
        try {
            return ClassLoadingUtils.loadClass(string, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new IOException(classNotFoundException.getMessage());
        }
    }

    private String getAttribute(XMLName xMLName, StartElement startElement) throws IOException {
        return this.getAttribute(xMLName, startElement, true);
    }

    private String getAttribute(XMLName xMLName, StartElement startElement, boolean bl) throws IOException {
        Attribute attribute = startElement.getAttributeByName(xMLName);
        if (bl && (attribute == null || attribute.getValue() == null)) {
            throw new IOException(xMLName + " attribute not defined in " + startElement + " at " + startElement.getLocation());
        }
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    public void writeXML(PrintStream printStream) throws IOException {
        try {
            XMLOutputStream xMLOutputStream = XMLOutputStreamFactory.newInstance().newOutputStream(printStream);
            this.writeXML(xMLOutputStream);
            xMLOutputStream.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new IOException("stream error:" + xMLStreamException);
        }
    }

    public void writeXML(XMLOutputStream xMLOutputStream) throws XMLStreamException {
        xMLOutputStream.add(ElementFactory.createStartElement(REGISTRY_ELEM_NAME));
        xMLOutputStream.add(ElementFactory.createNamespaceAttribute(DD_PREFIX, DD_NS));
        xMLOutputStream.add(ElementFactory.createNamespaceAttribute(XSD_PREFIX, "http://www.w3.org/2001/XMLSchema"));
        xMLOutputStream.add(ElementFactory.createNamespaceAttribute(SOAPENC_PREFIX, SoapTypes.ENCODING_URI));
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            TypeMappingEntry typeMappingEntry = (TypeMappingEntry)iterator.next();
            Class clazz = typeMappingEntry.getJavaType();
            XMLName xMLName = typeMappingEntry.getSchemaType();
            SerializerFactory serializerFactory = typeMappingEntry.getSerializer();
            DeserializerFactory deserializerFactory = typeMappingEntry.getDeserializer();
            xMLOutputStream.add(ElementFactory.createStartElement(ENTRY_ELEM_NAME));
            xMLName = TypeMappingBase.fixPrefix(xMLName, xMLOutputStream);
            String string = clazz.getName();
            if (clazz.isArray()) {
                string = ArrayUtils.getArrayDeclString(string);
            }
            xMLOutputStream.add(ElementFactory.createAttribute(CLASS_ATT_NAME.getLocalName(), string));
            xMLOutputStream.add(ElementFactory.createAttribute(TYPE_ATT_NAME.getLocalName(), xMLName.getQualifiedName()));
            xMLOutputStream.add(ElementFactory.createAttribute(SERIALIZER_ATT_NAME.getLocalName(), serializerFactory.getClass().getName()));
            xMLOutputStream.add(ElementFactory.createAttribute(DESERIALIZER_ATT_NAME.getLocalName(), deserializerFactory.getClass().getName()));
            xMLOutputStream.add(ElementFactory.createEndElement(ENTRY_ELEM_NAME));
        }
        xMLOutputStream.add(ElementFactory.createEndElement(REGISTRY_ELEM_NAME));
    }

    private static final XMLName fixPrefix(XMLName xMLName, XMLOutputStream xMLOutputStream) throws XMLStreamException {
        String string;
        String string2 = xMLName.getNamespaceUri();
        String string3 = string = string2 == null ? null : "lcl0";
        if ("http://www.w3.org/2001/XMLSchema".equals(string2)) {
            string = XSD_PREFIX;
        } else if (SoapTypes.ENCODING_URI.equals(string2)) {
            string = SOAPENC_PREFIX;
        } else if (string2 != null) {
            xMLOutputStream.add(ElementFactory.createNamespaceAttribute(string, string2));
        }
        return ElementFactory.createXMLName(string2, xMLName.getLocalName(), string);
    }

    public void readXML(XMLInputStream xMLInputStream) throws IOException, XMLStreamException {
        if (!xMLInputStream.skip(REGISTRY_ELEM_LOCALNAME, 2)) {
            return;
        }
        XMLEvent xMLEvent = xMLInputStream.next();
        TypeMappingBase.verifyNamespace(xMLEvent);
        while (xMLInputStream.skip(6)) {
            XMLEvent xMLEvent2 = xMLInputStream.next();
            TypeMappingBase.verifyNamespace(xMLEvent2);
            if (xMLEvent2.isStartElement()) {
                if (xMLEvent2.hasName() && ENTRY_ELEM_LOCALNAME.getLocalName().equals(xMLEvent2.getName().getLocalName())) {
                    this.addTypeMapping((StartElement)xMLEvent2);
                    continue;
                }
                String string = "Illegal element: " + xMLEvent2 + " at " + xMLEvent2.getLocation() + " was expecting StartElement of type " + ENTRY_ELEM_LOCALNAME;
                throw new IOException(string);
            }
            if (xMLEvent2.hasName() && REGISTRY_ELEM_LOCALNAME.getLocalName().equals(xMLEvent2.getName().getLocalName())) {
                return;
            }
            if (xMLEvent2.hasName() && ENTRY_ELEM_LOCALNAME.getLocalName().equals(xMLEvent2.getName().getLocalName())) continue;
            String string = "Illegal end element: " + xMLEvent2 + " at " + xMLEvent2.getLocation() + " was expecting EndElement of type " + ENTRY_ELEM_LOCALNAME + " or " + REGISTRY_ELEM_LOCALNAME;
            throw new IOException(string);
        }
    }

    private static void verifyNamespace(XMLEvent xMLEvent) throws IOException {
        XMLName xMLName;
        String string;
        if (xMLEvent.hasName() && (string = (xMLName = xMLEvent.getName()).getNamespaceUri()) != null && !DD_NS.equals(string)) {
            String string2 = "unknown";
            Location location = xMLEvent.getLocation();
            if (location != null) {
                string2 = "line " + location.getLineNumber() + ", column " + location.getColumnNumber();
            }
            String string3 = "invalid namespace for " + xMLEvent + " at " + string2 + ".  The namespace must be " + DD_NS + " or it must not be defined.";
            throw new IOException(string3);
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter(this.entries.size() * 64);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.dump(printWriter);
        return stringWriter.getBuffer().toString();
    }

    public void dump2(PrintStream printStream) {
        printStream.print(this.toString());
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("TYPEMAPPING SIZE=" + this.entries.size());
        Iterator iterator = this.entries.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            TypeMappingEntry typeMappingEntry = (TypeMappingEntry)iterator.next();
            Class clazz = typeMappingEntry.getJavaType();
            XMLName xMLName = typeMappingEntry.getSchemaType();
            ClassContext classContext = typeMappingEntry.getClassContext();
            SchemaContext schemaContext = typeMappingEntry.getSchemaContext();
            SerializerFactory serializerFactory = typeMappingEntry.getSerializer();
            DeserializerFactory deserializerFactory = typeMappingEntry.getDeserializer();
            printWriter.println("ENTRY " + ++n + ":");
            printWriter.println(" class:    " + clazz.getName());
            printWriter.println(" xsd_type: " + xMLName);
            printWriter.println(" ser:      " + serializerFactory);
            printWriter.println(" deser:    " + deserializerFactory);
        }
    }

    private static Map buildPresetHolders() {
        HashMap<String, Class> hashMap = new HashMap<String, Class>();
        hashMap.put(Boolean.TYPE.getName(), class$javax$xml$rpc$holders$BooleanHolder == null ? (class$javax$xml$rpc$holders$BooleanHolder = TypeMappingBase.class$("javax.xml.rpc.holders.BooleanHolder")) : class$javax$xml$rpc$holders$BooleanHolder);
        hashMap.put(Byte.TYPE.getName(), class$javax$xml$rpc$holders$ByteHolder == null ? (class$javax$xml$rpc$holders$ByteHolder = TypeMappingBase.class$("javax.xml.rpc.holders.ByteHolder")) : class$javax$xml$rpc$holders$ByteHolder);
        hashMap.put(Short.TYPE.getName(), class$javax$xml$rpc$holders$ShortHolder == null ? (class$javax$xml$rpc$holders$ShortHolder = TypeMappingBase.class$("javax.xml.rpc.holders.ShortHolder")) : class$javax$xml$rpc$holders$ShortHolder);
        hashMap.put(Integer.TYPE.getName(), class$javax$xml$rpc$holders$IntHolder == null ? (class$javax$xml$rpc$holders$IntHolder = TypeMappingBase.class$("javax.xml.rpc.holders.IntHolder")) : class$javax$xml$rpc$holders$IntHolder);
        hashMap.put(Long.TYPE.getName(), class$javax$xml$rpc$holders$LongHolder == null ? (class$javax$xml$rpc$holders$LongHolder = TypeMappingBase.class$("javax.xml.rpc.holders.LongHolder")) : class$javax$xml$rpc$holders$LongHolder);
        hashMap.put(Float.TYPE.getName(), class$javax$xml$rpc$holders$FloatHolder == null ? (class$javax$xml$rpc$holders$FloatHolder = TypeMappingBase.class$("javax.xml.rpc.holders.FloatHolder")) : class$javax$xml$rpc$holders$FloatHolder);
        hashMap.put(Double.TYPE.getName(), class$javax$xml$rpc$holders$DoubleHolder == null ? (class$javax$xml$rpc$holders$DoubleHolder = TypeMappingBase.class$("javax.xml.rpc.holders.DoubleHolder")) : class$javax$xml$rpc$holders$DoubleHolder);
        hashMap.put(Character.TYPE.getName(), class$weblogic$xml$schema$binding$util$runtime$CharHolder == null ? (class$weblogic$xml$schema$binding$util$runtime$CharHolder = TypeMappingBase.class$("weblogic.xml.schema.binding.util.runtime.CharHolder")) : class$weblogic$xml$schema$binding$util$runtime$CharHolder);
        hashMap.put((class$java$lang$String == null ? (class$java$lang$String = TypeMappingBase.class$("java.lang.String")) : class$java$lang$String).getName(), class$javax$xml$rpc$holders$StringHolder == null ? (class$javax$xml$rpc$holders$StringHolder = TypeMappingBase.class$("javax.xml.rpc.holders.StringHolder")) : class$javax$xml$rpc$holders$StringHolder);
        try {
            hashMap.put((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TypeMappingBase.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName(), class$javax$xml$rpc$holders$BigDecimalHolder == null ? (class$javax$xml$rpc$holders$BigDecimalHolder = TypeMappingBase.class$("javax.xml.rpc.holders.BigDecimalHolder")) : class$javax$xml$rpc$holders$BigDecimalHolder);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        hashMap.put((class$java$math$BigInteger == null ? (class$java$math$BigInteger = TypeMappingBase.class$("java.math.BigInteger")) : class$java$math$BigInteger).getName(), class$javax$xml$rpc$holders$BigIntegerHolder == null ? (class$javax$xml$rpc$holders$BigIntegerHolder = TypeMappingBase.class$("javax.xml.rpc.holders.BigIntegerHolder")) : class$javax$xml$rpc$holders$BigIntegerHolder);
        hashMap.put((array$B == null ? (array$B = TypeMappingBase.class$("[B")) : array$B).getName(), class$javax$xml$rpc$holders$ByteArrayHolder == null ? (class$javax$xml$rpc$holders$ByteArrayHolder = TypeMappingBase.class$("javax.xml.rpc.holders.ByteArrayHolder")) : class$javax$xml$rpc$holders$ByteArrayHolder);
        hashMap.put((class$java$util$Calendar == null ? (class$java$util$Calendar = TypeMappingBase.class$("java.util.Calendar")) : class$java$util$Calendar).getName(), class$javax$xml$rpc$holders$CalendarHolder == null ? (class$javax$xml$rpc$holders$CalendarHolder = TypeMappingBase.class$("javax.xml.rpc.holders.CalendarHolder")) : class$javax$xml$rpc$holders$CalendarHolder);
        hashMap.put((class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = TypeMappingBase.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName).getName(), class$javax$xml$rpc$holders$QNameHolder == null ? (class$javax$xml$rpc$holders$QNameHolder = TypeMappingBase.class$("javax.xml.rpc.holders.QNameHolder")) : class$javax$xml$rpc$holders$QNameHolder);
        hashMap.put((class$java$lang$Float == null ? (class$java$lang$Float = TypeMappingBase.class$("java.lang.Float")) : class$java$lang$Float).getName(), class$javax$xml$rpc$holders$FloatWrapperHolder == null ? (class$javax$xml$rpc$holders$FloatWrapperHolder = TypeMappingBase.class$("javax.xml.rpc.holders.FloatWrapperHolder")) : class$javax$xml$rpc$holders$FloatWrapperHolder);
        hashMap.put((class$java$lang$Double == null ? (class$java$lang$Double = TypeMappingBase.class$("java.lang.Double")) : class$java$lang$Double).getName(), class$javax$xml$rpc$holders$DoubleWrapperHolder == null ? (class$javax$xml$rpc$holders$DoubleWrapperHolder = TypeMappingBase.class$("javax.xml.rpc.holders.DoubleWrapperHolder")) : class$javax$xml$rpc$holders$DoubleWrapperHolder);
        hashMap.put((class$java$lang$Long == null ? (class$java$lang$Long = TypeMappingBase.class$("java.lang.Long")) : class$java$lang$Long).getName(), class$javax$xml$rpc$holders$LongWrapperHolder == null ? (class$javax$xml$rpc$holders$LongWrapperHolder = TypeMappingBase.class$("javax.xml.rpc.holders.LongWrapperHolder")) : class$javax$xml$rpc$holders$LongWrapperHolder);
        hashMap.put((class$java$lang$Integer == null ? (class$java$lang$Integer = TypeMappingBase.class$("java.lang.Integer")) : class$java$lang$Integer).getName(), class$javax$xml$rpc$holders$IntegerWrapperHolder == null ? (class$javax$xml$rpc$holders$IntegerWrapperHolder = TypeMappingBase.class$("javax.xml.rpc.holders.IntegerWrapperHolder")) : class$javax$xml$rpc$holders$IntegerWrapperHolder);
        hashMap.put((class$java$lang$Short == null ? (class$java$lang$Short = TypeMappingBase.class$("java.lang.Short")) : class$java$lang$Short).getName(), class$javax$xml$rpc$holders$ShortWrapperHolder == null ? (class$javax$xml$rpc$holders$ShortWrapperHolder = TypeMappingBase.class$("javax.xml.rpc.holders.ShortWrapperHolder")) : class$javax$xml$rpc$holders$ShortWrapperHolder);
        hashMap.put((class$java$lang$Byte == null ? (class$java$lang$Byte = TypeMappingBase.class$("java.lang.Byte")) : class$java$lang$Byte).getName(), class$javax$xml$rpc$holders$ByteWrapperHolder == null ? (class$javax$xml$rpc$holders$ByteWrapperHolder = TypeMappingBase.class$("javax.xml.rpc.holders.ByteWrapperHolder")) : class$javax$xml$rpc$holders$ByteWrapperHolder);
        hashMap.put((class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypeMappingBase.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName(), class$javax$xml$rpc$holders$BooleanWrapperHolder == null ? (class$javax$xml$rpc$holders$BooleanWrapperHolder = TypeMappingBase.class$("javax.xml.rpc.holders.BooleanWrapperHolder")) : class$javax$xml$rpc$holders$BooleanWrapperHolder);
        hashMap.put((class$java$lang$Character == null ? (class$java$lang$Character = TypeMappingBase.class$("java.lang.Character")) : class$java$lang$Character).getName(), class$weblogic$xml$schema$binding$util$runtime$CharWrapperHolder == null ? (class$weblogic$xml$schema$binding$util$runtime$CharWrapperHolder = TypeMappingBase.class$("weblogic.xml.schema.binding.util.runtime.CharWrapperHolder")) : class$weblogic$xml$schema$binding$util$runtime$CharWrapperHolder);
        hashMap.put((class$java$util$Date == null ? (class$java$util$Date = TypeMappingBase.class$("java.util.Date")) : class$java$util$Date).getName(), class$weblogic$xml$schema$binding$util$runtime$DateObjectHolder == null ? (class$weblogic$xml$schema$binding$util$runtime$DateObjectHolder = TypeMappingBase.class$("weblogic.xml.schema.binding.util.runtime.DateObjectHolder")) : class$weblogic$xml$schema$binding$util$runtime$DateObjectHolder);
        hashMap.put((class$java$lang$Object == null ? (class$java$lang$Object = TypeMappingBase.class$("java.lang.Object")) : class$java$lang$Object).getName(), class$weblogic$xml$schema$binding$util$runtime$ObjectHolder == null ? (class$weblogic$xml$schema$binding$util$runtime$ObjectHolder = TypeMappingBase.class$("weblogic.xml.schema.binding.util.runtime.ObjectHolder")) : class$weblogic$xml$schema$binding$util$runtime$ObjectHolder);
        hashMap.put((class$javax$xml$soap$SOAPElement == null ? (class$javax$xml$soap$SOAPElement = TypeMappingBase.class$("javax.xml.soap.SOAPElement")) : class$javax$xml$soap$SOAPElement).getName(), class$weblogic$xml$schema$binding$util$runtime$SOAPElementHolder == null ? (class$weblogic$xml$schema$binding$util$runtime$SOAPElementHolder = TypeMappingBase.class$("weblogic.xml.schema.binding.util.runtime.SOAPElementHolder")) : class$weblogic$xml$schema$binding$util$runtime$SOAPElementHolder);
        return hashMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        primMap.put(Boolean.TYPE.getName(), Boolean.TYPE);
        primMap.put(Character.TYPE.getName(), Character.TYPE);
        primMap.put(Byte.TYPE.getName(), Byte.TYPE);
        primMap.put(Short.TYPE.getName(), Short.TYPE);
        primMap.put(Integer.TYPE.getName(), Integer.TYPE);
        primMap.put(Long.TYPE.getName(), Long.TYPE);
        primMap.put(Float.TYPE.getName(), Float.TYPE);
        primMap.put(Double.TYPE.getName(), Double.TYPE);
        REGISTRY_ELEM_NAME = ElementFactory.createXMLName(DD_NS, "type-mapping", DD_PREFIX);
        ENTRY_ELEM_NAME = ElementFactory.createXMLName(DD_NS, "type-mapping-entry", DD_PREFIX);
        REGISTRY_ELEM_LOCALNAME = ElementFactory.createXMLName(REGISTRY_ELEM_NAME.getLocalName());
        ENTRY_ELEM_LOCALNAME = ElementFactory.createXMLName(ENTRY_ELEM_NAME.getLocalName());
        CLASS_ATT_NAME = ElementFactory.createXMLName("class-name");
        TYPE_ATT_NAME = ElementFactory.createXMLName("type");
        ELEMENT_ATT_NAME = ElementFactory.createXMLName("element");
        SERIALIZER_ATT_NAME = ElementFactory.createXMLName("serializer");
        DESERIALIZER_ATT_NAME = ElementFactory.createXMLName("deserializer");
    }

    private static class schemaCtxEntry {
        private final XMLName n;
        private final SchemaContext ctx;

        schemaCtxEntry(XMLName xMLName, SchemaContext schemaContext) {
            this.n = xMLName;
            this.ctx = schemaContext;
        }

        schemaCtxEntry(TypeMappingEntry typeMappingEntry) {
            this(typeMappingEntry.getSchemaType(), typeMappingEntry.getSchemaContext());
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof schemaCtxEntry) {
                schemaCtxEntry schemaCtxEntry2 = (schemaCtxEntry)object;
                return this.n.equals(schemaCtxEntry2.n) && ((Object)this.ctx).equals(schemaCtxEntry2.ctx);
            }
            return false;
        }

        public int hashCode() {
            return this.n.hashCode();
        }
    }

    private static class classCtxEntry {
        private final Class c;
        private final ClassContext ctx;

        classCtxEntry(Class clazz, ClassContext classContext) {
            this.c = clazz;
            this.ctx = classContext;
        }

        classCtxEntry(TypeMappingEntry typeMappingEntry) {
            this(typeMappingEntry.getJavaType(), typeMappingEntry.getClassContext());
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof classCtxEntry) {
                classCtxEntry classCtxEntry2 = (classCtxEntry)object;
                return this.c.equals(classCtxEntry2.c) && ((Object)this.ctx).equals(classCtxEntry2.ctx);
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.ctx).hashCode();
        }
    }
}

