/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.internal;

import java.util.Map;
import weblogic.utils.Debug;
import weblogic.xml.schema.binding.BindingException;
import weblogic.xml.schema.binding.internal.SchemaUtil;
import weblogic.xml.schema.binding.util.runtime.IntList;
import weblogic.xml.schema.model.ExpName;
import weblogic.xml.stream.XMLName;

public final class SoapArrayDescriptor {
    private XMLName arrayTypeName = null;
    private IntList arrayTypeRanks = new IntList();
    private IntList arraySizes = new IntList();

    public SoapArrayDescriptor(XMLName xMLName, int[] nArray, int[] nArray2) {
        this.arrayTypeName = new ExpName(xMLName);
        this.setArrayTypeRanks(nArray);
        this.setArraySizes(nArray2);
    }

    public SoapArrayDescriptor(SoapArrayDescriptor soapArrayDescriptor) {
        this(soapArrayDescriptor.getArrayTypeName(), soapArrayDescriptor.getArrayTypeRanks(), soapArrayDescriptor.getArraySizes());
    }

    private SoapArrayDescriptor() {
    }

    public static SoapArrayDescriptor createFromXML(String string) throws BindingException {
        int n;
        SoapArrayDescriptor soapArrayDescriptor = new SoapArrayDescriptor();
        if (!string.endsWith("]")) {
            throw new BindingException("invalid arrayType \"" + string + "\" -- must end with ]");
        }
        int n2 = string.indexOf(91);
        int n3 = string.lastIndexOf(91);
        String string2 = string.substring(0, n2);
        soapArrayDescriptor.arrayTypeName = ExpName.createFromQName(string2);
        String string3 = string.substring(n2, n3);
        if (n3 > n2) {
            int n4 = n2;
            while (n4 < n3) {
                n = SoapArrayDescriptor.getRank(string, ++n4);
                soapArrayDescriptor.arrayTypeRanks.add(n);
                n4 = string.indexOf(91, n4);
            }
        }
        String string4 = string.substring(n3);
        n = string.length();
        char[] cArray = new char[n - n3];
        int n5 = 0;
        int n6 = n3 + 1;
        while (true) {
            char c;
            if ((c = string.charAt(n6)) == ',') {
                if (n5 > 0) {
                    soapArrayDescriptor.arraySizes.add(SoapArrayDescriptor.bufToInt(cArray, n5));
                } else {
                    soapArrayDescriptor.arraySizes.add(-1);
                }
                cArray = new char[n - n6];
                n5 = 0;
            } else {
                if (c == ']') {
                    if (n5 <= 0) break;
                    soapArrayDescriptor.arraySizes.add(SoapArrayDescriptor.bufToInt(cArray, n5));
                    break;
                }
                if (Character.isDigit(c)) {
                    cArray[n5++] = c;
                } else if (!SchemaUtil.isWhitespace(c)) {
                    throw new BindingException("invalid arrayType -- illegal rank character " + c);
                }
            }
            ++n6;
        }
        return soapArrayDescriptor;
    }

    public static SoapArrayDescriptor createFromTrustedXML(String string) {
        try {
            return SoapArrayDescriptor.createFromXML(string);
        }
        catch (BindingException bindingException) {
            return null;
        }
    }

    public XMLName getArrayTypeName() {
        return this.arrayTypeName;
    }

    public void setArrayTypeName(XMLName xMLName) {
        this.arrayTypeName = xMLName;
    }

    public int[] getArrayTypeRanks() {
        return this.arrayTypeRanks.getMinSizedArray();
    }

    public void setArrayTypeRanks(int[] nArray) {
        int n = nArray.length;
        this.arrayTypeRanks = new IntList(n);
        for (int i = 0; i < n; ++i) {
            this.arrayTypeRanks.add(nArray[i]);
        }
    }

    public boolean hasArraySizes() {
        return this.arraySizes.getSize() > 0;
    }

    public int[] getArraySizes() {
        return this.arraySizes.getMinSizedArray();
    }

    public void setArraySizes(int[] nArray) {
        int n = nArray.length;
        this.arraySizes = new IntList(n);
        for (int i = 0; i < n; ++i) {
            this.arraySizes.add(nArray[i]);
        }
    }

    private static int bufToInt(char[] cArray, int n) {
        Debug.assertion(cArray.length > 0);
        return Integer.parseInt(new String(cArray, 0, n));
    }

    private static int getRank(String string, int n) throws BindingException {
        int n2 = 1;
        int n3 = n;
        while (true) {
            char c;
            if ((c = string.charAt(n3)) == ',') {
                ++n2;
            } else {
                if (c == ']') break;
                throw new BindingException("invalid arrayType -- illegal asize character " + c);
            }
            ++n3;
        }
        return n2;
    }

    public static SoapArrayDescriptor createFromXML(String string, Map map) throws BindingException {
        SoapArrayDescriptor soapArrayDescriptor = SoapArrayDescriptor.createFromXML(string);
        ExpName expName = new ExpName(soapArrayDescriptor.getArrayTypeName());
        String string2 = expName.getPrefix();
        String string3 = (String)map.get(string2);
        if (string3 == null) {
            if (string2.length() == 0) {
                string3 = "http://www.w3.org/2001/XMLSchema";
            } else {
                throw new BindingException("prefix \"" + string2 + "\" is not mapped");
            }
        }
        expName.setUri(string3);
        soapArrayDescriptor.setArrayTypeName(expName);
        return soapArrayDescriptor;
    }

    public String baseTypeToXML() {
        StringBuffer stringBuffer = this.doBaseTypeToXML();
        return stringBuffer.toString();
    }

    private StringBuffer doBaseTypeToXML() {
        String string = this.arrayTypeName.getQualifiedName();
        StringBuffer stringBuffer = new StringBuffer(string.length() + 16);
        stringBuffer.append(string);
        int n = this.arrayTypeRanks.getSize();
        if (n > 0) {
            int[] nArray = this.arrayTypeRanks.getStore();
            for (int i = 0; i < n; ++i) {
                int n2 = nArray[i] - 1;
                stringBuffer.append('[');
                for (int j = 0; j < n2; ++j) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(']');
            }
        }
        return stringBuffer;
    }

    public String toXML() {
        StringBuffer stringBuffer = this.doBaseTypeToXML();
        int n = this.arraySizes.getSize();
        stringBuffer.append('[');
        if (n > 0) {
            int n2;
            int[] nArray = this.arraySizes.getStore();
            int n3 = n - 1;
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = nArray[n2];
                if (n4 >= 0) {
                    stringBuffer.append(n4);
                }
                stringBuffer.append(',');
            }
            n2 = nArray[n3];
            if (n2 >= 0) {
                stringBuffer.append(n2);
            } else {
                stringBuffer.append(',');
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public String toString() {
        int[] nArray = this.getArrayTypeRanks();
        int[] nArray2 = this.getArraySizes();
        StringBuffer stringBuffer = new StringBuffer(32 + 2 * nArray.length);
        stringBuffer.append("ranks(size=" + nArray.length + ")[");
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            stringBuffer.append(',');
        }
        stringBuffer.append(']');
        StringBuffer stringBuffer2 = new StringBuffer(32 + 2 * nArray2.length);
        stringBuffer2.append("sizes(size=" + nArray2.length + ")[");
        for (int i = 0; i < nArray2.length; ++i) {
            stringBuffer2.append(nArray2[i]);
            stringBuffer2.append(',');
        }
        stringBuffer2.append(']');
        return "SoapArrayDescriptor{arrayTypeName=" + this.arrayTypeName + " arrayTypeRank=" + stringBuffer + " arraySizes=" + stringBuffer2 + "}";
    }

    public static void main(String[] stringArray) throws Exception {
        String[] stringArray2 = new String[]{"s:int[]", "s:int[,]", "s:int[,][]", "s:int[,][,]", "s:int[,][,,]", "s:int[,,][,,]", "s:int[,,][,,,]", "s:int[][]", "s:int[][][]", "s:int[,][3]", "s:int[,][3,4]", "s:int[,,,][3,4]", "s:int[,,,][,,,][,,,,,][,,][4,5,3,4]", "s:int[,][,,][4]", "s:int[,][3]", "s:int[][3]"};
        for (int i = 0; i < 1; ++i) {
            for (int j = 0; j < stringArray2.length; ++j) {
                System.out.print("FOR: \"" + stringArray2[j] + "\" ");
                try {
                    SoapArrayDescriptor soapArrayDescriptor = SoapArrayDescriptor.createFromXML(stringArray2[j]);
                    System.out.println("\tArrayDesc = " + soapArrayDescriptor);
                    String string = soapArrayDescriptor.toXML();
                    System.out.println("\tArrayDesc toXML = " + string);
                    Debug.assertion(string.equals(stringArray2[j]));
                    continue;
                }
                catch (BindingException bindingException) {
                    System.out.println("FAILURE! :" + bindingException);
                }
            }
        }
    }
}

