/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.internal;

import weblogic.xml.schema.binding.BindingConfiguration;
import weblogic.xml.schema.binding.BindingException;
import weblogic.xml.schema.model.XSDException;
import weblogic.xml.schema.model.XSDSchema;
import weblogic.xml.util.WhitespaceUtils;

public final class SchemaUtil {
    private static final char TAB = '\t';
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final char SPACE = ' ';
    private static final String EMPTY_STRING = "";
    private static final String SCHEMA_TNS_PREFIX = "stns";

    public static String collapse(String string) {
        return WhitespaceUtils.collapse(string);
    }

    public static String replace(String string) {
        return WhitespaceUtils.replace(string);
    }

    static boolean isWhitespace(char c) {
        return WhitespaceUtils.isWhitespace(c);
    }

    public static XSDSchema createNewSchema(BindingConfiguration bindingConfiguration) throws BindingException {
        try {
            XSDSchema xSDSchema = new XSDSchema();
            xSDSchema.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
            boolean bl = bindingConfiguration.isSchemaElementFormQualified();
            xSDSchema.setElementFormDefaultQualified(bl);
            boolean bl2 = bindingConfiguration.isSchemaAttributeFormQualified();
            xSDSchema.setAttributeFormDefaultQualified(bl2);
            return xSDSchema;
        }
        catch (XSDException xSDException) {
            throw new BindingException(xSDException.getMessage(), xSDException);
        }
    }

    public static XSDSchema createNewSchema(BindingConfiguration bindingConfiguration, String string) throws BindingException {
        XSDSchema xSDSchema = SchemaUtil.createNewSchema(bindingConfiguration);
        xSDSchema.setTargetNamespace(string);
        if (string != null) {
            xSDSchema.addNamespace(SCHEMA_TNS_PREFIX, string);
        }
        return xSDSchema;
    }
}

