/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import weblogic.utils.StringUtils;
import weblogic.xml.schema.binding.BindingConfiguration;
import weblogic.xml.schema.types.XSDNCName;
import weblogic.xml.schema.types.util.NameValidator;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.XMLName;

public final class NameUtil {
    private static final boolean ASSERT = true;
    public static final char HYPHEN = '-';
    public static final char PERIOD = '.';
    public static final char COLON = ':';
    public static final char USCORE = '_';
    public static final char DOT = '\u00b7';
    public static final char TELEIA = '\u0387';
    public static final char AYAH = '\u06dd';
    public static final char ELHIZB = '\u06de';
    private static final boolean DEBUG = false;
    public static final String[] javaKeywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "continue", "const", "default", "do", "double", "else", "extends", "for", "false", "final", "finally", "float", "goto", "if", "implements", "import", "int", "interface", "instanceof", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "threadsafe", "throw", "throws", "transient", "true", "try", "throws", "volatile", "void", "while"};
    private static final Set javaWords = NameUtil.buildKeywords();
    private static final String LANG_PREFIX = "java.";
    private static final int ENDSTR = -1;
    private static final int SKIP = 99;
    private static final int PUNCT = 100;
    private static final int DIGIT = 101;
    private static final int MARK = 102;
    private static final int LETTER_UPPER = 110;
    private static final int LETTER_LOWER = 111;
    private static final int LETTER_NOCASE = 112;

    public static boolean isValidJavaIdentifer(String string) {
        if (string == null) {
            throw new NullPointerException("id cannot be null");
        }
        int n = string.length();
        if (n < 1) {
            return false;
        }
        if (javaWords.contains(string)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        if (n == 1) {
            return true;
        }
        int n2 = n - 1;
        for (int i = 1; i < n2; ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getJAXRPCClassName(String string) {
        string = NameUtil.getJavaName(string, false);
        if (!NameUtil.isValidJavaIdentifer(string = NameUtil.uppercaseFirstLetter(string))) {
            string = NameUtil.fixWordForJAXRPC(string);
        }
        return string;
    }

    public static String getJAXRPCMethodName(String string) {
        string = NameUtil.getJavaName(string, false);
        if (!NameUtil.isValidJavaIdentifer(string = NameUtil.lowercaseFirstLetter(string))) {
            string = NameUtil.fixWordForJAXRPC(string);
        }
        return string;
    }

    public static XMLName getXMLNameFromClass(Class clazz, BindingConfiguration bindingConfiguration) {
        String string = NameUtil.getNamespaceFromPackage(clazz, bindingConfiguration);
        String string2 = NameUtil.getRootClassNameFromClass(clazz.getName());
        StringBuffer stringBuffer = null;
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (NameValidator.validNCNameChar(c)) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string2);
            }
            stringBuffer.setCharAt(i, '_');
        }
        if (stringBuffer != null) {
            string2 = stringBuffer.toString();
        }
        XMLName xMLName = ElementFactory.createXMLName(string, string2);
        XSDNCName.validateXml(xMLName.getLocalName());
        return xMLName;
    }

    public static String getClassNameFromXMLName(XMLName xMLName) {
        String string = NameUtil.getClassName(xMLName.getLocalName());
        String string2 = xMLName.getNamespaceUri();
        String string3 = null;
        if (string2 != null) {
            string3 = NameUtil.getPackageFromNamespace(string2);
        }
        if (string3 != null) {
            return string3 + "." + string;
        }
        return string;
    }

    public static String getNamespaceFromPackage(Class clazz, BindingConfiguration bindingConfiguration) {
        Class<?> clazz2 = clazz;
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
        }
        String string = NameUtil.getPackageNameFromClass(clazz2.getName());
        String string2 = bindingConfiguration.getTargetNamespace(string);
        if (string2 != null) {
            return string2;
        }
        String string3 = bindingConfiguration.getFixedTargetNamespace();
        if (string3 != null) {
            return string3;
        }
        if (clazz2.isPrimitive()) {
            string = bindingConfiguration.getJavaLanguageNamespaceUri();
        } else if (string.startsWith(LANG_PREFIX)) {
            String string4 = string.substring(LANG_PREFIX.length());
            string = bindingConfiguration.getJavaLanguageNamespaceUri() + "." + string4;
        } else if (bindingConfiguration.isReversePackageIntoUrl()) {
            String[] stringArray = StringUtils.split(string, '.');
            StringBuffer stringBuffer = new StringBuffer(string.length());
            for (int i = stringArray.length - 1; i > 0; --i) {
                stringBuffer.append(stringArray[i]);
                stringBuffer.append('.');
            }
            stringBuffer.append(stringArray[0]);
            string = stringBuffer.toString();
        }
        return bindingConfiguration.getTargetNamespacePrefix() + string;
    }

    public static String getPackageFromNamespace(String string) {
        if (string == null) {
            throw new IllegalArgumentException("namespace cannot be null");
        }
        if (string.startsWith("java:")) {
            string = string.substring("java:".length());
        }
        return NameUtil.getPackageName(NameUtil.massageUri(string));
    }

    private static String massageUri(String string) {
        if (string.startsWith("http://") || string.startsWith("ftp://") || string.startsWith("https://")) {
            try {
                CharSequence charSequence;
                URL uRL = new URL(string);
                String string2 = uRL.getHost();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
                ArrayList<String> arrayList = new ArrayList<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    charSequence = stringTokenizer.nextToken();
                    arrayList.add((String)charSequence);
                }
                charSequence = new StringBuffer(string.length());
                int n = arrayList.size();
                for (int i = n - 1; i >= 0; --i) {
                    ((StringBuffer)charSequence).append(arrayList.get(i));
                    ((StringBuffer)charSequence).append(".");
                }
                if (uRL.getFile() != null) {
                    ((StringBuffer)charSequence).append(uRL.getFile());
                }
                if (uRL.getRef() != null) {
                    ((StringBuffer)charSequence).append("#");
                    ((StringBuffer)charSequence).append(uRL.getRef());
                }
                return ((StringBuffer)charSequence).toString();
            }
            catch (MalformedURLException malformedURLException) {
                return string;
            }
        }
        return string;
    }

    public static String getClassName(String string) {
        return NameUtil.getJavaName(string);
    }

    public static String getPropertyName(String string) {
        String string2 = NameUtil.getJavaName(string);
        return NameUtil.lowercaseFirstLetter(string2);
    }

    public static String getMethodName(String string) {
        String string2 = NameUtil.getJavaName(string);
        return NameUtil.lowercaseFirstLetter(string2);
    }

    public static String getPackageName(String string) {
        int n;
        if (string == null) {
            throw new IllegalArgumentException("string must not be null");
        }
        int n2 = string.length();
        if (n2 == 0) {
            return "";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            if (!Character.isJavaIdentifierPart(c)) {
                if (bl) {
                    String string2 = string.substring(n3, 1 + n4);
                    arrayList.add(NameUtil.fixWord(string2));
                }
                bl = false;
                continue;
            }
            if (!bl) {
                n3 = n;
            }
            bl = true;
            n4 = n;
        }
        if (bl) {
            String string3 = string.substring(n3, 1 + n4);
            arrayList.add(NameUtil.fixWord(string3));
        }
        if ((n = arrayList.size() - 1) < 0) {
            return "";
        }
        if (n == 0) {
            return (String)arrayList.get(0);
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(arrayList.get(i));
            stringBuffer.append('.');
        }
        stringBuffer.append(arrayList.get(n));
        return stringBuffer.toString();
    }

    public static String getConstantName(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        List list = NameUtil.split(string, false);
        int n2 = list.size() - 1;
        for (n = 0; n < n2; ++n) {
            stringBuffer.append((String)list.get(n));
            stringBuffer.append('_');
        }
        if (n2 >= 0) {
            stringBuffer.append((String)list.get(n2));
        }
        n = stringBuffer.length();
        for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            stringBuffer.setCharAt(i, Character.toUpperCase(c));
        }
        return stringBuffer.toString();
    }

    public static String getJavaName(String string) {
        return NameUtil.getJavaName(string, true);
    }

    public static String getJavaName(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        List list = NameUtil.split(string, true);
        if (list.size() > 0) {
            String string2 = (String)list.get(0);
            char c = string2.charAt(0);
            if (!Character.isJavaIdentifierStart(c)) {
                stringBuffer.append("J");
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
            }
        }
        if (bl) {
            return NameUtil.fixWord(stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public static String upcaseFirstLetter(String string) {
        if (string.length() < 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        char c = stringBuffer.charAt(0);
        stringBuffer.setCharAt(0, Character.toUpperCase(c));
        return stringBuffer.toString();
    }

    public static String lowercaseFirstLetter(String string) {
        if (string.length() < 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        char c = stringBuffer.charAt(0);
        stringBuffer.setCharAt(0, Character.toLowerCase(c));
        return stringBuffer.toString();
    }

    public static String uppercaseFirstLetter(String string) {
        if (string.length() < 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        char c = stringBuffer.charAt(0);
        stringBuffer.setCharAt(0, Character.toUpperCase(c));
        return stringBuffer.toString();
    }

    public static String getRootClassNameFromClass(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String getPackageNameFromClass(String string) {
        String string2;
        boolean bl = false;
        if (string.startsWith("[")) {
            bl = true;
            int n = string.lastIndexOf(91);
            int n2 = string.indexOf(59, n);
            string = n2 == -1 ? string.substring(n + 2) : string.substring(n + 2, n2);
        }
        if ((string2 = NameUtil.getPackageNameFromNonArrayClass(string)).length() < 1 && bl) {
            return "java.lang";
        }
        return string2;
    }

    private static String getPackageNameFromNonArrayClass(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    public static String getPackageNameFromClass(Class clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        Package package_ = clazz.getPackage();
        if (package_ == null) {
            return "";
        }
        return package_.getName();
    }

    public static String concatPackage(String string, String string2) {
        if (string != null && string.length() > 0) {
            if (string2 != null && string2.length() > 0) {
                return string + "." + string2;
            }
            return string;
        }
        return string2;
    }

    public static String getHolderPackage(String string) {
        if (string != null && string.length() > 0) {
            return NameUtil.concatPackage(string, "holders");
        }
        return string;
    }

    public static String getHolderClass(String string) {
        return string + "Holder";
    }

    public static List split(String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            return arrayList;
        }
        StringBuffer stringBuffer = new StringBuffer();
        SplitState splitState = new SplitState();
        splitState.idx = 0;
        splitState.str = string;
        splitState.len = string.length();
        int n = -1;
        int n2 = NameUtil.getNextGoodChar(splitState);
        while (splitState.idx < splitState.len) {
            n = n2;
            int n3 = splitState.type;
            if (splitState.type != 100) {
                stringBuffer.append((char)n);
            }
            ++splitState.idx;
            n2 = NameUtil.getNextGoodChar(splitState);
            if (n2 != -1 && !NameUtil.isBorder(n3, splitState.type)) continue;
            if (stringBuffer.length() > 0) {
                if (bl) {
                    char c = stringBuffer.charAt(0);
                    stringBuffer.setCharAt(0, Character.toUpperCase(c));
                }
                arrayList.add(stringBuffer.toString());
            }
            if (n2 == -1) break;
            stringBuffer = new StringBuffer();
        }
        return arrayList;
    }

    private static int getNextGoodChar(SplitState splitState) {
        while (splitState.idx < splitState.len) {
            char c = splitState.str.charAt(splitState.idx);
            splitState.type = NameUtil.getCharClass(c);
            if (splitState.type != 99) {
                return c;
            }
            ++splitState.idx;
        }
        return -1;
    }

    public static int getCharClass(char c) {
        if (NameUtil.isPunctuation(c)) {
            return 100;
        }
        if (Character.isDigit(c)) {
            return 101;
        }
        if (Character.isUpperCase(c)) {
            return 110;
        }
        if (Character.isLowerCase(c)) {
            return 111;
        }
        if (Character.isLetter(c)) {
            return 112;
        }
        if (Character.isJavaIdentifierPart(c)) {
            return 102;
        }
        return 99;
    }

    private static boolean isBorder(int n, int n2) {
        if (n == 100 ^ n2 == 100) {
            return true;
        }
        if (n == 101 ^ n2 == 101) {
            return true;
        }
        if (n == 111 && n2 != 111) {
            return true;
        }
        return NameUtil.isLetter(n) ^ NameUtil.isLetter(n2);
    }

    private static boolean isLetter(int n) {
        return n == 110 || n == 111 || n == 112;
    }

    public static boolean isPunctuation(char c) {
        return c == '-' || c == '.' || c == ':' || c == '\u00b7' || c == '\u0387' || c == '\u06dd' || c == '\u06de';
    }

    private static String fixFirstLetter(String string) {
        if (string.length() < 1) {
            return string;
        }
        char c = string.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            return 'x' + string;
        }
        return string;
    }

    private static String fixWord(String string) {
        if (NameUtil.isJavaReservedWord(string)) {
            string = string + '0';
        }
        return NameUtil.fixFirstLetter(string);
    }

    private static String fixWordForJAXRPC(String string) {
        if (NameUtil.isJavaReservedWord(string)) {
            string = "_" + string;
        }
        return string;
    }

    private static boolean isJavaReservedWord(String string) {
        return NameUtil.isJavaReservedWord(string, true);
    }

    private static boolean isJavaReservedWord(String string, boolean bl) {
        if (bl) {
            string = string.toLowerCase();
        }
        return javaWords.contains(string);
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("rn=\u2160\tnum=" + Character.getNumericValue('\u2160'));
        StringBuffer stringBuffer = new StringBuffer("Foo");
        stringBuffer.append('\u2160');
        stringBuffer.append("bar");
        String string = stringBuffer.toString();
        stringBuffer.append('\u2160');
        stringBuffer.append('\u2160');
        stringBuffer.append('\u2160');
        String string2 = stringBuffer.toString();
        String[] stringArray2 = new String[]{"class-new-if while ", "class", "if", "TOUGHOneHmmm", "SomeBadOne", "someBadOne", ".. A1", "..A1", "A  AA  1 B2", "..A1B2", "ZZA1B2", "ABCD5FDA", "ABCD55FDA", "..A1..", "A1", "A1..", "1a", "..1.2.3.4.a.b.c", "..1.2.ab..3.4.a.b.c", "abc123fgh456", "67abc123fgh456", "..67..abc..123..fgh..456..", "..abc123fgh456", "abc..123..fgh456", "1234", "12...34", "12.34", "..12..34..", "A.B.C.D", "xf1.ser4.fasd3.BIG", "final.class.testing.123", "Z", "  Z  ", "1", " ", ""};
        for (int i = 0; i < stringArray2.length; ++i) {
            System.out.print("FOR: " + stringArray2[i]);
            System.out.print("\tclass = " + NameUtil.getClassName(stringArray2[i]));
            System.out.print("\tmethod = " + NameUtil.getMethodName(stringArray2[i]));
            System.out.print("\tconstant = " + NameUtil.getConstantName(stringArray2[i]));
            System.out.println("\tpackage = " + NameUtil.getPackageName(stringArray2[i]));
        }
    }

    private static Set buildKeywords() {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < javaKeywords.length; ++i) {
            hashSet.add(javaKeywords[i]);
        }
        return hashSet;
    }

    private static class SplitState {
        int idx;
        String str;
        int len;
        int type;

        private SplitState() {
        }
    }
}

