/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.NoSuchElementException;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.xml.schema.binding.BindingException;
import weblogic.xml.schema.binding.ClassContext;
import weblogic.xml.schema.binding.ClassContextFactory;
import weblogic.xml.schema.binding.CodecBase;
import weblogic.xml.schema.binding.DeserializationContext;
import weblogic.xml.schema.binding.DeserializationException;
import weblogic.xml.schema.binding.Deserializer;
import weblogic.xml.schema.binding.RuntimeUtils;
import weblogic.xml.schema.binding.SchemaContext;
import weblogic.xml.schema.binding.SchemaContextFactory;
import weblogic.xml.schema.binding.SerializationContext;
import weblogic.xml.schema.binding.SerializationException;
import weblogic.xml.schema.binding.Serializer;
import weblogic.xml.schema.binding.internal.SoapArrayDescriptor;
import weblogic.xml.schema.binding.internal.SoapTypes;
import weblogic.xml.schema.binding.util.runtime.Accumulator;
import weblogic.xml.schema.binding.util.runtime.AccumulatorFactory;
import weblogic.xml.schema.binding.util.runtime.ObjectRefTable;
import weblogic.xml.schema.binding.util.runtime.PropertyInfo;
import weblogic.xml.schema.model.ExpName;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class SoapArrayCodecBase
extends CodecBase {
    private static final boolean DEBUG = false;
    private static final boolean ASSERT = false;
    private static final int[] ranks = new int[0];

    public int getPropertyCount() {
        return 0;
    }

    public PropertyInfo getPropertyInfo(int n) {
        throw new IndexOutOfBoundsException("invalid index " + n);
    }

    protected XMLName getXmlType() {
        return SoapTypes.Array;
    }

    protected SoapArrayDescriptor createArrayDescriptor(Object object, SerializationContext serializationContext) throws SerializationException {
        if (!this.isMultiDimensionalSoapArray()) {
            String string = "sub classes using non-multidimensional style soap  arrays must override createArrayDescriptor";
            throw new AssertionError(string);
        }
        Class<?> clazz = object.getClass();
        int n = 0;
        Class<?> clazz2 = clazz;
        while (clazz2.isArray()) {
            ++n;
            clazz2 = clazz2.getComponentType();
        }
        Class<?> clazz3 = clazz2;
        int[] nArray = new int[n];
        Object object2 = object;
        for (int i = 0; i < nArray.length; ++i) {
            int n2;
            nArray[i] = n2 = Array.getLength(object2);
            if (n2 <= 0) break;
            object2 = Array.get(object2, 0);
        }
        XMLName xMLName = this.getComponentXMLType(object, serializationContext);
        SoapArrayDescriptor soapArrayDescriptor = new SoapArrayDescriptor(xMLName, ranks, nArray);
        return soapArrayDescriptor;
    }

    protected XMLName getComponentXMLName(Object object, SerializationContext serializationContext) throws SerializationException {
        return this.getComponentXMLType(object, serializationContext);
    }

    protected XMLName getComponentXMLType(Object object, SerializationContext serializationContext) throws SerializationException {
        Class clazz = SoapArrayCodecBase.getArrayBaseType(object);
        XMLName xMLName = serializationContext.getMapping().getXMLNameFromClass(clazz);
        if (xMLName == null) {
            String string = "Failed to find xml type for java class " + clazz + " in the type mapping";
            throw new SerializationException(string);
        }
        return xMLName;
    }

    protected static final Class getArrayBaseType(Object object) {
        Class<?> clazz = object.getClass();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    protected boolean isMultiDimensionalSoapArray() {
        return true;
    }

    protected ClassContext getClassContext(Class clazz, SerializationContext serializationContext) {
        XMLName xMLName = serializationContext.getMapping().getXMLNameFromClass(clazz);
        return ClassContextFactory.newInstance().createClassContext(xMLName);
    }

    protected SchemaContext getSchemaContext(XMLName xMLName, DeserializationContext deserializationContext) throws DeserializationException {
        Class clazz = this.getComponentClass(xMLName, deserializationContext);
        String string = clazz.getName();
        return SchemaContextFactory.newInstance().createSchemaContext(string);
    }

    protected Class getComponentClass(Object object, SerializationContext serializationContext) {
        if (this.isMultiDimensionalSoapArray()) {
            Class<?> clazz = object.getClass();
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        return object.getClass().getComponentType();
    }

    public Object deserialize(XMLName xMLName, Attribute attribute, DeserializationContext deserializationContext) throws DeserializationException {
        throw new AssertionError("soap arrays not supported in attributes");
    }

    protected Class getComponentClass(XMLName xMLName, DeserializationContext deserializationContext) throws DeserializationException {
        Class clazz = this.getExpectedComponentClass();
        if (clazz != null) {
            return clazz;
        }
        clazz = deserializationContext.getMapping().getClassFromXMLName(xMLName);
        if (clazz == null) {
            throw new DeserializationException("component_type:" + xMLName + " lookup failure");
        }
        return clazz;
    }

    public Object deserialize(XMLName xMLName, XMLInputStream xMLInputStream, DeserializationContext deserializationContext) throws DeserializationException {
        boolean bl = deserializationContext.isValidateNames();
        deserializationContext.setValidateNames(false);
        try {
            Object object;
            Object object2 = null;
            if (xMLInputStream.skip(2)) {
                if (RuntimeUtils.checkForXsiNil((StartElement)xMLInputStream.peek())) {
                    xMLInputStream.skipElement();
                    Object var6_8 = null;
                    return var6_8;
                }
                object = (StartElement)xMLInputStream.next();
                String string = SoapArrayCodecBase.checkForRef((StartElement)object);
                if (string != null) {
                    Object object3 = SoapArrayCodecBase.deserializeReferredObject(string, this, xMLName, xMLInputStream, deserializationContext);
                    return object3;
                }
                SoapArrayDescriptor soapArrayDescriptor = null;
                Attribute attribute = object.getAttributeByName(SoapTypes.SoapArrayType);
                if (attribute != null) {
                    soapArrayDescriptor = SoapArrayDescriptor.createFromXML(attribute.getValue(), object.getNamespaceMap());
                }
                Deserializer deserializer = this.getComponentDeserializer(soapArrayDescriptor, deserializationContext);
                EntryIterator entryIterator = new EntryIterator(soapArrayDescriptor, deserializer, xMLInputStream, deserializationContext);
                object2 = this.createAndPopulateArray(entryIterator, soapArrayDescriptor, SoapArrayCodecBase.checkForId((StartElement)object), deserializationContext);
                if (entryIterator.hasNext()) {
                    xMLInputStream.skip(4);
                    XMLEvent xMLEvent = xMLInputStream.next();
                }
            } else {
                throw new DeserializationException("bad xml");
            }
            object = object2;
            return object;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DeserializationException(xMLStreamException.getMessage(), xMLStreamException);
        }
        catch (BindingException bindingException) {
            throw new DeserializationException(bindingException.getMessage(), bindingException);
        }
        finally {
            deserializationContext.setValidateNames(bl);
        }
    }

    protected Object createAndPopulateArray(EntryIterator entryIterator, SoapArrayDescriptor soapArrayDescriptor, String string, DeserializationContext deserializationContext) throws XMLStreamException, DeserializationException {
        Object object;
        Class clazz = this.getComponentClassFromDesc(soapArrayDescriptor, deserializationContext);
        int[] nArray = this.getArraySizes(soapArrayDescriptor);
        if (nArray != null) {
            object = Array.newInstance(clazz, nArray);
            if (string != null) {
                deserializationContext.storeObjectWithReference(string, object);
            }
            this.populateArray(object, entryIterator, deserializationContext);
        } else {
            Accumulator accumulator = AccumulatorFactory.createAccumulator(clazz);
            object = this.populateAccumulator(accumulator, entryIterator, deserializationContext);
            if (string != null) {
                deserializationContext.storeObjectWithReference(string, object);
            }
        }
        return object;
    }

    private int[] getArraySizes(SoapArrayDescriptor soapArrayDescriptor) {
        if (soapArrayDescriptor == null) {
            return null;
        }
        if (!soapArrayDescriptor.hasArraySizes()) {
            return null;
        }
        int[] nArray = soapArrayDescriptor.getArraySizes();
        if (nArray.length < 1) {
            return null;
        }
        return nArray;
    }

    private Class getComponentClassFromDesc(SoapArrayDescriptor soapArrayDescriptor, DeserializationContext deserializationContext) throws DeserializationException {
        Class clazz;
        if (soapArrayDescriptor != null) {
            clazz = this.getExpectedComponentClass();
            if (clazz == null) {
                clazz = this.getComponentClass(soapArrayDescriptor.getArrayTypeName(), deserializationContext);
            }
            if (clazz == null) {
                throw new DeserializationException("failed to determine array type from " + soapArrayDescriptor.toXML());
            }
        } else {
            clazz = this.getExpectedComponentClass();
            if (clazz == null) {
                throw new DeserializationException("failed to determine array type.");
            }
        }
        return clazz;
    }

    protected final Object populateAccumulator(Accumulator accumulator, EntryIterator entryIterator, DeserializationContext deserializationContext) throws XMLStreamException, DeserializationException {
        while (entryIterator.hasNext()) {
            Object object = entryIterator.next();
            accumulator.append(object);
        }
        return accumulator.getFinalArray();
    }

    protected void populateArray(Object object, EntryIterator entryIterator, DeserializationContext deserializationContext) throws XMLStreamException, DeserializationException {
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2.isArray()) {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                this.populateArray(objectArray[i], entryIterator, deserializationContext);
            }
        } else {
            this.populateComponentArray(object, entryIterator, deserializationContext);
        }
    }

    protected void populateComponentArray(Object object, EntryIterator entryIterator, DeserializationContext deserializationContext) throws XMLStreamException, DeserializationException {
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            if (!entryIterator.hasNext()) {
                return;
            }
            Object object2 = entryIterator.next();
            Array.set(object, i, object2);
        }
    }

    protected void gatherContents(Object object, ObjectRefTable.Entry entry, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
        if (SoapArrayCodecBase.isArrayOfPrimitive(object)) {
            return;
        }
        Serializer serializer = this.getComponentSerializer(object, serializationContext);
        XMLName xMLName = this.getComponentXMLName(object, serializationContext);
        if (this.isMultiDimensionalSoapArray()) {
            this.serializeMultiDimArray(object, serializer, xMLName, xMLOutputStream, serializationContext);
        } else {
            this.serializeOneDimArray(object, serializer, xMLName, xMLOutputStream, serializationContext);
        }
    }

    protected static final boolean isArrayOfPrimitive(Object object) {
        if (!object.getClass().isArray()) {
            return false;
        }
        Class clazz = SoapArrayCodecBase.getArrayBaseType(object);
        return clazz.isPrimitive();
    }

    protected String writeSoapArrayType(Object object, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException, XMLStreamException {
        SoapArrayDescriptor soapArrayDescriptor = this.createArrayDescriptor(object, serializationContext);
        ExpName expName = new ExpName(soapArrayDescriptor.getArrayTypeName());
        String string = SoapArrayCodecBase.fillPrefixDeclareNamespace(expName, xMLOutputStream, serializationContext);
        soapArrayDescriptor.setArrayTypeName(expName);
        String string2 = serializationContext.getPrefixForUri(SoapTypes.SoapArrayType.getNamespaceUri());
        Debug.assertion(string2 != null);
        ExpName expName2 = new ExpName(SoapTypes.SoapArrayType);
        expName2.setPrefix(string2);
        xMLOutputStream.add(ElementFactory.createAttribute(expName2, soapArrayDescriptor.toXML()));
        return string;
    }

    protected void writeContents(Object object, ObjectRefTable.Entry entry, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException, XMLStreamException {
        Serializable serializable;
        String string = this.writeSoapArrayType(object, xMLOutputStream, serializationContext);
        XMLName xMLName = this.getComponentXMLName(object, serializationContext);
        String string2 = null;
        if (xMLName.getNamespaceUri() != null) {
            serializable = new ExpName(xMLName);
            string2 = SoapArrayCodecBase.fillPrefixDeclareNamespace(serializable, xMLOutputStream, serializationContext);
            xMLName = serializable;
        }
        serializable = this.getComponentSerializer(object, serializationContext);
        if (this.isMultiDimensionalSoapArray()) {
            this.serializeMultiDimArray(object, (Serializer)serializable, xMLName, xMLOutputStream, serializationContext);
        } else {
            this.serializeOneDimArray(object, (Serializer)serializable, xMLName, xMLOutputStream, serializationContext);
        }
        SoapArrayCodecBase.removePrefixFromMap(string2, serializationContext);
        SoapArrayCodecBase.removePrefixFromMap(string, serializationContext);
    }

    protected boolean writeXsiType(SerializationContext serializationContext) {
        return false;
    }

    protected XMLName getExpectedArrayElementType() throws DeserializationException {
        String string = "Did not find required attribute " + SoapTypes.SoapArrayType;
        throw new DeserializationException(string);
    }

    protected Class getExpectedComponentClass() throws DeserializationException {
        return null;
    }

    protected Deserializer getComponentDeserializer(SoapArrayDescriptor soapArrayDescriptor, DeserializationContext deserializationContext) throws DeserializationException {
        XMLName xMLName = soapArrayDescriptor != null ? soapArrayDescriptor.getArrayTypeName() : this.getExpectedArrayElementType();
        SchemaContext schemaContext = this.getSchemaContext(xMLName, deserializationContext);
        return RuntimeUtils.lookup_deserializer(xMLName, schemaContext, deserializationContext);
    }

    protected Serializer getComponentSerializer(Object object, SerializationContext serializationContext) throws SerializationException {
        Class clazz = this.getComponentClass(object, serializationContext);
        ClassContext classContext = this.getClassContext(clazz, serializationContext);
        return RuntimeUtils.lookup_serializer(clazz, classContext, serializationContext);
    }

    protected void serializeOneDimArray(Object object, Serializer serializer, XMLName xMLName, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
        serializationContext.setInAttribute(false);
        boolean bl = serializationContext.isQualifyElements();
        boolean bl2 = this.isFormQualified();
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            serializationContext.setQualifyElements(bl2);
            serializer.serialize(Array.get(object, i), xMLName, xMLOutputStream, serializationContext);
        }
        serializationContext.setQualifyElements(bl);
    }

    protected boolean isFormQualified() {
        PropertyInfo propertyInfo = this.getPropertyInfo(0);
        return propertyInfo.isFormQualified();
    }

    protected void serializeMultiDimArray(Object object, Serializer serializer, XMLName xMLName, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2.isArray()) {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                this.serializeMultiDimArray(objectArray[i], serializer, xMLName, xMLOutputStream, serializationContext);
            }
        } else {
            this.serializeOneDimArray(object, serializer, xMLName, xMLOutputStream, serializationContext);
        }
    }

    protected static class EntryIterator {
        private final SoapArrayDescriptor arrayDescriptor;
        private final XMLInputStream reader;
        private final DeserializationContext context;
        private final Deserializer deser;
        private Object nextObject = null;
        private boolean haveNext = true;
        private static final XMLName dummy_elem_name = ElementFactory.createXMLName("dummy");

        public EntryIterator(SoapArrayDescriptor soapArrayDescriptor, Deserializer deserializer, XMLInputStream xMLInputStream, DeserializationContext deserializationContext) throws XMLStreamException, DeserializationException {
            this.arrayDescriptor = soapArrayDescriptor;
            this.reader = xMLInputStream;
            this.context = deserializationContext;
            this.deser = deserializer;
            this.getNextObject();
        }

        public boolean hasNext() {
            return this.haveNext;
        }

        public Object next() throws XMLStreamException, DeserializationException {
            Object object = this.nextObject;
            this.getNextObject();
            return object;
        }

        private void getNextObject() throws XMLStreamException, DeserializationException {
            if (!this.haveNext) {
                throw new NoSuchElementException("no more elements");
            }
            this.haveNext = false;
            XMLEvent xMLEvent = this.reader.peek();
            block5: while (xMLEvent != null) {
                switch (xMLEvent.getType()) {
                    case 2: {
                        XMLName xMLName = this.arrayDescriptor != null ? this.arrayDescriptor.getArrayTypeName() : dummy_elem_name;
                        this.nextObject = this.deser.deserialize(xMLName, this.reader, this.context);
                        this.haveNext = true;
                        break block5;
                    }
                    case 4: {
                        this.reader.next();
                        break block5;
                    }
                    case 8: 
                    case 16: 
                    case 32: 
                    case 64: 
                    case 1024: 
                    case 2048: 
                    case 4096: {
                        this.reader.next();
                        break;
                    }
                    default: {
                        this.reader.next();
                        break block5;
                    }
                }
                xMLEvent = this.reader.peek();
            }
        }
    }
}

