/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding;

import java.lang.reflect.Array;
import weblogic.utils.AssertionError;
import weblogic.xml.schema.binding.DeserializationContext;
import weblogic.xml.schema.binding.DeserializationException;
import weblogic.xml.schema.binding.Deserializer;
import weblogic.xml.schema.binding.RuntimeUtils;
import weblogic.xml.schema.binding.SerializationContext;
import weblogic.xml.schema.binding.SerializationException;
import weblogic.xml.schema.binding.Serializer;
import weblogic.xml.schema.binding.SoapArrayCodecBase;
import weblogic.xml.schema.binding.util.runtime.Accumulator;
import weblogic.xml.schema.binding.util.runtime.ObjectRefTable;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public abstract class SequenceCodecBase
extends SoapArrayCodecBase {
    private static final boolean DEBUG = false;
    private static final boolean ASSERT = false;

    public Object deserialize(XMLName xMLName, Attribute attribute, DeserializationContext deserializationContext) throws DeserializationException {
        throw new AssertionError("UNIMP");
    }

    protected abstract Accumulator createAccumulator(DeserializationContext var1);

    protected abstract Deserializer getSequenceElementDeserializer(DeserializationContext var1) throws DeserializationException;

    protected abstract Serializer getSequenceElementSerializer(SerializationContext var1) throws SerializationException;

    protected abstract XMLName getSequenceElementXMLName();

    public Object deserialize(XMLName xMLName, XMLInputStream xMLInputStream, DeserializationContext deserializationContext) throws DeserializationException {
        try {
            if (xMLInputStream.skip(2)) {
                if (RuntimeUtils.checkForXsiNil((StartElement)xMLInputStream.peek())) {
                    xMLInputStream.skipElement();
                    return null;
                }
                if (!this.isCompleteType()) {
                    return this.deserialize_incomplete(xMLName, xMLInputStream, deserializationContext);
                }
                StartElement startElement = (StartElement)xMLInputStream.next();
                String string = SequenceCodecBase.checkForRef(startElement);
                if (string != null) {
                    return SequenceCodecBase.deserializeReferredObject(string, this, xMLName, xMLInputStream, deserializationContext);
                }
                Accumulator accumulator = this.createAccumulator(deserializationContext);
                Deserializer deserializer = this.getSequenceElementDeserializer(deserializationContext);
                XMLName xMLName2 = this.getSequenceElementXMLName();
                Object object = SequenceCodecBase.getNextStartElement(xMLInputStream);
                while (object != null) {
                    Object object2 = deserializer.deserialize(xMLName2, xMLInputStream, deserializationContext);
                    accumulator.append(object2);
                    object = SequenceCodecBase.getNextStartElement(xMLInputStream);
                }
                object = this.getFinalObject(accumulator);
                this.checkMinMaxOccurs(object);
                return object;
            }
            throw new DeserializationException("bad xml");
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DeserializationException(xMLStreamException.getMessage(), xMLStreamException);
        }
    }

    public Object deserialize_incomplete(XMLName xMLName, XMLInputStream xMLInputStream, DeserializationContext deserializationContext) throws DeserializationException, XMLStreamException {
        StartElement startElement = (StartElement)xMLInputStream.peek();
        String string = SequenceCodecBase.checkForRef(startElement);
        if (string != null) {
            xMLInputStream.next();
            return SequenceCodecBase.deserializeReferredObject(string, this, xMLName, xMLInputStream, deserializationContext);
        }
        Accumulator accumulator = this.createAccumulator(deserializationContext);
        Deserializer deserializer = this.getSequenceElementDeserializer(deserializationContext);
        XMLName xMLName2 = this.getSequenceElementXMLName();
        String string2 = xMLName2.getLocalName();
        Object object = startElement;
        while (object != null && string2.equals(object.getName().getLocalName())) {
            Object object2 = deserializer.deserialize(xMLName2, xMLInputStream, deserializationContext);
            accumulator.append(object2);
            object = SequenceCodecBase.getNextStartElement(xMLInputStream, false);
        }
        object = this.getFinalObject(accumulator);
        this.checkMinMaxOccurs(object);
        return object;
    }

    protected long getMinOccurs() {
        return 1L;
    }

    protected long getMaxOccurs() {
        return -1L;
    }

    protected Object getFinalObject(Accumulator accumulator) {
        return accumulator.getFinalArray();
    }

    protected int checkMinMaxOccurs(Object object) throws DeserializationException {
        int n = this.getSequenceObjectLength(object);
        if (this.isCompleteType()) {
            return n;
        }
        long l = this.getMinOccurs();
        if ((long)n < l) {
            String string = "element " + this.getSequenceElementXMLName() + " did not meet minOccurs constraint of " + l + " -- found only " + n;
            throw new DeserializationException(string);
        }
        long l2 = this.getMaxOccurs();
        if (l2 > 0L && (long)n > l2) {
            String string = "element " + this.getSequenceElementXMLName() + " did not meet maxOccurs constraint of " + l2 + " -- found " + n;
            throw new DeserializationException(string);
        }
        return n;
    }

    protected int getSequenceObjectLength(Object object) {
        return Array.getLength(object);
    }

    protected int checkMinMaxOccursSer(Object object) throws SerializationException {
        try {
            return this.checkMinMaxOccurs(object);
        }
        catch (DeserializationException deserializationException) {
            throw new SerializationException(deserializationException.getMessage());
        }
    }

    protected void gatherContents(Object object, ObjectRefTable.Entry entry, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
        if (SequenceCodecBase.isArrayOfPrimitive(object)) {
            return;
        }
        this.doContents(object, entry, xMLOutputStream, serializationContext);
    }

    protected void doContents(Object object, ObjectRefTable.Entry entry, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
        Serializer serializer = this.getSequenceElementSerializer(serializationContext);
        XMLName xMLName = this.getSequenceElementXMLName();
        int n = this.checkMinMaxOccursSer(object);
        serializationContext.setInAttribute(false);
        boolean bl = serializationContext.isQualifyElements();
        boolean bl2 = this.isFormQualified();
        for (int i = 0; i < n; ++i) {
            serializationContext.setQualifyElements(bl2);
            Object object2 = Array.get(object, i);
            serializer.serialize(object2, xMLName, xMLOutputStream, serializationContext);
        }
        serializationContext.setQualifyElements(bl);
    }

    protected void writeContents(Object object, ObjectRefTable.Entry entry, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException, XMLStreamException {
        String string = null;
        if (SequenceCodecBase.isSoapEncoding(serializationContext)) {
            string = this.writeSoapArrayType(object, xMLOutputStream, serializationContext);
        }
        this.doContents(object, entry, xMLOutputStream, serializationContext);
        SequenceCodecBase.removePrefixFromMap(string, serializationContext);
    }

    protected boolean writeXsiType(SerializationContext serializationContext) {
        return !SequenceCodecBase.isSoapEncoding(serializationContext);
    }
}

