/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import weblogic.utils.Debug;
import weblogic.xml.schema.binding.ClassContext;
import weblogic.xml.schema.binding.ClassContextFactory;
import weblogic.xml.schema.binding.CodecBase;
import weblogic.xml.schema.binding.DeserializationContext;
import weblogic.xml.schema.binding.DeserializationException;
import weblogic.xml.schema.binding.Deserializer;
import weblogic.xml.schema.binding.SchemaContext;
import weblogic.xml.schema.binding.SchemaContextFactory;
import weblogic.xml.schema.binding.SerializationContext;
import weblogic.xml.schema.binding.SerializationException;
import weblogic.xml.schema.binding.SerializationPhase;
import weblogic.xml.schema.binding.Serializer;
import weblogic.xml.schema.binding.TypeMapping;
import weblogic.xml.schema.binding.TypeMappingEntry;
import weblogic.xml.schema.binding.util.NamespacePrefixMap;
import weblogic.xml.schema.binding.util.StdNamespace;
import weblogic.xml.schema.binding.util.runtime.ObjectRefTable;
import weblogic.xml.schema.binding.util.runtime.SerializerStartElement;
import weblogic.xml.schema.model.ExpName;
import weblogic.xml.schema.types.XSDBoolean;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public final class RuntimeUtils {
    private static final boolean DEBUG = false;
    private static final boolean ASSERT = false;
    public static final XMLName XSI_NIL;
    static final XMLName XSI_TYPE;
    static final Attribute NIL_ATT;

    public static void writeTrailingBlocks(XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
        serializationContext.setPhase(SerializationPhase.FINAL_WRITE);
        serializationContext.setInTopLevelElement(true);
        ObjectRefTable objectRefTable = serializationContext.getObjectRefTable();
        Iterator iterator = objectRefTable.getMultiRefObjects();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            ObjectRefTable.Entry entry = objectRefTable.get(e);
            Serializer serializer = entry.getSerializer();
            XMLName xMLName = entry.getName();
            serializationContext.setInTopLevelElement(true);
            serializer.serialize(e, xMLName, xMLOutputStream, serializationContext);
        }
    }

    public static boolean checkForXsiNil(StartElement startElement) throws DeserializationException {
        Attribute attribute = startElement.getAttributeByName(XSI_NIL);
        if (attribute == null) {
            return false;
        }
        String string = attribute.getValue();
        if (string == null) {
            return false;
        }
        return XSDBoolean.convertXml(string);
    }

    public static XMLName getXsiType(StartElement startElement) throws DeserializationException {
        Attribute attribute = startElement.getAttributeByName(XSI_TYPE);
        if (attribute == null) {
            return null;
        }
        String string = attribute.getValue();
        if (string == null) {
            return null;
        }
        ExpName expName = ExpName.createFromQName(string);
        String string2 = expName.getPrefix();
        Map map = startElement.getNamespaceMap();
        if (map == null) {
            return null;
        }
        String string3 = (String)map.get(string2);
        expName.setUri(string3);
        return expName;
    }

    public static Serializer lookup_serializer(Class clazz, SerializationContext serializationContext) throws SerializationException {
        TypeMapping typeMapping = serializationContext.getMapping();
        XMLName xMLName = typeMapping.getXMLNameFromClass(clazz);
        if (xMLName == null) {
            String string = "type mapping lookup failure on class=" + clazz + " TypeMapping=" + typeMapping;
            throw new SerializationException(string);
        }
        ClassContext classContext = ClassContextFactory.newInstance().createClassContext(xMLName);
        return RuntimeUtils.lookup_serializer(clazz, classContext, serializationContext);
    }

    public static Serializer lookup_serializer(Class clazz, ClassContext classContext, SerializationContext serializationContext) throws SerializationException {
        TypeMappingEntry typeMappingEntry = serializationContext.getMapping().get(clazz, classContext);
        if (typeMappingEntry == null) {
            String string = "mapping lookup failure. class=" + clazz + " class context=" + classContext;
            throw new SerializationException(string);
        }
        SerializerFactory serializerFactory = typeMappingEntry.getSerializer();
        if (serializerFactory == null) {
            String string = "null serializer for " + typeMappingEntry;
            throw new SerializationException(string);
        }
        Serializer serializer = (Serializer)serializerFactory.getSerializerAs("stream");
        return serializer;
    }

    public static void invoke_serializer(Object object, Class clazz, XMLName xMLName, XMLName xMLName2, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
        ClassContext classContext = ClassContextFactory.newInstance().createClassContext(xMLName);
        RuntimeUtils.invoke_serializer(object, clazz, xMLName2, classContext, xMLOutputStream, serializationContext);
    }

    public static void invoke_serializer(Object object, Class clazz, XMLName xMLName, ClassContext classContext, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
        Serializer serializer = RuntimeUtils.lookup_serializer(clazz, classContext, serializationContext);
        serializer.serialize(object, xMLName, xMLOutputStream, serializationContext);
    }

    public static void invoke_serializer(Object object, Class clazz, XMLName xMLName, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException {
        Serializer serializer = RuntimeUtils.lookup_serializer(clazz, serializationContext);
        serializer.serialize(object, xMLName, xMLOutputStream, serializationContext);
    }

    public static String arrayToString(Object object) {
        if (object == null) {
            return "null";
        }
        if (!object.getClass().isArray()) {
            return object.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = -1 + Array.getLength(object);
        for (int i = 0; i <= n; ++i) {
            Object object2 = Array.get(object, i);
            stringBuffer.append(object2 == object ? "(this Array)" : RuntimeUtils.arrayToString(object2));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static int arrayHashCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (!object.getClass().isArray()) {
            return object.hashCode();
        }
        int n = 17;
        int n2 = Array.getLength(object);
        for (int i = 0; i < n2; ++i) {
            Object object2 = Array.get(object, i);
            n = 37 * n + (object2 == null ? 0 : RuntimeUtils.arrayHashCode(object2));
        }
        return n;
    }

    public static boolean compareObjects(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        if (object.getClass().isArray()) {
            return RuntimeUtils.compareArrayObjects(object, object2);
        }
        return object.equals(object2);
    }

    public static boolean compareArrayObjects(Object object, Object object2) {
        if (object instanceof Object[] && object2 instanceof Object[]) {
            return Arrays.equals((Object[])object, (Object[])object2);
        }
        if (object instanceof int[] && object2 instanceof int[]) {
            return Arrays.equals((int[])object, (int[])object2);
        }
        if (object instanceof byte[] && object2 instanceof byte[]) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        if (object instanceof long[] && object2 instanceof long[]) {
            return Arrays.equals((long[])object, (long[])object2);
        }
        if (object instanceof short[] && object2 instanceof short[]) {
            return Arrays.equals((short[])object, (short[])object2);
        }
        if (object instanceof char[] && object2 instanceof char[]) {
            return Arrays.equals((char[])object, (char[])object2);
        }
        if (object instanceof double[] && object2 instanceof double[]) {
            return Arrays.equals((double[])object, (double[])object2);
        }
        if (object instanceof float[] && object2 instanceof float[]) {
            return Arrays.equals((float[])object, (float[])object2);
        }
        if (object instanceof boolean[] && object2 instanceof boolean[]) {
            return Arrays.equals((boolean[])object, (boolean[])object2);
        }
        return false;
    }

    public static Object invoke_deserializer(XMLName xMLName, XMLName xMLName2, XMLInputStream xMLInputStream, DeserializationContext deserializationContext) throws DeserializationException {
        Deserializer deserializer = RuntimeUtils.lookup_deserializer(xMLName2, deserializationContext);
        return deserializer.deserialize(xMLName, xMLInputStream, deserializationContext);
    }

    public static Object invoke_deserializer(XMLName xMLName, XMLName xMLName2, Class clazz, XMLInputStream xMLInputStream, DeserializationContext deserializationContext) throws DeserializationException {
        SchemaContext schemaContext = SchemaContextFactory.newInstance().createSchemaContext(clazz.getName());
        TypeMappingEntry typeMappingEntry = deserializationContext.getMapping().get(xMLName2, schemaContext);
        if (typeMappingEntry == null) {
            String string = "mapping lookup failure for xml type " + xMLName2 + " and java " + clazz;
            throw new DeserializationException(string);
        }
        return RuntimeUtils.invoke_deserializer(xMLName, xMLInputStream, deserializationContext, typeMappingEntry);
    }

    public static Object lookup_deserializer(XMLName xMLName, XMLName xMLName2, Class clazz, DeserializationContext deserializationContext) throws DeserializationException {
        SchemaContext schemaContext = SchemaContextFactory.newInstance().createSchemaContext(clazz.getName());
        TypeMappingEntry typeMappingEntry = deserializationContext.getMapping().get(xMLName2, schemaContext);
        if (typeMappingEntry == null) {
            String string = "mapping lookup failure for xml type " + xMLName2 + " and java " + clazz;
            throw new DeserializationException(string);
        }
        return RuntimeUtils.getDeserializer(typeMappingEntry);
    }

    private static Deserializer getDeserializer(TypeMappingEntry typeMappingEntry) throws DeserializationException {
        DeserializerFactory deserializerFactory = typeMappingEntry.getDeserializer();
        if (deserializerFactory == null) {
            throw new DeserializationException("deserialzer is null in entry: " + typeMappingEntry);
        }
        Deserializer deserializer = (Deserializer)deserializerFactory.getDeserializerAs("stream");
        return deserializer;
    }

    public static Deserializer lookup_deserializer(XMLName xMLName, XMLName xMLName2, SchemaContext schemaContext, DeserializationContext deserializationContext) throws DeserializationException {
        TypeMappingEntry typeMappingEntry = deserializationContext.getMapping().get(xMLName2, schemaContext);
        if (typeMappingEntry == null) {
            String string = "mapping lookup failure for xml type " + xMLName2 + " and java type " + schemaContext.getJavaType();
            throw new DeserializationException(string);
        }
        return RuntimeUtils.getDeserializer(typeMappingEntry);
    }

    public static Object invoke_deserializer(XMLName xMLName, XMLName xMLName2, SchemaContext schemaContext, XMLInputStream xMLInputStream, DeserializationContext deserializationContext) throws DeserializationException {
        TypeMappingEntry typeMappingEntry = deserializationContext.getMapping().get(xMLName2, schemaContext);
        if (typeMappingEntry == null) {
            String string = "mapping lookup failure for xml type " + xMLName2 + " and java type " + schemaContext.getJavaType();
            throw new DeserializationException(string);
        }
        return RuntimeUtils.invoke_deserializer(xMLName, xMLInputStream, deserializationContext, typeMappingEntry);
    }

    public static Object invoke_deserializer(XMLName xMLName, XMLInputStream xMLInputStream, DeserializationContext deserializationContext, TypeMappingEntry typeMappingEntry) throws DeserializationException {
        Deserializer deserializer = RuntimeUtils.getDeserializer(typeMappingEntry);
        return deserializer.deserialize(xMLName, xMLInputStream, deserializationContext);
    }

    public static Deserializer lookup_deserializer(XMLName xMLName, DeserializationContext deserializationContext) throws DeserializationException {
        TypeMapping typeMapping = deserializationContext.getMapping();
        Class clazz = typeMapping.getClassFromXMLName(xMLName);
        if (clazz == null) {
            String string = "type mapping lookup failure on type=" + xMLName + " TypeMapping=" + typeMapping;
            throw new DeserializationException(string);
        }
        SchemaContext schemaContext = SchemaContextFactory.newInstance().createSchemaContext(clazz.getName());
        return RuntimeUtils.lookup_deserializer(xMLName, schemaContext, deserializationContext);
    }

    public static Deserializer lookup_deserializer(XMLName xMLName, SchemaContext schemaContext, DeserializationContext deserializationContext) throws DeserializationException {
        TypeMappingEntry typeMappingEntry = deserializationContext.getMapping().get(xMLName, schemaContext);
        if (typeMappingEntry == null) {
            String string = "mapping lookup failure. type=" + xMLName + " schema context=" + schemaContext;
            throw new DeserializationException(string);
        }
        return RuntimeUtils.getDeserializer(typeMappingEntry);
    }

    public static Object invoke_deserializer(XMLName xMLName, XMLName xMLName2, SchemaContext schemaContext, Attribute attribute, DeserializationContext deserializationContext) throws DeserializationException {
        TypeMappingEntry typeMappingEntry = deserializationContext.getMapping().get(xMLName2, schemaContext);
        return RuntimeUtils.invoke_deserializer(xMLName, attribute, deserializationContext, typeMappingEntry);
    }

    public static Object invoke_deserializer(XMLName xMLName, Attribute attribute, DeserializationContext deserializationContext, TypeMappingEntry typeMappingEntry) throws DeserializationException {
        Deserializer deserializer = RuntimeUtils.getDeserializer(typeMappingEntry);
        return deserializer.deserialize(xMLName, attribute, deserializationContext);
    }

    public static void serializeNullElement(XMLName xMLName, XMLOutputStream xMLOutputStream, SerializationContext serializationContext) throws SerializationException, XMLStreamException {
        Attribute attribute = null;
        String string = xMLName.getNamespaceUri();
        if (serializationContext.isQualifyElements() && string != null) {
            String string2 = serializationContext.getPrefixForUri(string);
            if (string2 == null) {
                string2 = serializationContext.getNextRandomPrefix();
                attribute = ElementFactory.createNamespaceAttribute(string2, string);
            }
            xMLName = ElementFactory.createXMLName(string, xMLName.getLocalName(), string2);
        }
        xMLOutputStream.add(new SerializerStartElement(xMLName));
        if (attribute != null) {
            xMLOutputStream.add(attribute);
        }
        xMLOutputStream.add(NIL_ATT);
        xMLOutputStream.add(ElementFactory.createEndElement(xMLName));
    }

    public static XMLName getXmlType(CodecBase codecBase) {
        return codecBase.getXmlType();
    }

    static {
        String string;
        StdNamespace stdNamespace = StdNamespace.instance();
        Map map = NamespacePrefixMap.createDefaultMap();
        String string2 = (String)map.get(string = stdNamespace.schemaInstance());
        Debug.assertion(string2 != null, "null prefix for " + string);
        XSI_NIL = ElementFactory.createXMLName(string, "nil", string2);
        XSI_TYPE = ElementFactory.createXMLName(string, "type", string2);
        NIL_ATT = ElementFactory.createAttribute(XSI_NIL, "true");
    }
}

