/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding;

import java.math.BigDecimal;
import weblogic.utils.Debug;
import weblogic.xml.schema.binding.DeserializationException;

public final class FacetUtils {
    private static final boolean ASSERT = true;

    public static void checkTotalDigitsFacet(Number number, long l) throws DeserializationException {
        String string = number.toString();
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!FacetUtils.isXmlDigit(c)) continue;
            ++n2;
        }
        if ((long)n2 > l) {
            String string2 = "value: " + number + " must have totalDigits <= " + l;
            throw new DeserializationException(string2);
        }
    }

    public static void checkFractionDigitsFacet(BigDecimal bigDecimal, long l) throws DeserializationException {
        if ((long)bigDecimal.scale() > l) {
            String string = "value: " + bigDecimal + " must have fractionDigits <= " + l;
            throw new DeserializationException(string);
        }
    }

    private static boolean isXmlDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static void checkLengthFacet(String string, long l) throws DeserializationException {
        if ((long)string.length() != l) {
            String string2 = "string length must equal " + l + ".  Invalid string: \"" + string + "\"";
            throw new DeserializationException(string2);
        }
    }

    public static void checkMinLengthFacet(String string, long l) throws DeserializationException {
        if ((long)string.length() < l) {
            String string2 = "string length must be at least " + l + ".  Invalid string: \"" + string + "\"";
            throw new DeserializationException(string2);
        }
    }

    public static void checkMaxLengthFacet(String string, long l) throws DeserializationException {
        if ((long)string.length() > l) {
            String string2 = "string length must be at most " + l + ".  Invalid string: \"" + string + "\"";
            throw new DeserializationException(string2);
        }
    }

    public static void checkMaxInclusiveFacet(Number number, Number number2) throws DeserializationException {
        Debug.assertion(number.getClass().equals(number2.getClass()));
        if (((Comparable)((Object)number)).compareTo(number2) > 0) {
            String string = "value: " + number + " must be <= than " + number2;
            throw new DeserializationException(string);
        }
    }

    public static void checkMaxInclusiveFacet(long l, long l2) throws DeserializationException {
        if (l > l2) {
            String string = "value: " + l + " must be <= than " + l2;
            throw new DeserializationException(string);
        }
    }

    public static void checkMaxInclusiveFacet(double d, double d2) throws DeserializationException {
        if (d > d2) {
            String string = "value: " + d + " must be <= than " + d2;
            throw new DeserializationException(string);
        }
    }

    public static void checkMaxExclusiveFacet(Number number, Number number2) throws DeserializationException {
        Debug.assertion(number.getClass().equals(number2.getClass()));
        if (((Comparable)((Object)number)).compareTo(number2) >= 0) {
            String string = "value: " + number + " must be < than " + number2;
            throw new DeserializationException(string);
        }
    }

    public static void checkMaxExclusiveFacet(long l, long l2) throws DeserializationException {
        if (l >= l2) {
            String string = "value: " + l + " must be < than " + l2;
            throw new DeserializationException(string);
        }
    }

    public static void checkMaxExclusiveFacet(double d, double d2) throws DeserializationException {
        if (d >= d2) {
            String string = "value: " + d + " must be < than " + d2;
            throw new DeserializationException(string);
        }
    }

    public static void checkMinInclusiveFacet(Number number, Number number2) throws DeserializationException {
        Debug.assertion(number.getClass().equals(number2.getClass()));
        if (((Comparable)((Object)number)).compareTo(number2) < 0) {
            String string = "value: " + number + " must be >= than " + number2;
            throw new DeserializationException(string);
        }
    }

    public static void checkMinInclusiveFacet(long l, long l2) throws DeserializationException {
        if (l < l2) {
            String string = "value: " + l + " must be >= than " + l2;
            throw new DeserializationException(string);
        }
    }

    public static void checkMinInclusiveFacet(double d, double d2) throws DeserializationException {
        if (d < d2) {
            String string = "value: " + d + " must be >= than " + d2;
            throw new DeserializationException(string);
        }
    }

    public static void checkMinExclusiveFacet(Number number, Number number2) throws DeserializationException {
        Debug.assertion(number.getClass().equals(number2.getClass()));
        if (((Comparable)((Object)number)).compareTo(number2) <= 0) {
            String string = "value: " + number + " must be > than " + number2;
            throw new DeserializationException(string);
        }
    }

    public static void checkMinExclusiveFacet(long l, long l2) throws DeserializationException {
        if (l <= l2) {
            String string = "value: " + l + " must be > than " + l2;
            throw new DeserializationException(string);
        }
    }

    public static void checkMinExclusiveFacet(double d, double d2) throws DeserializationException {
        if (d <= d2) {
            String string = "value: " + d + " must be > than " + d2;
            throw new DeserializationException(string);
        }
    }
}

