/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.schema.binding;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import weblogic.xml.schema.binding.internal.codegen.ArrayUtils;

public class ClassLoadingUtils {
    private static final Map primMap = new HashMap();

    public static Class loadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        Class clazz = ClassLoadingUtils.loadPrimitiveClass(string);
        if (clazz != null) {
            return clazz;
        }
        Class clazz2 = ClassLoadingUtils.loadArrayClass(string, classLoader);
        if (clazz2 != null) {
            return clazz2;
        }
        return ClassLoadingUtils.loadNonArrayClass(string, classLoader);
    }

    private static Class loadPrimitiveClass(String string) {
        return (Class)primMap.get(string);
    }

    private static Class loadNonArrayClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        Class clazz = ClassLoadingUtils.loadPrimitiveClass(string);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        if (classLoader2 == null) {
            classLoader2 = classLoader;
        }
        try {
            return classLoader2.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Class.forName(string);
        }
    }

    private static Class loadArrayClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = ArrayUtils.getArrayComponentNameFromDecl(stringBuffer, string);
        if (n < 1) {
            return null;
        }
        int[] nArray = new int[n];
        Arrays.fill(nArray, 1);
        Class clazz = ClassLoadingUtils.loadNonArrayClass(stringBuffer.toString(), classLoader);
        Object object = Array.newInstance(clazz, nArray);
        return object.getClass();
    }

    static {
        primMap.put(Boolean.TYPE.getName(), Boolean.TYPE);
        primMap.put(Character.TYPE.getName(), Character.TYPE);
        primMap.put(Byte.TYPE.getName(), Byte.TYPE);
        primMap.put(Short.TYPE.getName(), Short.TYPE);
        primMap.put(Integer.TYPE.getName(), Integer.TYPE);
        primMap.put(Long.TYPE.getName(), Long.TYPE);
        primMap.put(Float.TYPE.getName(), Float.TYPE);
        primMap.put(Double.TYPE.getName(), Double.TYPE);
    }
}

