/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.stream;

import java.io.Writer;
import weblogic.xml.babel.stream.XMLWriter;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.CharacterData;
import weblogic.xml.stream.EndElement;
import weblogic.xml.stream.Space;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLStreamException;

public class XMLDataWriter
extends XMLWriter {
    private boolean begin = true;
    private boolean wasCharacterData = false;
    private boolean wasStartElement = true;

    public void write(StartElement startElement) throws XMLStreamException {
        this.write('<');
        this.write(startElement.getName());
        if (this.writeElementNameSpaces) {
            this.write(startElement.getAttributesAndNamespaces());
        } else {
            this.write(startElement.getAttributes());
        }
        this.write('>');
    }

    public void write(EndElement endElement) throws XMLStreamException {
        this.write("</");
        this.write(endElement.getName());
        this.write(">");
    }

    public void tab(int n) throws XMLStreamException {
        for (int i = 0; i < n; ++i) {
            this.write(' ');
        }
    }

    public boolean write(XMLEvent xMLEvent) throws XMLStreamException {
        switch (xMLEvent.getType()) {
            case 2: {
                if (!this.wasCharacterData && !this.begin || !this.wasStartElement) {
                    this.write('\n');
                    this.tab(this.elementLevel);
                }
                super.write(xMLEvent);
                ++this.elementLevel;
                this.wasStartElement = true;
                this.wasCharacterData = false;
                this.begin = false;
                break;
            }
            case 4: {
                if (!this.wasCharacterData || !this.wasStartElement) {
                    this.write('\n');
                    this.tab(this.elementLevel - 1);
                }
                super.write(xMLEvent);
                --this.elementLevel;
                this.wasStartElement = false;
                break;
            }
            case 64: {
                super.write(xMLEvent);
                break;
            }
            case 16: {
                this.wasCharacterData = true;
                super.write((CharacterData)xMLEvent);
                break;
            }
            case 256: {
                super.write(xMLEvent);
                break;
            }
            default: {
                this.wasCharacterData = false;
                super.write(xMLEvent);
            }
        }
        return true;
    }

    public void writeEmpty(StartElement startElement) throws XMLStreamException {
        if (!this.wasCharacterData && !this.begin || !this.wasStartElement) {
            this.write('\n');
            this.tab(this.elementLevel);
        }
        super.writeEmpty(startElement);
        this.wasStartElement = true;
        this.wasCharacterData = false;
        this.begin = false;
    }

    public void write(Space space) throws XMLStreamException {
    }

    public void write(AttributeIterator attributeIterator) throws XMLStreamException {
        while (attributeIterator.hasNext()) {
            this.tab(this.elementLevel + 1);
            this.write(" ");
            this.write(attributeIterator.next());
            if (!attributeIterator.hasNext()) continue;
            this.write('\n');
        }
    }

    public static XMLWriter getDebugWriter(Writer writer) throws XMLStreamException {
        XMLDataWriter xMLDataWriter = new XMLDataWriter();
        xMLDataWriter.setWriter(writer);
        xMLDataWriter.setWriteHeader(false);
        xMLDataWriter.setWriteElementNameSpaces(true);
        xMLDataWriter.setWriteAll(false);
        xMLDataWriter.setShowNamespaceBindings(false);
        xMLDataWriter.setNormalizeWhiteSpace(true);
        return xMLDataWriter;
    }
}

